/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.rse.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionChangeEvent;
import org.eclipse.ptp.remote.core.IRemoteConnectionChangeListener;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.rse.core.Activator;
import org.eclipse.ptp.remote.rse.core.RSEConnection;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;

public class RSEConnectionManager
implements IRemoteConnectionManager {
    private final ListenerList listeners = new ListenerList();
    private IFileSystem fileSystem = null;
    private ISystemRegistry registry;
    private Map<IHost, IRemoteConnection> connections = new HashMap<IHost, IRemoteConnection>();

    public RSEConnectionManager(ISystemRegistry registry) {
        try {
            RSECorePlugin.waitForInitCompletion();
        }
        catch (InterruptedException e) {
            Activator.log(e);
            return;
        }
        this.registry = registry;
        try {
            this.fileSystem = EFS.getFileSystem((String)"rse");
        }
        catch (CoreException coreException) {}
    }

    public void addConnectionChangeListener(IRemoteConnectionChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    public void fireConnectionChangeEvent(IRemoteConnectionChangeEvent event) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IRemoteConnectionChangeListener)listener).connectionChanged(event);
            ++n2;
        }
    }

    public IRemoteConnection getConnection(String name) {
        IRemoteConnection[] iRemoteConnectionArray = this.getConnections();
        int n = iRemoteConnectionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRemoteConnection conn = iRemoteConnectionArray[n2];
            IHost host = ((RSEConnection)conn).getHost();
            if (host.getName().equals(name)) {
                return conn;
            }
            ++n2;
        }
        return null;
    }

    public IRemoteConnection[] getConnections() {
        this.refreshConnections();
        return this.connections.values().toArray(new IRemoteConnection[this.connections.size()]);
    }

    public void refreshConnections() {
        if (this.fileSystem != null) {
            IHost[] hosts;
            IHost[] iHostArray = hosts = this.registry.getHostsBySubSystemConfigurationCategory("shells");
            int n = hosts.length;
            int n2 = 0;
            while (n2 < n) {
                RSEConnection conn;
                IHost host = iHostArray[n2];
                if (!this.connections.containsKey(host) && (conn = new RSEConnection(host, this.fileSystem, this)).initialize()) {
                    this.connections.put(host, conn);
                }
                ++n2;
            }
        }
    }

    public void removeConnection(IRemoteConnection conn) {
        if (conn instanceof RSEConnection) {
            ((RSEConnection)conn).dispose();
        }
        this.connections.remove(conn);
    }

    public void removeConnectionChangeListener(IRemoteConnectionChangeListener listener) {
        this.listeners.remove((Object)listener);
    }
}

