/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.debug.launch.remote;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.remotetools.core.IRemoteConnection;
import org.eclipse.ptp.remotetools.core.IRemoteExecutionManager;
import org.eclipse.ptp.remotetools.core.IRemoteScript;
import org.eclipse.ptp.remotetools.core.IRemoteScriptExecution;
import org.eclipse.ptp.remotetools.exception.CancelException;
import org.eclipse.ptp.remotetools.exception.RemoteConnectionException;
import org.eclipse.ptp.remotetools.exception.RemoteExecutionException;

public class RemoteProcess
extends Process {
    IRemoteConnection conn = null;
    String cmdLine;
    String id;
    IRemoteExecutionManager manager;
    IRemoteScriptExecution exec;
    boolean init;

    public RemoteProcess(IRemoteConnection conn, String cmdLine, String id) throws CoreException {
        this.cmdLine = cmdLine;
        if (conn == null) {
            Status st = new Status(4, id, 1101, "Error connecting to target", null);
            throw new CoreException((IStatus)st);
        }
        this.conn = conn;
        this.init = true;
        this.manager = this.getExecutionManager();
        this.exec = this.startExecution(this.manager);
    }

    public RemoteProcess(IRemoteExecutionManager manager, String cmdLine, String id) throws CoreException {
        this.cmdLine = cmdLine;
        if (manager == null) {
            Status st = new Status(4, id, 1101, "Error connecting to target", null);
            throw new CoreException((IStatus)st);
        }
        this.init = true;
        this.manager = manager;
        this.exec = this.startExecution(manager);
    }

    public void destroy() {
        if (this.init) {
            this.exec.cancel();
            this.exec.close();
            this.manager.cancel();
            this.init = false;
            this.manager = null;
            this.conn = null;
        }
    }

    public int exitValue() {
        if (this.init && !this.exec.wasFinished()) {
            throw new IllegalThreadStateException();
        }
        if (this.exec != null) {
            return this.exec.getReturnCode();
        }
        return -1;
    }

    public InputStream getErrorStream() {
        return null;
    }

    public InputStream getInputStream() {
        if (this.init) {
            try {
                return this.exec.getInputStreamFromProcessOutputStream();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public OutputStream getOutputStream() {
        if (this.init) {
            try {
                return this.exec.getOutputStreamToProcessInputStream();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public int waitFor() throws InterruptedException {
        if (this.init) {
            try {
                this.exec.waitForEndOfExecution();
            }
            catch (RemoteConnectionException remoteConnectionException) {
                throw new InterruptedException();
            }
            catch (CancelException cancelException) {
                throw new InterruptedException();
            }
            catch (RemoteExecutionException remoteExecutionException) {
                throw new InterruptedException();
            }
            this.destroy();
        }
        return this.exitValue();
    }

    private IRemoteExecutionManager getExecutionManager() throws CoreException {
        IRemoteExecutionManager manager = null;
        if (this.conn != null) {
            try {
                manager = this.conn.createRemoteExecutionManager();
            }
            catch (RemoteConnectionException e) {
                this.init = false;
                Status st = new Status(4, this.id, 1101, "Error connecting to target", (Throwable)e);
                throw new CoreException((IStatus)st);
            }
        } else {
            manager = this.manager;
        }
        return manager;
    }

    private IRemoteScriptExecution startExecution(IRemoteExecutionManager manager) throws CoreException {
        IRemoteScriptExecution exec = null;
        if (manager != null) {
            try {
                manager = this.getExecutionManager();
                IRemoteScript script = manager.getExecutionTools().createScript();
                script.setScript(this.cmdLine);
                exec = manager.getExecutionTools().executeScript(script);
            }
            catch (RemoteConnectionException e) {
                this.init = false;
                Status st = new Status(4, this.id, 1101, "Error connecting to target", (Throwable)e);
                throw new CoreException((IStatus)st);
            }
            catch (RemoteExecutionException e) {
                this.init = false;
                Status st = new Status(4, this.id, 1102, "Error executing operation in target", (Throwable)e);
                throw new CoreException((IStatus)st);
            }
            catch (CancelException e) {
                this.init = false;
                Status st = new Status(4, this.id, 1103, "Canceled", (Throwable)e);
                throw new CoreException((IStatus)st);
            }
        }
        return exec;
    }
}

