/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.actions;

import java.util.List;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.ptp.internal.rdt.ui.callhierarchy.OpenCallHierarchyAction;
import org.eclipse.ptp.internal.rdt.ui.search.actions.OpenDeclarationsAction;
import org.eclipse.ptp.internal.rdt.ui.typehierarchy.OpenTypeHierarchyAction;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.texteditor.ITextEditor;

public class OpenViewActionGroup
extends ActionGroup {
    private boolean fEditorIsOwner;
    private boolean fSuppressTypeHierarchy;
    private boolean fSuppressCallHierarchy;
    private boolean fSuppressProperties;
    private IWorkbenchSite fSite;
    private String fGroupName = "group.open";
    private OpenTypeHierarchyAction fOpenTypeHierarchy;
    private PropertyDialogAction fOpenPropertiesDialog;
    private OpenCallHierarchyAction fOpenCallHierarchy;
    private OpenDeclarationsAction fOpenDeclaration;

    public OpenViewActionGroup(Page page) {
        this.createSiteActions((IWorkbenchSite)page.getSite(), null);
    }

    public OpenViewActionGroup(Page page, CEditor editor) {
        this.createSiteActions((IWorkbenchSite)page.getSite(), editor);
    }

    public OpenViewActionGroup(IWorkbenchPart part) {
        this.createSiteActions((IWorkbenchSite)part.getSite(), null);
    }

    public OpenViewActionGroup(ITextEditor part) {
        this.fEditorIsOwner = true;
        this.fOpenTypeHierarchy = new OpenTypeHierarchyAction(part);
        this.fOpenTypeHierarchy.setActionDefinitionId("org.eclipse.cdt.ui.edit.open.type.hierarchy");
        part.setAction("OpenTypeHierarchy", (IAction)this.fOpenTypeHierarchy);
        this.fOpenCallHierarchy = new OpenCallHierarchyAction(part);
        this.fOpenCallHierarchy.setActionDefinitionId("org.eclipse.cdt.ui.edit.open.call.hierarchy");
        part.setAction("OpenCallHierarchy", (IAction)this.fOpenCallHierarchy);
        if (part instanceof CEditor) {
            this.fOpenDeclaration = new OpenDeclarationsAction((CEditor)part);
            this.fOpenDeclaration.setActionDefinitionId("org.eclipse.cdt.ui.edit.opendecl");
            part.setAction("OpenDeclarations", (IAction)this.fOpenDeclaration);
        }
        this.initialize((IWorkbenchSite)part.getEditorSite());
    }

    private void createSiteActions(IWorkbenchSite site, CEditor editor) {
        this.fOpenTypeHierarchy = new OpenTypeHierarchyAction(site);
        this.fOpenTypeHierarchy.setActionDefinitionId("org.eclipse.cdt.ui.edit.open.type.hierarchy");
        this.fOpenCallHierarchy = new OpenCallHierarchyAction(site);
        this.fOpenCallHierarchy.setActionDefinitionId("org.eclipse.cdt.ui.edit.open.call.hierarchy");
        if (editor != null) {
            this.fOpenDeclaration = new OpenDeclarationsAction(editor);
            this.fOpenDeclaration.setActionDefinitionId("org.eclipse.cdt.ui.edit.opendecl");
        }
        this.fOpenPropertiesDialog = new PropertyDialogAction((IShellProvider)site, site.getSelectionProvider());
        this.fOpenPropertiesDialog.setActionDefinitionId("org.eclipse.ui.file.properties");
        this.initialize(site);
    }

    private void initialize(IWorkbenchSite site) {
        this.fSite = site;
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        ISelection selection = provider.getSelection();
        this.fOpenTypeHierarchy.update(selection);
        this.fOpenCallHierarchy.update(selection);
        if (!this.fEditorIsOwner) {
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection ss = (IStructuredSelection)selection;
                this.fOpenPropertiesDialog.selectionChanged(ss);
            } else {
                this.fOpenPropertiesDialog.selectionChanged(selection);
            }
            provider.addSelectionChangedListener((ISelectionChangedListener)this.fOpenTypeHierarchy);
            provider.addSelectionChangedListener((ISelectionChangedListener)this.fOpenCallHierarchy);
        }
    }

    public void fillActionBars(IActionBars actionBar) {
        super.fillActionBars(actionBar);
        this.setGlobalActionHandlers(actionBar);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        IStructuredSelection selection = this.getStructuredSelection();
        if (!this.fEditorIsOwner) {
            Object elem;
            if (this.fOpenDeclaration != null && this.fOpenDeclaration.isEnabled() && selection != null && (elem = selection.getFirstElement()) instanceof ICElement && !(elem instanceof IInclude)) {
                menu.appendToGroup(this.fGroupName, (IAction)this.fOpenDeclaration);
            }
            if (!this.fSuppressTypeHierarchy && this.fOpenTypeHierarchy.isEnabled()) {
                menu.appendToGroup(this.fGroupName, (IAction)this.fOpenTypeHierarchy);
            }
            if (!this.fSuppressCallHierarchy && this.fOpenCallHierarchy.isEnabled()) {
                menu.appendToGroup(this.fGroupName, (IAction)this.fOpenCallHierarchy);
            }
        }
        if (!this.fSuppressProperties && this.fOpenPropertiesDialog != null && this.fOpenPropertiesDialog.isEnabled() && selection != null && this.fOpenPropertiesDialog.isApplicableForSelection(selection)) {
            menu.appendToGroup("group.properties", (IAction)this.fOpenPropertiesDialog);
        }
    }

    public void dispose() {
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        provider.removeSelectionChangedListener((ISelectionChangedListener)this.fOpenTypeHierarchy);
        provider.removeSelectionChangedListener((ISelectionChangedListener)this.fOpenCallHierarchy);
        if (this.fOpenPropertiesDialog != null) {
            this.fOpenPropertiesDialog.dispose();
        }
        super.dispose();
    }

    private void setGlobalActionHandlers(IActionBars actionBars) {
        actionBars.setGlobalActionHandler("org.eclipse.cdt.ui.actions.OpenTypeHierarchy", (IAction)this.fOpenTypeHierarchy);
        actionBars.setGlobalActionHandler("org.eclipse.cdt.ui.actions.OpenCallHierarchy", (IAction)this.fOpenCallHierarchy);
        if (this.fOpenDeclaration != null) {
            actionBars.setGlobalActionHandler("org.eclipse.cdt.ui.actions.OpenDeclaration", (IAction)this.fOpenDeclaration);
        }
        if (this.fOpenPropertiesDialog != null) {
            actionBars.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.fOpenPropertiesDialog);
        }
    }

    private IStructuredSelection getStructuredSelection() {
        ISelection selection;
        if (this.fSite != null && (selection = this.fSite.getSelectionProvider().getSelection()) instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return null;
    }

    public static boolean canActionBeAdded(ISelection selection) {
        if (selection instanceof ITextSelection) {
            return true;
        }
        return OpenViewActionGroup.getElement(selection) != null;
    }

    private static ICElement getElement(ISelection sel) {
        Object element;
        List list;
        if (!sel.isEmpty() && sel instanceof IStructuredSelection && (list = ((IStructuredSelection)sel).toList()).size() == 1 && (element = list.get(0)) instanceof ICElement) {
            return (ICElement)element;
        }
        return null;
    }

    public void setAppendToGroup(String groupName) {
        this.fGroupName = groupName;
    }

    public void setSuppressTypeHierarchy(boolean suppressTypeHierarchy) {
        this.fSuppressTypeHierarchy = suppressTypeHierarchy;
    }

    public void setSuppressCallHierarchy(boolean suppressCallHierarchy) {
        this.fSuppressCallHierarchy = suppressCallHierarchy;
    }

    public void setSuppressProperties(boolean suppressProperties) {
        this.fSuppressProperties = suppressProperties;
    }
}

