/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.environment.ui.deploy.events;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ptp.cell.environment.ui.deploy.debug.Debug;
import org.eclipse.ptp.cell.environment.ui.deploy.events.AbstractCellTargetJob;
import org.eclipse.ptp.cell.environment.ui.deploy.events.ExportJobWrapper;
import org.eclipse.ptp.cell.environment.ui.deploy.events.Messages;
import org.eclipse.ptp.remotetools.core.IRemoteCopyTools;
import org.eclipse.ptp.remotetools.core.IRemoteFileTools;
import org.eclipse.ptp.remotetools.exception.CancelException;
import org.eclipse.ptp.remotetools.exception.RemoteConnectionException;
import org.eclipse.ptp.remotetools.exception.RemoteExecutionException;
import org.eclipse.ptp.remotetools.exception.RemoteOperationException;

class ExportJob
extends AbstractCellTargetJob {
    private final IProgressMonitor monitor;
    ExportJobWrapper wrapper;

    public ExportJob(ExportJobWrapper wrapper, IProgressMonitor monitor) {
        this.monitor = monitor;
        this.wrapper = wrapper;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Debug.POLICY.enter(Debug.DEBUG_JOBS);
        try {
            IRemoteFileTools fileTools = this.executionManager.getRemoteFileTools();
            IRemoteCopyTools copyTools = this.executionManager.getRemoteCopyTools();
            boolean hasDir = false;
            if (this.monitor.isCanceled()) {
                throw new InterruptedException(Messages.ExportJobWrapper_2);
            }
            this.monitor.setTaskName(Messages.ExportJobWrapper_3);
            this.monitor.subTask(Messages.ExportJobWrapper_4);
            hasDir = fileTools.hasDirectory(this.wrapper.remoteDir);
            if (this.monitor.isCanceled()) {
                throw new InterruptedException(Messages.ExportJobWrapper_5);
            }
            this.monitor.worked(1);
            if (!hasDir) {
                boolean createDir = this.wrapper.exportPage.queryQuestion(Messages.ExportJobWrapper_6, Messages.ExportJobWrapper_7);
                if (!createDir) {
                    throw new InvocationTargetException(null, Messages.ExportJobWrapper_9);
                }
                this.monitor.subTask(Messages.ExportJobWrapper_8);
                fileTools.createDirectory(this.wrapper.remoteDir);
            }
            if (this.monitor.isCanceled()) {
                throw new InterruptedException(Messages.ExportJobWrapper_10);
            }
            String localPath = "";
            String localFileName = "";
            String remotePath = this.wrapper.remoteDir;
            this.monitor.worked(1);
            this.monitor.setTaskName(Messages.ExportJobWrapper_11);
            int i = 0;
            while (true) {
                block30: {
                    block33: {
                        block34: {
                            String response;
                            String tempPath;
                            block35: {
                                block32: {
                                    block26: {
                                        Object o;
                                        block31: {
                                            block28: {
                                                File file;
                                                block29: {
                                                    block27: {
                                                        if (i >= this.wrapper.resourcesToCopy.size()) {
                                                            this.monitor.setTaskName(Messages.ExportJobWrapper_17);
                                                            this.monitor.subTask(Messages.ExportJobWrapper_18);
                                                            break;
                                                        }
                                                        if (this.monitor.isCanceled()) {
                                                            throw new InterruptedException(Messages.ExportJobWrapper_12);
                                                        }
                                                        o = this.wrapper.resourcesToCopy.get(i);
                                                        if (!(o instanceof IFile)) break block27;
                                                        IFile iFile = (IFile)o;
                                                        Debug.POLICY.trace(Debug.DEBUG_JOBS, "IFile: {0}", new Object[]{iFile.getFullPath().toOSString()});
                                                        localPath = iFile.getLocation().toString();
                                                        localFileName = iFile.getName();
                                                        if (this.wrapper.createDirStructure) {
                                                            IPath path = iFile.getFullPath().removeLastSegments(1);
                                                            remotePath = String.valueOf(this.wrapper.remoteDir) + path.toString();
                                                            break block26;
                                                        } else {
                                                            remotePath = this.wrapper.remoteDir;
                                                        }
                                                        break block26;
                                                    }
                                                    if (!(o instanceof File)) break block28;
                                                    file = (File)o;
                                                    Debug.POLICY.trace(Debug.DEBUG_JOBS, "File: {0}", new Object[]{file.getAbsolutePath()});
                                                    if (!file.isDirectory()) break block29;
                                                    this.copyDirectory(file, fileTools, this.monitor, "");
                                                    break block30;
                                                }
                                                localPath = file.toString();
                                                localFileName = file.getName();
                                                remotePath = this.wrapper.remoteDir;
                                                break block26;
                                            }
                                            if (!(o instanceof IProject)) break block31;
                                            IProject proj = (IProject)o;
                                            Debug.POLICY.trace(Debug.DEBUG_JOBS, "IProject: {0}", new Object[]{proj.getName()});
                                            this.copyProject(proj, fileTools, this.monitor, "");
                                            break block30;
                                        }
                                        if (!(o instanceof IFolder)) break block26;
                                        IFolder folder = (IFolder)o;
                                        Debug.POLICY.trace(Debug.DEBUG_JOBS, "Folder: {0}", new Object[]{folder.getName()});
                                        this.copyFolder(folder, fileTools, this.monitor, Messages.ExportJobWrapper_13);
                                        break block30;
                                    }
                                    tempPath = String.valueOf(remotePath) + File.separatorChar + localFileName;
                                    this.monitor.subTask(String.valueOf(Messages.ExportJobWrapper_14) + localPath);
                                    if (!this.wrapper.autoOverwrite) break block32;
                                    if (fileTools.hasDirectory(tempPath)) {
                                        fileTools.removeFile(tempPath);
                                    }
                                    copyTools.uploadFileToDir(localPath, remotePath);
                                    break block33;
                                }
                                if (!fileTools.hasFile(tempPath) && !fileTools.hasDirectory(tempPath)) break block34;
                                if (this.wrapper.noToAllOverwrite) break block33;
                                response = this.wrapper.exportPage.queryOverwrite(String.valueOf(localFileName) + Messages.ExportJobWrapper_15 + remotePath);
                                if (!response.equals("ALL")) break block35;
                                this.wrapper.autoOverwrite = true;
                                if (fileTools.hasDirectory(tempPath)) {
                                    fileTools.removeFile(tempPath);
                                }
                                copyTools.uploadFileToDir(localPath, remotePath);
                                break block33;
                            }
                            if (response.equals("YES")) {
                                if (fileTools.hasDirectory(tempPath)) {
                                    fileTools.removeFile(tempPath);
                                }
                                copyTools.uploadFileToDir(localPath, remotePath);
                                break block33;
                            } else {
                                if (response.equals("CANCEL")) {
                                    throw new InterruptedException(Messages.ExportJobWrapper_16);
                                }
                                if (response.equals("NOALL")) {
                                    this.wrapper.noToAllOverwrite = true;
                                }
                            }
                            break block33;
                        }
                        copyTools.uploadFileToDir(localPath, remotePath);
                    }
                    this.monitor.worked(1);
                }
                ++i;
            }
        }
        catch (RemoteConnectionException e) {
            Debug.POLICY.error(Debug.DEBUG_JOBS, (Throwable)e);
            this.exception = e;
            this.errorMessage = Messages.ExportJobWrapper_19;
            this.hadError = true;
        }
        catch (RemoteExecutionException e) {
            Debug.POLICY.error(Debug.DEBUG_JOBS, (Throwable)e);
            this.exception = e;
            this.errorMessage = Messages.ExportJobWrapper_20;
            this.hadError = true;
        }
        catch (RemoteOperationException e) {
            Debug.POLICY.error(Debug.DEBUG_JOBS, (Throwable)e);
            this.exception = e;
            this.errorMessage = Messages.ExportJobWrapper_20;
            this.hadError = true;
        }
        catch (CancelException e) {
            Debug.POLICY.error(Debug.DEBUG_JOBS, (Throwable)e);
            this.exception = e;
            this.errorMessage = Messages.ExportJobWrapper_21;
            this.hadError = true;
        }
        catch (InterruptedException e) {
            Debug.POLICY.error(Debug.DEBUG_JOBS, (Throwable)e);
            this.exception = e;
            this.hadError = true;
        }
        catch (InvocationTargetException e) {
            Debug.POLICY.error(Debug.DEBUG_JOBS, (Throwable)e);
            this.exception = e;
            this.hadError = true;
        }
        catch (CoreException e) {
            Debug.POLICY.error(Debug.DEBUG_JOBS, (Throwable)e);
            this.exception = e;
            this.errorMessage = Messages.ExportJobWrapper_22;
            this.hadError = true;
        }
        Debug.POLICY.exit(Debug.DEBUG_JOBS);
    }

    private void copyProject(IProject project, IRemoteFileTools tools, IProgressMonitor monitor, String remPath) throws CoreException, InterruptedException, RemoteExecutionException, RemoteConnectionException, CancelException, InvocationTargetException, RemoteOperationException {
        Debug.POLICY.enter(Debug.DEBUG_JOBS, new Object[]{project.getName(), remPath});
        IResource[] members = project.members();
        int i = 0;
        while (i < members.length) {
            if (monitor.isCanceled()) {
                throw new InterruptedException(Messages.ExportJobWrapper_23);
            }
            IResource temp = members[i];
            if (temp instanceof IProject) {
                IProject proj = (IProject)temp;
                Debug.POLICY.trace(Debug.DEBUG_JOBS, "IProject: {0}", new Object[]{proj.getName()});
                this.copyProject(project, tools, monitor, String.valueOf(remPath) + File.separatorChar + project.getName());
            } else if (temp instanceof IFolder) {
                IFolder folder = (IFolder)temp;
                Debug.POLICY.trace(Debug.DEBUG_JOBS, "IFolder: {0}", new Object[]{folder.getFullPath().toOSString()});
                this.copyFolder(folder, tools, monitor, String.valueOf(remPath) + File.separatorChar + project.getName());
            } else if (temp instanceof IFile) {
                IFile file = (IFile)temp;
                Debug.POLICY.trace(Debug.DEBUG_JOBS, "IFile: {0}", new Object[]{file.getFullPath().toOSString()});
                this.copyIFile(file, tools, monitor, String.valueOf(remPath) + File.separatorChar + project.getName());
            } else {
                throw new InvocationTargetException(null, String.valueOf(Messages.ExportJobWrapper_24) + temp.getLocation().toString() + Messages.ExportJobWrapper_25);
            }
            ++i;
        }
        Debug.POLICY.exit(Debug.DEBUG_JOBS);
    }

    private void copyFolder(IFolder folder, IRemoteFileTools tools, IProgressMonitor monitor, String remPath) throws CoreException, InterruptedException, RemoteExecutionException, RemoteConnectionException, CancelException, InvocationTargetException, RemoteOperationException {
        Debug.POLICY.enter(Debug.DEBUG_JOBS, new Object[]{folder.getFullPath().toOSString(), remPath});
        IResource[] members = folder.members();
        int i = 0;
        while (i < members.length) {
            if (monitor.isCanceled()) {
                throw new InterruptedException(Messages.ExportJobWrapper_26);
            }
            IResource temp = members[i];
            if (temp instanceof IProject) {
                IProject proj = (IProject)temp;
                Debug.POLICY.trace(Debug.DEBUG_JOBS, "IProject: {0}", new Object[]{proj.getName()});
                this.copyProject((IProject)temp, tools, monitor, String.valueOf(remPath) + File.separatorChar + folder.getName());
            } else if (temp instanceof IFolder) {
                IFolder folder2 = (IFolder)temp;
                Debug.POLICY.trace(Debug.DEBUG_JOBS, "IFolder: {0}", new Object[]{folder2.getFullPath().toOSString()});
                this.copyFolder((IFolder)temp, tools, monitor, String.valueOf(remPath) + File.separatorChar + folder.getName());
            } else if (temp instanceof IFile) {
                IFile file = (IFile)temp;
                Debug.POLICY.trace(Debug.DEBUG_JOBS, "IFile: {0}", new Object[]{file.getFullPath().toOSString()});
                this.copyIFile((IFile)temp, tools, monitor, String.valueOf(remPath) + File.separatorChar + folder.getName());
            } else {
                throw new InvocationTargetException(null, String.valueOf(Messages.ExportJobWrapper_27) + temp.getLocation().toString() + Messages.ExportJobWrapper_28);
            }
            ++i;
        }
        Debug.POLICY.exit(Debug.DEBUG_JOBS);
    }

    private void copyIFile(IFile file, IRemoteFileTools fileTools, IProgressMonitor monitor, String remPath) throws RemoteOperationException, RemoteConnectionException, CancelException, InterruptedException {
        Debug.POLICY.enter(Debug.DEBUG_JOBS, new Object[]{file.getFullPath().toOSString(), remPath});
        String localPath = file.getLocation().toString();
        String localFileName = file.getName();
        String remotePath = String.valueOf(this.wrapper.remoteDir) + remPath;
        String tempPath = String.valueOf(remotePath) + File.separatorChar + localFileName;
        IRemoteCopyTools copyTools = fileTools.getRemoteCopyTools();
        if (monitor.isCanceled()) {
            throw new InterruptedException(Messages.ExportJobWrapper_29);
        }
        monitor.subTask(String.valueOf(Messages.ExportJobWrapper_30) + localPath);
        if (this.wrapper.autoOverwrite) {
            if (fileTools.hasDirectory(tempPath)) {
                fileTools.removeFile(tempPath);
            }
            copyTools.uploadFileToDir(localPath, remotePath);
        } else if (fileTools.hasFile(tempPath) || fileTools.hasDirectory(tempPath)) {
            if (!this.wrapper.noToAllOverwrite) {
                String response = this.wrapper.exportPage.queryOverwrite(String.valueOf(localFileName) + Messages.ExportJobWrapper_31 + remotePath);
                if (response.equals("ALL")) {
                    this.wrapper.autoOverwrite = true;
                    if (fileTools.hasDirectory(tempPath)) {
                        fileTools.removeFile(tempPath);
                    }
                    copyTools.uploadFileToDir(localPath, remotePath);
                } else if (response.equals("YES")) {
                    if (fileTools.hasDirectory(tempPath)) {
                        fileTools.removeFile(tempPath);
                    }
                    copyTools.uploadFileToDir(localPath, remotePath);
                } else {
                    if (response.equals("CANCEL")) {
                        throw new InterruptedException(Messages.ExportJobWrapper_32);
                    }
                    if (response.equals("NOALL")) {
                        this.wrapper.noToAllOverwrite = true;
                    }
                }
            }
        } else {
            copyTools.uploadFileToDir(localPath, remotePath);
        }
        monitor.worked(1);
        Debug.POLICY.exit(Debug.DEBUG_JOBS);
    }

    private void copyDirectory(File file, IRemoteFileTools fileTools, IProgressMonitor monitor, String remPath) throws RemoteExecutionException, RemoteConnectionException, CancelException, InterruptedException, RemoteOperationException {
        Debug.POLICY.enter(Debug.DEBUG_JOBS, new Object[]{file.toString(), remPath});
        if (monitor.isCanceled()) {
            throw new InterruptedException(Messages.ExportJobWrapper_33);
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            int i = 0;
            while (i < files.length) {
                if (monitor.isCanceled()) {
                    throw new InterruptedException(Messages.ExportJobWrapper_34);
                }
                this.copyDirectory(files[i], fileTools, monitor, String.valueOf(remPath) + File.separatorChar + file.getName());
                ++i;
            }
            return;
        }
        String localPath = file.toString();
        String localFileName = file.getName();
        String remotePath = String.valueOf(this.wrapper.remoteDir) + remPath;
        String tempPath = String.valueOf(remotePath) + File.separatorChar + localFileName;
        IRemoteCopyTools copyTools = fileTools.getRemoteCopyTools();
        if (monitor.isCanceled()) {
            throw new InterruptedException(Messages.ExportJobWrapper_35);
        }
        monitor.subTask(String.valueOf(Messages.ExportJobWrapper_36) + file.toString());
        if (this.wrapper.autoOverwrite) {
            if (fileTools.hasDirectory(tempPath)) {
                fileTools.removeFile(tempPath);
            }
            copyTools.uploadFileToDir(localPath, remotePath);
        } else if (fileTools.hasFile(tempPath) || fileTools.hasDirectory(tempPath)) {
            if (!this.wrapper.noToAllOverwrite) {
                String response = this.wrapper.exportPage.queryOverwrite(String.valueOf(localFileName) + Messages.ExportJobWrapper_37 + remotePath);
                if (response.equals("ALL")) {
                    this.wrapper.autoOverwrite = true;
                    if (fileTools.hasDirectory(tempPath)) {
                        fileTools.removeFile(tempPath);
                    }
                    copyTools.uploadFileToDir(localPath, remotePath);
                } else if (response.equals("YES")) {
                    if (fileTools.hasDirectory(tempPath)) {
                        fileTools.removeFile(tempPath);
                    }
                    copyTools.uploadFileToDir(localPath, remotePath);
                } else {
                    if (response.equals("CANCEL")) {
                        throw new InterruptedException(Messages.ExportJobWrapper_38);
                    }
                    if (response.equals("NOALL")) {
                        this.wrapper.noToAllOverwrite = true;
                    }
                }
            }
        } else {
            copyTools.uploadFileToDir(localPath, remotePath);
        }
        monitor.worked(1);
        Debug.POLICY.exit(Debug.DEBUG_JOBS);
    }
}

