/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.perf.tau;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ptp.perf.AbstractPerformanceDataManager;
import org.eclipse.ptp.perf.internal.BuildLaunchUtils;
import org.eclipse.ptp.perf.tau.MultiFieldDialog;
import org.eclipse.ptp.perf.tau.TAUPortalUploadDialog;
import org.eclipse.ptp.perf.tau.perfdmf.PerfDMFUIPlugin;
import org.eclipse.ptp.perf.tau.perfdmf.views.PerfDMFView;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class TAUPerformanceDataManager
extends AbstractPerformanceDataManager {
    private static String tbpath = null;
    boolean useExt = false;

    private static String getTauMakefile(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("tau_makefile.performance.options.configuration_id_", null);
    }

    public void cleanup() {
    }

    public void setExternalTarget(boolean useExt) {
        this.useExt = useExt;
    }

    public void process(String projname, ILaunchConfiguration configuration, String directory) throws CoreException {
        tbpath = BuildLaunchUtils.getToolPath((String)"tau");
        if (this.useExt || projname == null) {
            boolean usePortal = configuration.getAttribute("upload_profiles_to_portal", false);
            String[] profIDs = TAUPerformanceDataManager.getProfIDs();
            if (profIDs == null) {
                return;
            }
            File[] profs = TAUPerformanceDataManager.getProfiles(directory);
            if (profs == null || profs.length == 0) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"TAU Warning", (String)"No profile data was located.  Please make sure profile data is available");
                    }
                });
                return;
            }
            projname = profIDs[0];
            String projtype = profIDs[1];
            String projtrial = profIDs[2];
            String xmlMetaData = configuration.getAttribute("string representation of xml metadata file for perfexplorer", null);
            String database = PerfDMFView.extractDatabaseName((String)configuration.getAttribute("perfdmf_database_configuration", null));
            boolean hasdb = TAUPerformanceDataManager.addToDatabase(directory, database, projname, projtype, projtrial, xmlMetaData);
            if (!hasdb) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"TAU Warning", (String)"Adding data to your perfdmf database failed.  Please make sure that you have successfully run perfdmf_configure with your selected TAU installation.");
                    }
                });
                return;
            }
            if (usePortal) {
                File ppkfile = TAUPerformanceDataManager.getPPKFile(directory, projname, projtype, projtrial);
                if (ppkfile == null || !ppkfile.canRead()) {
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"TAU Warning", (String)"Could not generate ppk file from profile data");
                        }
                    });
                } else {
                    TAUPerformanceDataManager.runPortal(ppkfile);
                }
                ppkfile.delete();
            }
            return;
        }
        String makename = TAUPerformanceDataManager.getTauMakefile(configuration);
        int tauDex = makename.lastIndexOf("tau-");
        String projtype = null;
        projtype = tauDex < 0 ? "tau" : makename.substring(tauDex + 4);
        boolean tracout = configuration.getAttribute("use_epilog", false) || configuration.getAttribute("use_vampirtrace", false) || configuration.getAttribute("use_tau_tracing", false) || configuration.getAttribute("use_perf_library", false) || projtype.indexOf("-trace") >= 0;
        boolean profout = configuration.getAttribute("use_callpath_profiling", false) || configuration.getAttribute("use_tau_phases", false) || configuration.getAttribute("use_memory_profiling", false) || projtype.indexOf("-profile") >= 0 || projtype.indexOf("-headroom") >= 0;
        boolean haveprofiles = !tracout || profout;
        String projtrial = BuildLaunchUtils.getNow();
        if (projtype.indexOf("-perf") > 0) {
            TAUPerformanceDataManager.managePerfFiles(directory);
        }
        if (haveprofiles) {
            String perfexScript;
            boolean runtauinc;
            String expAppend = configuration.getAttribute("string that will override the default experiment identifier used in perfdmf storage", null);
            boolean useP = configuration.getAttribute("use the parametric analysis system", false);
            if (expAppend != null && expAppend.length() > 0) {
                projtype = String.valueOf(projtype) + "_" + expAppend;
            }
            File[] profs = TAUPerformanceDataManager.getProfiles(directory);
            if (!useP && profs == null || profs.length == 0) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"TAU Warning", (String)"No profile data was located.  Please make sure profile data is available");
                    }
                });
            }
            if (runtauinc = configuration.getAttribute("use_tauinc_script", false)) {
                TAUPerformanceDataManager.runTAUInc(directory, projname, projtype, projtrial);
            }
            String xmlMetaData = configuration.getAttribute("string representation of xml metadata file for perfexplorer", null);
            String database = PerfDMFView.extractDatabaseName((String)configuration.getAttribute("perfdmf_database_configuration", null));
            boolean hasdb = TAUPerformanceDataManager.addToDatabase(directory, database, projname, projtype, projtrial, xmlMetaData);
            if (!hasdb && !useP) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"TAU Warning", (String)"Adding data to your perfdmf database failed.  Please make sure that you have successfully run perfdmf_configure with your selected TAU installation.");
                    }
                });
            }
            boolean keepprofs = configuration.getAttribute("keep_profile_files", false);
            boolean useportal = configuration.getAttribute("upload_profiles_to_portal", false);
            if (keepprofs || !hasdb || useportal) {
                File ppkfile = TAUPerformanceDataManager.getPPKFile(directory, projname, projtype, projtrial);
                if (ppkfile == null || !ppkfile.canRead()) {
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"TAU Warning", (String)"Could not generate ppk file from profile data");
                        }
                    });
                } else {
                    if (useportal) {
                        TAUPerformanceDataManager.runPortal(ppkfile);
                    }
                    if (keepprofs || !hasdb) {
                        TAUPerformanceDataManager.movePakFile(directory, projtype, projtrial, ppkfile);
                    } else {
                        ppkfile.delete();
                    }
                }
            }
            TAUPerformanceDataManager.removeProfiles(profs);
            boolean useperfex = configuration.getAttribute("launch perfexplorer along with other tau profile management activity", false);
            if (useperfex && (perfexScript = configuration.getAttribute("path to the perfexplorer script to use in parametric study", null)) != null && perfexScript.length() > 0) {
                TAUPerformanceDataManager.runPerfEx(directory, database, projname, projtype, perfexScript);
            }
        }
    }

    public void view() {
    }

    private static String[] getProfIDs() {
        final String[] queries = new String[]{"Application Name:", "Experiment Name:", "Trial Name:"};
        final String[] values = new String[3];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                MultiFieldDialog mfd = new MultiFieldDialog(shell, queries);
                mfd.open();
                String[] outvals = mfd.getValues();
                int i = 0;
                while (i < values.length) {
                    values[i] = outvals[i];
                    ++i;
                }
            }
        });
        return values;
    }

    private static File[] getProfiles(String directory) {
        File[] profiles = null;
        File dir = new File(directory);
        class Profilefilter
        implements FilenameFilter {
            Profilefilter() {
            }

            public boolean accept(File dir, String name) {
                return name.indexOf("profile.") == 0;
            }
        }
        Profilefilter profil = new Profilefilter();
        profiles = dir.listFiles(profil);
        if (profiles.length > 0) {
            return profiles;
        }
        class Counterfilter
        implements FileFilter {
            Counterfilter() {
            }

            public boolean accept(File pathname) {
                return pathname.isDirectory() && pathname.getName().indexOf("MULTI__") == 0;
            }
        }
        Counterfilter countfil = new Counterfilter();
        profiles = dir.listFiles(countfil);
        if (profiles.length > 0) {
            return profiles;
        }
        return null;
    }

    private static File getPPKFile(String directory, String projname, String projtype, String projtrial) {
        class PpPaker
        implements Runnable {
            public String ppk;
            private final /* synthetic */ String val$projname;
            private final /* synthetic */ String val$projtype;
            private final /* synthetic */ String val$projtrial;
            private final /* synthetic */ String val$directory;

            PpPaker(String string, String string2, String string3, String string4) {
                this.val$projname = string;
                this.val$projtype = string2;
                this.val$projtrial = string3;
                this.val$directory = string4;
            }

            public void run() {
                ArrayList<String> paraCommand = new ArrayList<String>();
                String ppkname = String.valueOf(this.val$projname) + "_" + this.val$projtype + "_" + this.val$projtrial + ".ppk";
                String paraprof = "";
                if (tbpath != null && tbpath.length() > 0) {
                    paraprof = String.valueOf(paraprof) + tbpath + File.separator;
                }
                paraprof = String.valueOf(paraprof) + "paraprof";
                String pack = "--pack " + ppkname;
                System.out.println(String.valueOf(paraprof) + " " + pack);
                this.ppk = String.valueOf(this.val$directory) + File.separator + ppkname;
                paraCommand.add(paraprof);
                paraCommand.add(pack);
                BuildLaunchUtils.runTool(paraCommand, null, (File)new File(this.val$directory));
            }
        }
        PpPaker ppp = new PpPaker(projname, projtype, projtrial, directory);
        Display.getDefault().syncExec((Runnable)ppp);
        return new File(ppp.ppk);
    }

    private static boolean addToDatabase(String directory, String database, String projname, String projtype, String projtrial, String xmlMetaData) {
        boolean hasdb = false;
        try {
            if (database != null && !database.equals("No databases available")) {
                class DBView
                implements Runnable {
                    boolean hasdb = false;
                    private final /* synthetic */ String val$projname;
                    private final /* synthetic */ String val$projtype;
                    private final /* synthetic */ String val$projtrial;
                    private final /* synthetic */ String val$directory;
                    private final /* synthetic */ String val$database;

                    DBView(String string, String string2, String string3, String string4, String string5) {
                        this.val$projname = string;
                        this.val$projtype = string2;
                        this.val$projtrial = string3;
                        this.val$directory = string4;
                        this.val$database = string5;
                    }

                    public void run() {
                        this.hasdb = PerfDMFUIPlugin.addPerformanceData((String)this.val$projname, (String)this.val$projtype, (String)this.val$projtrial, (String)this.val$directory, (String)this.val$database);
                    }
                }
                DBView dbv = new DBView(projname, projtype, projtrial, directory, database);
                Display.getDefault().syncExec((Runnable)dbv);
                hasdb = dbv.hasdb;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hasdb;
    }

    private static void movePakFile(String directory, String projtype, String projtrial, File ppkFile) {
        File profdir = new File(String.valueOf(directory) + File.separator + "Profiles" + File.separator + projtype + File.separator + projtrial);
        profdir.mkdirs();
        ppkFile.renameTo(new File(profdir + File.separator + ppkFile.getName()));
    }

    private static void removeProfiles(File[] remprofs) {
        if (remprofs == null || remprofs.length == 0) {
            return;
        }
        boolean multipapi = remprofs[0].isDirectory();
        int i = 0;
        while (i < remprofs.length) {
            if (multipapi) {
                File[] profs = remprofs[i].listFiles();
                int j = 0;
                while (j < profs.length) {
                    profs[j].delete();
                    ++j;
                }
            }
            remprofs[i].delete();
            ++i;
        }
    }

    private static void runTAUInc(final String directory, final String projname, final String projtype, final String projtrial) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                String mpilistname = String.valueOf(projname) + "_" + projtype + "_" + projtrial + ".includelist";
                String tauinc = "cd " + directory + " ; ";
                if (tbpath != null && tbpath.length() > 0) {
                    tauinc = String.valueOf(tauinc) + tbpath + File.separator;
                }
                tauinc = String.valueOf(tauinc) + "tauinc.sh > " + mpilistname;
                System.out.println(tauinc);
                try {
                    String[] cmd = new String[]{"sh", "-c", tauinc};
                    Runtime.getRuntime().exec(cmd);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private static void runPerfEx(String directory, String database, String projname, String projtype, String perfExScript) {
        ArrayList<String> script = new ArrayList<String>();
        script.add(perfExScript);
        script.add(" -c " + database);
        script.add(" -p app=" + projname + ",exp=" + projtype);
        BuildLaunchUtils.runTool(script, null, (File)new File(directory));
    }

    private static boolean runPortal(final File ppkFile) {
        boolean hasdb = true;
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                try {
                    TAUPortalUploadDialog pwDialog = new TAUPortalUploadDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), ppkFile);
                    int result = pwDialog.open();
                    if (result != 0 && result != 1) {
                        MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"TAU Warning", (String)"Adding data to your online database failed.  Please make sure that the given URL, username and password are correct.");
                    }
                }
                catch (Exception exception) {
                    MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"TAU Warning", (String)"Adding data to your online database failed.  Please make sure that the given URL, username and password are correct.");
                }
            }
        });
        return hasdb;
    }

    private static void managePerfFiles(String directory) throws CoreException {
        File dir = new File(directory);
        class Perffilter
        implements FilenameFilter {
            Perffilter() {
            }

            public boolean accept(File dir, String name) {
                return name.indexOf("perf_data.") == 0;
            }
        }
        Perffilter seekdir = new Perffilter();
        File[] perfdir = dir.listFiles(seekdir);
        if (perfdir == null || perfdir.length < 1) {
            return;
        }
        ArrayList<String> command = new ArrayList<String>();
        String perf2tau = "";
        if (tbpath != null && tbpath.length() > 0) {
            perf2tau = String.valueOf(perf2tau) + tbpath + File.separator;
        }
        perf2tau = String.valueOf(perf2tau) + "perf2tau";
        command.add(perf2tau);
        BuildLaunchUtils.runTool(command, null, (File)dir);
    }

    public String getName() {
        return "process-TAU-data";
    }
}

