/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.pdt.xml.wizard.ui.table;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.ptp.cell.pdt.xml.Activator;
import org.eclipse.ptp.cell.pdt.xml.core.eventgroup.EventGroup;
import org.eclipse.ptp.cell.pdt.xml.debug.Debug;
import org.eclipse.ptp.cell.pdt.xml.wizard.ui.PdtWizardGroupsPositionAndColorPage;
import org.eclipse.ptp.cell.pdt.xml.wizard.ui.table.Messages;
import org.eclipse.swt.widgets.TableItem;

public class TableModifier
implements ICellModifier {
    private final PdtWizardGroupsPositionAndColorPage positionAndColorPage;
    private TableViewer tableViewer;

    public TableModifier(TableViewer viewer, PdtWizardGroupsPositionAndColorPage positionAndColorPage) {
        this.positionAndColorPage = positionAndColorPage;
        this.tableViewer = viewer;
    }

    public boolean canModify(Object element, String property) {
        return !property.equals(PdtWizardGroupsPositionAndColorPage.Column.NAME.getAssociatedName());
    }

    public Object getValue(Object element, String property) {
        if (element instanceof EventGroup) {
            EventGroup evtGrp = (EventGroup)element;
            if (property.equals(PdtWizardGroupsPositionAndColorPage.Column.NAME.getAssociatedName())) {
                return evtGrp.getName().toString();
            }
            if (property.equals(PdtWizardGroupsPositionAndColorPage.Column.YSTART.getAssociatedName())) {
                return evtGrp.getYStart().toString();
            }
            if (property.equals(PdtWizardGroupsPositionAndColorPage.Column.YEND.getAssociatedName())) {
                return evtGrp.getYEnd().toString();
            }
            if (property.equals(PdtWizardGroupsPositionAndColorPage.Column.COLOR.getAssociatedName())) {
                return Integer.toHexString(evtGrp.getColor());
            }
        }
        return null;
    }

    public void modify(Object element, String property, Object value) {
        Debug.read();
        if (element instanceof TableItem) {
            TableItem tblItem = (TableItem)element;
            EventGroup evtGrp = (EventGroup)tblItem.getData();
            String strVal = (String)value;
            try {
                if (property.equals(PdtWizardGroupsPositionAndColorPage.Column.YSTART.getAssociatedName())) {
                    evtGrp.setYStart(Float.valueOf(Float.parseFloat(strVal)));
                } else if (property.equals(PdtWizardGroupsPositionAndColorPage.Column.YEND.getAssociatedName())) {
                    evtGrp.setYEnd(Float.valueOf(Float.parseFloat(strVal)));
                } else if (property.equals(PdtWizardGroupsPositionAndColorPage.Column.COLOR.getAssociatedName())) {
                    evtGrp.setColor(Integer.parseInt(strVal, 16));
                }
            }
            catch (NumberFormatException numberFormatException) {
                Status status = new Status(4, Activator.getDefault().getBundle().toString(), 0, Messages.TableModifier_Modify_ErrorMessage_InvalidTableInput, null);
                this.positionAndColorPage.displayErrorDialog((IStatus)status);
            }
            this.tableViewer.update((Object)evtGrp, null);
        }
    }
}

