/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rmsystem;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.attributes.AbstractAttribute;
import org.eclipse.ptp.core.attributes.AttributeDefinitionManager;
import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.core.attributes.EnumeratedAttribute;
import org.eclipse.ptp.core.attributes.EnumeratedAttributeDefinition;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IAttributeDefinition;
import org.eclipse.ptp.core.attributes.IllegalValueException;
import org.eclipse.ptp.core.attributes.StringAttribute;
import org.eclipse.ptp.core.attributes.StringAttributeDefinition;
import org.eclipse.ptp.core.elementcontrols.IPJobControl;
import org.eclipse.ptp.core.elementcontrols.IPMachineControl;
import org.eclipse.ptp.core.elementcontrols.IPNodeControl;
import org.eclipse.ptp.core.elementcontrols.IPProcessControl;
import org.eclipse.ptp.core.elementcontrols.IPQueueControl;
import org.eclipse.ptp.core.elementcontrols.IPUniverseControl;
import org.eclipse.ptp.core.elementcontrols.IResourceManagerControl;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.core.elements.IPMachine;
import org.eclipse.ptp.core.elements.IPNode;
import org.eclipse.ptp.core.elements.IPProcess;
import org.eclipse.ptp.core.elements.IPQueue;
import org.eclipse.ptp.core.elements.IResourceManager;
import org.eclipse.ptp.core.elements.attributes.ElementAttributes;
import org.eclipse.ptp.core.elements.attributes.ErrorAttributes;
import org.eclipse.ptp.core.elements.attributes.JobAttributes;
import org.eclipse.ptp.core.elements.attributes.MachineAttributes;
import org.eclipse.ptp.core.elements.attributes.MessageAttributes;
import org.eclipse.ptp.core.elements.attributes.NodeAttributes;
import org.eclipse.ptp.core.elements.attributes.ProcessAttributes;
import org.eclipse.ptp.core.elements.attributes.QueueAttributes;
import org.eclipse.ptp.core.elements.attributes.ResourceManagerAttributes;
import org.eclipse.ptp.core.elements.events.IChangedJobEvent;
import org.eclipse.ptp.core.elements.events.IChangedNodeEvent;
import org.eclipse.ptp.core.elements.events.IChangedProcessEvent;
import org.eclipse.ptp.core.elements.events.INewJobEvent;
import org.eclipse.ptp.core.elements.events.INewNodeEvent;
import org.eclipse.ptp.core.elements.events.INewProcessEvent;
import org.eclipse.ptp.core.elements.events.IRemoveJobEvent;
import org.eclipse.ptp.core.elements.events.IRemoveNodeEvent;
import org.eclipse.ptp.core.elements.events.IRemoveProcessEvent;
import org.eclipse.ptp.core.elements.listeners.IJobChildListener;
import org.eclipse.ptp.core.elements.listeners.IMachineChildListener;
import org.eclipse.ptp.core.elements.listeners.IQueueChildListener;
import org.eclipse.ptp.core.elements.listeners.IResourceManagerChildListener;
import org.eclipse.ptp.core.elements.listeners.IResourceManagerListener;
import org.eclipse.ptp.internal.core.elements.PElement;
import org.eclipse.ptp.internal.core.elements.PJob;
import org.eclipse.ptp.internal.core.elements.PMachine;
import org.eclipse.ptp.internal.core.elements.PNode;
import org.eclipse.ptp.internal.core.elements.PProcess;
import org.eclipse.ptp.internal.core.elements.PQueue;
import org.eclipse.ptp.internal.core.elements.events.ChangedMachineEvent;
import org.eclipse.ptp.internal.core.elements.events.ChangedQueueEvent;
import org.eclipse.ptp.internal.core.elements.events.NewMachineEvent;
import org.eclipse.ptp.internal.core.elements.events.NewQueueEvent;
import org.eclipse.ptp.internal.core.elements.events.RemoveMachineEvent;
import org.eclipse.ptp.internal.core.elements.events.RemoveQueueEvent;
import org.eclipse.ptp.internal.core.elements.events.ResourceManagerChangeEvent;
import org.eclipse.ptp.internal.core.elements.events.ResourceManagerErrorEvent;
import org.eclipse.ptp.internal.core.elements.events.ResourceManagerSubmitJobErrorEvent;
import org.eclipse.ptp.rmsystem.IResourceManagerConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResourceManager
extends PElement
implements IResourceManager,
IResourceManagerControl {
    private final ListenerList listeners = new ListenerList();
    private final ListenerList childListeners = new ListenerList();
    private final IQueueChildListener queueJobListener;
    private final IJobChildListener jobProcessListener;
    private final IMachineChildListener machineNodeListener;
    private IResourceManagerConfiguration config;
    private AttributeDefinitionManager attrDefManager = new AttributeDefinitionManager();
    private final Map<String, IPJobControl> jobsById = Collections.synchronizedMap(new HashMap());
    private final Map<String, IPMachineControl> machinesById = Collections.synchronizedMap(new HashMap());
    private final Map<String, IPNodeControl> nodesById = Collections.synchronizedMap(new HashMap());
    private final Map<String, IPProcessControl> processesById = Collections.synchronizedMap(new HashMap());
    private final Map<String, IPQueueControl> queuesById = Collections.synchronizedMap(new HashMap());
    private final Map<String, IPQueueControl> queuesByName = Collections.synchronizedMap(new HashMap());

    private static IAttribute<?, ?, ?>[] getDefaultAttributes(IResourceManagerConfiguration config) {
        ArrayList<AbstractAttribute> attrs = new ArrayList<AbstractAttribute>();
        attrs.add(ElementAttributes.getNameAttributeDefinition().create(config.getName()));
        attrs.add(ElementAttributes.getIdAttributeDefinition().create(config.getUniqueName()));
        attrs.add(ResourceManagerAttributes.getDescriptionAttributeDefinition().create(config.getDescription()));
        attrs.add(ResourceManagerAttributes.getTypeAttributeDefinition().create(config.getType()));
        attrs.add(ResourceManagerAttributes.getStateAttributeDefinition().create(ResourceManagerAttributes.State.STOPPED));
        attrs.add(ResourceManagerAttributes.getRmIDAttributeDefinition().create(config.getUniqueName()));
        return attrs.toArray(new IAttribute[0]);
    }

    public AbstractResourceManager(String id, IPUniverseControl universe, IResourceManagerConfiguration config) {
        super(id, universe, 15, AbstractResourceManager.getDefaultAttributes(config));
        this.config = config;
        this.queueJobListener = new IQueueChildListener(){

            public void handleEvent(IChangedJobEvent e) {
            }

            public void handleEvent(INewJobEvent e) {
            }

            public void handleEvent(IRemoveJobEvent e) {
                for (IPJob job : e.getJobs()) {
                    job.removeChildListener(AbstractResourceManager.this.jobProcessListener);
                    AbstractResourceManager.this.jobsById.remove(job.getID());
                }
            }
        };
        this.jobProcessListener = new IJobChildListener(){

            public void handleEvent(IChangedProcessEvent e) {
            }

            public void handleEvent(INewProcessEvent e) {
            }

            public void handleEvent(IRemoveProcessEvent e) {
                for (IPProcess process : e.getProcesses()) {
                    AbstractResourceManager.this.processesById.remove(process.getID());
                }
            }
        };
        this.machineNodeListener = new IMachineChildListener(){

            public void handleEvent(IChangedNodeEvent e) {
            }

            public void handleEvent(INewNodeEvent e) {
            }

            public void handleEvent(IRemoveNodeEvent e) {
                for (IPNode node : e.getNodes()) {
                    AbstractResourceManager.this.nodesById.remove(node.getID());
                }
            }
        };
    }

    @Override
    public void addChildListener(IResourceManagerChildListener listener) {
        this.childListeners.add((Object)listener);
    }

    @Override
    public void addElementListener(IResourceManagerListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void addMachineAttributes(Collection<IPMachineControl> machineControls, IAttribute<?, ?, ?>[] attrs) {
        ArrayList<IPMachine> machines = new ArrayList<IPMachine>(machineControls.size());
        for (IPMachineControl machine : machineControls) {
            machine.addAttributes(attrs);
            machines.add(machine);
        }
        this.fireChangedMachines(machines);
    }

    @Override
    public void addQueueAttributes(Collection<IPQueueControl> queueControls, IAttribute<?, ?, ?>[] attrs) {
        ArrayList<IPQueue> queues = new ArrayList<IPQueue>(queueControls.size());
        for (IPQueueControl queue : queueControls) {
            queue.addAttributes(attrs);
            queues.add(queue);
        }
        this.fireChangedQueues(queues);
    }

    @Override
    public void disableEvents() throws CoreException {
        if (this.getState().equals((Object)ResourceManagerAttributes.State.STARTED)) {
            this.doDisableEvents();
            this.setState(ResourceManagerAttributes.State.SUSPENDED);
        }
    }

    @Override
    public void dispose() {
        this.listeners.clear();
        try {
            this.shutdown();
        }
        catch (CoreException coreException) {}
        this.doDispose();
    }

    @Override
    public void enableEvents() throws CoreException {
        if (this.getState().equals((Object)ResourceManagerAttributes.State.SUSPENDED)) {
            this.doEnableEvents();
            this.setState(ResourceManagerAttributes.State.STARTED);
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isInstance(this)) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    @Override
    public IAttributeDefinition<?, ?, ?> getAttributeDefinition(String attrId) {
        return this.attrDefManager.getAttributeDefinition(attrId);
    }

    public AttributeDefinitionManager getAttributeDefinitionManager() {
        return this.attrDefManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IResourceManagerConfiguration getConfiguration() {
        AbstractResourceManager abstractResourceManager = this;
        synchronized (abstractResourceManager) {
            return this.config;
        }
    }

    @Override
    public String getDescription() {
        StringAttributeDefinition descAttrDef = ResourceManagerAttributes.getDescriptionAttributeDefinition();
        StringAttribute descAttr = (StringAttribute)this.getAttribute(descAttrDef);
        if (descAttr != null) {
            return descAttr.getValue();
        }
        return this.getName();
    }

    @Override
    public String getID() {
        return super.getID();
    }

    @Override
    public IPMachine getMachineById(String id) {
        return this.machinesById.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<IPMachineControl> getMachineControls() {
        Map<String, IPMachineControl> map = this.machinesById;
        synchronized (map) {
            ArrayList<IPMachineControl> machines = new ArrayList<IPMachineControl>(this.machinesById.values().size());
            for (IPMachineControl machine : this.machinesById.values()) {
                machines.add(machine);
            }
            return machines;
        }
    }

    @Override
    public IPMachine[] getMachines() {
        return this.getMachineControls().toArray(new IPMachineControl[0]);
    }

    @Override
    public IPQueue getQueueById(String id) {
        return this.queuesById.get(id);
    }

    @Override
    public IPQueue getQueueByName(String name) {
        return this.queuesByName.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<IPQueueControl> getQueueControls() {
        Map<String, IPQueueControl> map = this.queuesById;
        synchronized (map) {
            ArrayList<IPQueueControl> queues = new ArrayList<IPQueueControl>(this.queuesById.values().size());
            for (IPQueueControl queue : this.queuesById.values()) {
                queues.add(queue);
            }
            return queues;
        }
    }

    @Override
    public IPQueue[] getQueues() {
        return this.getQueueControls().toArray(new IPQueueControl[0]);
    }

    @Override
    public String getResourceManagerId() {
        return this.getConfiguration().getResourceManagerId();
    }

    @Override
    public ResourceManagerAttributes.State getState() {
        EnumeratedAttribute<ResourceManagerAttributes.State> stateAttr = this.getStateAttribute();
        return (ResourceManagerAttributes.State)((Object)stateAttr.getValue());
    }

    @Override
    public String getUniqueName() {
        return this.getConfiguration().getUniqueName();
    }

    @Override
    public boolean hasChildren() {
        return this.getMachines().length > 0 || this.getQueues().length > 0;
    }

    @Override
    public void removeChildListener(IResourceManagerChildListener listener) {
        this.childListeners.remove((Object)listener);
    }

    @Override
    public void removeElementListener(IResourceManagerListener listener) {
        this.listeners.remove((Object)listener);
    }

    @Override
    public void removeTerminatedJobs(IPQueue queue) {
        this.doRemoveTerminatedJobs((IPQueueControl)queue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConfiguration(IResourceManagerConfiguration config) {
        StringAttributeDefinition descAttrDef;
        StringAttribute descAttr;
        AbstractResourceManager abstractResourceManager = this;
        synchronized (abstractResourceManager) {
            this.config = config;
        }
        AttributeManager attrs = new AttributeManager();
        StringAttributeDefinition nameAttrDef = ElementAttributes.getNameAttributeDefinition();
        StringAttribute nameAttr = (StringAttribute)this.getAttribute(nameAttrDef);
        if (nameAttr != null) {
            try {
                nameAttr.setValue(config.getName());
                attrs.addAttribute(nameAttr);
            }
            catch (IllegalValueException illegalValueException) {}
        }
        if ((descAttr = (StringAttribute)this.getAttribute(descAttrDef = ResourceManagerAttributes.getDescriptionAttributeDefinition())) != null) {
            try {
                descAttr.setValue(config.getDescription());
                attrs.addAttribute(descAttr);
            }
            catch (IllegalValueException illegalValueException) {}
        }
        this.fireResourceManagerChanged(attrs);
    }

    @Override
    public void shutdown() throws CoreException {
        NullProgressMonitor monitor = null;
        switch (this.getState()) {
            case ERROR: {
                this.setState(ResourceManagerAttributes.State.STOPPED);
                this.cleanUp();
                break;
            }
            case STARTED: {
                this.setState(ResourceManagerAttributes.State.STOPPING);
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                monitor.beginTask("Stopping Resource Manager " + this.getName(), 10);
                SubProgressMonitor subMonitor = new SubProgressMonitor((IProgressMonitor)monitor, 10);
                try {
                    this.doShutdown((IProgressMonitor)subMonitor);
                }
                finally {
                    monitor.done();
                    this.setState(ResourceManagerAttributes.State.STOPPED);
                    this.cleanUp();
                }
            }
        }
    }

    @Override
    public void startUp(IProgressMonitor monitor) throws CoreException {
        if (this.getState() == ResourceManagerAttributes.State.STOPPED) {
            this.setState(ResourceManagerAttributes.State.STARTING);
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.beginTask("Resource manager starting: " + this.getName(), 10);
            try {
                try {
                    this.initialize();
                    boolean started = this.doStartup((IProgressMonitor)new SubProgressMonitor(monitor, 10));
                    if (started) {
                        this.setState(ResourceManagerAttributes.State.STARTED);
                    } else {
                        this.setState(ResourceManagerAttributes.State.STOPPED);
                    }
                }
                catch (CoreException e) {
                    this.setState(ResourceManagerAttributes.State.ERROR);
                    throw e;
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    @Override
    public IPJob submitJob(ILaunchConfiguration configuration, AttributeManager attrMgr, IProgressMonitor monitor) throws CoreException {
        return this.doSubmitJob(null, configuration, attrMgr, monitor);
    }

    @Override
    public void submitJob(String subId, ILaunchConfiguration configuration, AttributeManager attrMgr, IProgressMonitor monitor) throws CoreException {
        this.doSubmitJob(subId, configuration, attrMgr, monitor);
    }

    @Override
    public void terminateJob(IPJob job) throws CoreException {
        this.doTerminateJob(job);
    }

    private void fireResourceManagerChanged(AttributeManager attrs) {
        ResourceManagerChangeEvent e = new ResourceManagerChangeEvent(this, attrs);
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IResourceManagerListener)listener).handleEvent(e);
            ++n2;
        }
    }

    private EnumeratedAttribute<ResourceManagerAttributes.State> getStateAttribute() {
        EnumeratedAttributeDefinition<ResourceManagerAttributes.State> stateAttrDef = ResourceManagerAttributes.getStateAttributeDefinition();
        EnumeratedAttribute stateAttr = (EnumeratedAttribute)this.getAttribute(stateAttrDef);
        return stateAttr;
    }

    private void initialize() {
        this.attrDefManager.clear();
        this.attrDefManager.setAttributeDefinitions(ElementAttributes.getDefaultAttributeDefinitions());
        this.attrDefManager.setAttributeDefinitions(ErrorAttributes.getDefaultAttributeDefinitions());
        this.attrDefManager.setAttributeDefinitions(JobAttributes.getDefaultAttributeDefinitions());
        this.attrDefManager.setAttributeDefinitions(MachineAttributes.getDefaultAttributeDefinitions());
        this.attrDefManager.setAttributeDefinitions(MessageAttributes.getDefaultAttributeDefinitions());
        this.attrDefManager.setAttributeDefinitions(NodeAttributes.getDefaultAttributeDefinitions());
        this.attrDefManager.setAttributeDefinitions(ProcessAttributes.getDefaultAttributeDefinitions());
        this.attrDefManager.setAttributeDefinitions(QueueAttributes.getDefaultAttributeDefinitions());
        this.attrDefManager.setAttributeDefinitions(ResourceManagerAttributes.getDefaultAttributeDefinitions());
    }

    protected void addJobs(IPQueueControl queue, Collection<IPJobControl> jobs) {
        for (IPJobControl job : jobs) {
            job.addChildListener(this.jobProcessListener);
            this.jobsById.put(job.getID(), job);
        }
        queue.addJobs(jobs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addMachines(Collection<IPMachineControl> machineControls) {
        ArrayList<IPMachine> machines = new ArrayList<IPMachine>(machineControls.size());
        Map<String, IPMachineControl> map = this.machinesById;
        synchronized (map) {
            for (IPMachineControl machine : machineControls) {
                this.machinesById.put(machine.getID(), machine);
                machine.addChildListener(this.machineNodeListener);
                machines.add(machine);
            }
        }
        this.fireNewMachines(machines);
    }

    protected void addNodes(IPMachineControl machine, Collection<IPNodeControl> nodes) {
        for (IPNodeControl node : nodes) {
            this.nodesById.put(node.getID(), node);
        }
        machine.addNodes(nodes);
    }

    protected void addProcesses(IPJobControl job, Collection<IPProcessControl> processes) {
        HashMap<IPNodeControl, ArrayList<IPProcessControl>> nodeProcMap = new HashMap<IPNodeControl, ArrayList<IPProcessControl>>();
        for (IPProcessControl iPProcessControl : processes) {
            StringAttribute attr = (StringAttribute)iPProcessControl.getAttribute(ProcessAttributes.getNodeIdAttributeDefinition());
            if (attr != null) {
                IPNodeControl node = this.getNodeControl(attr.getValue());
                if (node != null) {
                    ArrayList<IPProcessControl> procs = (ArrayList<IPProcessControl>)nodeProcMap.get(node);
                    if (procs == null) {
                        procs = new ArrayList<IPProcessControl>();
                        nodeProcMap.put(node, procs);
                    }
                    procs.add(iPProcessControl);
                }
                iPProcessControl.removeAttribute(attr);
            }
            this.processesById.put(iPProcessControl.getID(), iPProcessControl);
        }
        job.addProcesses(processes);
        for (Map.Entry entry : nodeProcMap.entrySet()) {
            ((IPNodeControl)entry.getKey()).addProcesses((Collection)entry.getValue());
        }
    }

    protected void addQueues(Collection<IPQueueControl> queueControls) {
        ArrayList<IPQueue> queues = new ArrayList<IPQueue>(queueControls.size());
        for (IPQueueControl queue : queueControls) {
            this.queuesById.put(queue.getID(), queue);
            StringAttribute attr = (StringAttribute)queue.getAttribute(ElementAttributes.getNameAttributeDefinition());
            if (attr != null) {
                this.queuesByName.put(attr.getValue(), queue);
            }
            queue.addChildListener(this.queueJobListener);
            queues.add(queue);
        }
        this.fireNewQueues(queues);
    }

    protected void cleanUp() {
        this.doCleanUp();
        this.removeQueues(this, this.getQueueControls());
        this.removeMachines(this, this.getMachineControls());
    }

    @Override
    protected void doAddAttributeHook(AttributeManager attrs) {
        this.fireResourceManagerChanged(attrs);
    }

    protected abstract void doCleanUp();

    protected abstract void doDisableEvents();

    protected abstract void doDispose();

    protected abstract void doEnableEvents();

    protected abstract List<IPJobControl> doRemoveTerminatedJobs(IPQueueControl var1);

    protected abstract void doShutdown(IProgressMonitor var1) throws CoreException;

    protected abstract boolean doStartup(IProgressMonitor var1) throws CoreException;

    protected abstract IPJob doSubmitJob(String var1, ILaunchConfiguration var2, AttributeManager var3, IProgressMonitor var4) throws CoreException;

    protected abstract void doTerminateJob(IPJob var1) throws CoreException;

    protected void fireChangedMachines(Collection<IPMachine> machines) {
        ChangedMachineEvent e = new ChangedMachineEvent(this, machines);
        Object[] objectArray = this.childListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IResourceManagerChildListener)listener).handleEvent(e);
            ++n2;
        }
    }

    protected void fireChangedQueues(Collection<IPQueue> queues) {
        ChangedQueueEvent e = new ChangedQueueEvent(this, queues);
        Object[] objectArray = this.childListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IResourceManagerChildListener)listener).handleEvent(e);
            ++n2;
        }
    }

    protected void fireError(String message) {
        ResourceManagerErrorEvent e = new ResourceManagerErrorEvent(this, message);
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IResourceManagerListener)listener).handleEvent(e);
            ++n2;
        }
    }

    protected void fireSubmitJobError(String id, String message) {
        ResourceManagerSubmitJobErrorEvent e = new ResourceManagerSubmitJobErrorEvent(this, id, message);
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IResourceManagerListener)listener).handleEvent(e);
            ++n2;
        }
    }

    protected void fireNewMachines(Collection<IPMachine> machines) {
        NewMachineEvent e = new NewMachineEvent(this, machines);
        Object[] objectArray = this.childListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IResourceManagerChildListener)listener).handleEvent(e);
            ++n2;
        }
    }

    protected void fireNewQueues(Collection<IPQueue> queues) {
        NewQueueEvent e = new NewQueueEvent(this, queues);
        Object[] objectArray = this.childListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IResourceManagerChildListener)listener).handleEvent(e);
            ++n2;
        }
    }

    protected void fireRemoveMachines(Collection<IPMachine> machines) {
        RemoveMachineEvent e = new RemoveMachineEvent(this, machines);
        Object[] objectArray = this.childListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IResourceManagerChildListener)listener).handleEvent(e);
            ++n2;
        }
    }

    protected void fireRemoveQueues(Collection<IPQueue> queues) {
        RemoveQueueEvent e = new RemoveQueueEvent(this, queues);
        Object[] objectArray = this.childListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IResourceManagerChildListener)listener).handleEvent(e);
            ++n2;
        }
    }

    protected IPJobControl getJobControl(String jobId) {
        return this.jobsById.get(jobId);
    }

    protected IPMachineControl getMachineControl(String machineId) {
        return this.machinesById.get(machineId);
    }

    protected IPNodeControl getNodeControl(String nodeId) {
        return this.nodesById.get(nodeId);
    }

    protected IPProcessControl getProcessControl(String processId) {
        return this.processesById.get(processId);
    }

    protected IPQueueControl getQueueControl(String machineId) {
        return this.queuesById.get(machineId);
    }

    protected CoreException makeCoreException(String string) {
        Status status = new Status(4, PTPCorePlugin.getUniqueIdentifier(), 4, string, null);
        return new CoreException((IStatus)status);
    }

    protected IPJobControl newJob(IPQueueControl queue, String jobId, AttributeManager attrs) {
        return new PJob(jobId, queue, attrs.getAttributes());
    }

    protected IPMachineControl newMachine(String machineId, AttributeManager attrs) {
        return new PMachine(machineId, this, attrs.getAttributes());
    }

    protected IPNodeControl newNode(IPMachineControl machine, String nodeId, AttributeManager attrs) {
        return new PNode(nodeId, machine, attrs.getAttributes());
    }

    protected IPProcessControl newProcess(IPJobControl job, String processId, AttributeManager attrs) {
        return new PProcess(processId, job, attrs.getAttributes());
    }

    protected IPQueueControl newQueue(String queueId, AttributeManager attrs) {
        return new PQueue(queueId, this, attrs.getAttributes());
    }

    protected void removeJobs(IPQueueControl queue, Collection<IPJobControl> jobs) {
        queue.removeJobs(jobs);
    }

    protected void removeMachines(IResourceManager rm, Collection<IPMachineControl> machineControls) {
        ArrayList<IPMachine> machines = new ArrayList<IPMachine>(machineControls.size());
        for (IPMachineControl machine : machineControls) {
            machine.removeNodes(machine.getNodeControls());
            machine.removeChildListener(this.machineNodeListener);
            this.machinesById.remove(machine.getID());
            machines.add(machine);
        }
        this.fireRemoveMachines(machines);
    }

    protected void removeNodes(IPMachineControl machine, Collection<IPNodeControl> nodes) {
        machine.removeNodes(nodes);
    }

    protected void removeProcesses(IPJobControl job, Collection<IPProcessControl> processes) {
        job.removeProcesses(processes);
    }

    protected void removeQueues(IResourceManager rm, Collection<IPQueueControl> queueControls) {
        ArrayList<IPQueue> queues = new ArrayList<IPQueue>(queueControls.size());
        for (IPQueueControl queue : queueControls) {
            queue.removeJobs(queue.getJobControls());
            queue.removeChildListener(this.queueJobListener);
            this.queuesById.remove(queue.getID());
            StringAttribute attr = (StringAttribute)queue.getAttribute(ElementAttributes.getNameAttributeDefinition());
            if (attr != null) {
                this.queuesByName.remove(attr.getValue());
            }
            queues.add(queue);
        }
        this.fireRemoveQueues(queues);
    }

    protected void setState(ResourceManagerAttributes.State state) {
        EnumeratedAttribute<ResourceManagerAttributes.State> stateAttr = this.getStateAttribute();
        if (stateAttr.getValue() != state) {
            stateAttr.setValue(state);
            AttributeManager attrs = new AttributeManager();
            attrs.addAttribute(stateAttr);
            this.fireResourceManagerChanged(attrs);
        }
    }

    protected boolean updateJobs(IPQueueControl queue, Collection<IPJobControl> jobs, AttributeManager attrs) {
        queue.addJobAttributes(jobs, attrs.getAttributes());
        return true;
    }

    protected boolean updateMachines(Collection<IPMachineControl> machines, AttributeManager attrs) {
        this.addMachineAttributes(machines, attrs.getAttributes());
        return true;
    }

    protected boolean updateNodes(IPMachineControl machine, Collection<IPNodeControl> nodes, AttributeManager attrs) {
        machine.addNodeAttributes(nodes, attrs.getAttributes());
        return true;
    }

    protected boolean updateProcesses(IPJobControl job, Collection<IPProcessControl> processes, AttributeManager attrs) {
        job.addProcessAttributes(processes, attrs.getAttributes());
        return true;
    }

    protected boolean updateQueues(Collection<IPQueueControl> queues, AttributeManager attrs) {
        this.addQueueAttributes(queues, attrs.getAttributes());
        return true;
    }
}

