/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.environment.cellsimulator.core.local;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ptp.cell.environment.cellsimulator.CellSimulatorTargetPlugin;
import org.eclipse.ptp.cell.environment.cellsimulator.conf.Parameters;
import org.eclipse.ptp.cell.environment.cellsimulator.core.local.LocalSimulatorDelegate;
import org.eclipse.ptp.cell.environment.cellsimulator.core.local.Messages;
import org.eclipse.ptp.cell.simulator.conf.AttributeNames;
import org.eclipse.ptp.cell.simulator.core.AbstractSimulatorConfiguration;
import org.eclipse.ptp.cell.simulator.core.ISimulatorDelegate;
import org.eclipse.ptp.cell.simulator.core.ISimulatorParameters;
import org.eclipse.ptp.cell.simulator.core.IllegalConfigurationException;
import org.eclipse.ptp.cell.simulator.core.IllegalParameterException;

public class LocalSimulatorConfiguration
extends AbstractSimulatorConfiguration {
    ISimulatorDelegate simulatorDelegate = new LocalSimulatorDelegate((ISimulatorParameters)this);
    protected static int FILE = 2;
    protected static int DIRECTORY = 4;
    protected static int READ = 8;
    protected static int WRITE = 16;
    protected static int EXISTING_FILE = FILE;
    protected static int EXISTING_DIR = DIRECTORY;
    protected static int READABLE_FILE = EXISTING_FILE | READ;
    protected static int WRITABLE_FILE = EXISTING_FILE | READ | WRITE;
    protected static int ACCESSIBLE_DIR = DIRECTORY | READ;

    public ISimulatorDelegate getDelegate() {
        return this.simulatorDelegate;
    }

    public String getSimulatorExecutable() {
        return String.valueOf(this.getSimulatorBaseDirectory()) + "/" + Parameters.PATH_SIMULATOR;
    }

    public String getSnifExecutable() {
        return String.valueOf(this.getSimulatorBaseDirectory()) + "/" + Parameters.PATH_SNIF;
    }

    public String getLogDirectory() {
        return String.valueOf(this.getWorkDirectory()) + "/" + Parameters.PATH_RUNINFO;
    }

    public String getTapDevicePath() {
        return String.valueOf(this.getLogDirectory()) + "/" + Parameters.PATH_TAPDEVICE;
    }

    public String getPIDPath() {
        return String.valueOf(this.getLogDirectory()) + "/" + Parameters.PATH_PID;
    }

    public String getWorkDirectoryRelativePath(String path) {
        return String.valueOf(this.getWorkDirectory()) + "/" + path;
    }

    public void verify() throws IllegalConfigurationException {
        super.verify();
        this.verifyPath(READABLE_FILE, AttributeNames.KERNEL_IMAGE_PATH, this.getKernelImagePath());
        this.verifyPath(EXISTING_FILE, AttributeNames.ROOT_IMAGE_PATH, this.getRootImagePath());
        if (this.doMountExtraImage()) {
            if (this.getExtraImagePersistence() == 2) {
                this.verifyPath(READABLE_FILE | WRITE, AttributeNames.EXTRA_IMAGE_PATH, this.getExtraImagePath());
            } else {
                this.verifyPath(READABLE_FILE, AttributeNames.EXTRA_IMAGE_PATH, this.getExtraImagePath());
            }
        }
        Path workDir = new Path(this.getWorkDirectory());
        IPath stateDir = CellSimulatorTargetPlugin.getDefault().getStateLocation();
        stateDir.isPrefixOf((IPath)workDir);
    }

    protected void verifyPath(int option, String attributeName, String path) throws IllegalParameterException {
        File file = new File(path);
        if (!file.isAbsolute()) {
            throw new IllegalParameterException(Messages.LocalSimulatorConfiguration_PathMustBeAbsolute, attributeName, path);
        }
        if (!file.exists()) {
            throw new IllegalParameterException(Messages.LocalSimulatorConfiguration_PathDoesNotExist, attributeName, path);
        }
        if ((option & FILE) != 0 && !file.isFile()) {
            throw new IllegalParameterException(Messages.LocalSimulatorConfiguration_MustBeFile, attributeName, path);
        }
        if ((option & DIRECTORY) != 0 && !file.isDirectory()) {
            throw new IllegalParameterException(Messages.LocalSimulatorConfiguration_MustBeDir, attributeName, path);
        }
        if ((option & READ) != 0 && !file.canRead()) {
            throw new IllegalParameterException(Messages.LocalSimulatorConfiguration_MustBeReadable, attributeName, path);
        }
        if ((option & WRITE) != 0 && !file.canWrite()) {
            throw new IllegalParameterException(Messages.LocalSimulatorConfiguration_MustBeWritable, attributeName, path);
        }
    }
}

