/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.environment.cellsimulator.core.remote;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.cell.environment.cellsimulator.CellSimulatorTargetPlugin;
import org.eclipse.ptp.cell.environment.cellsimulator.conf.AttributeNames;
import org.eclipse.ptp.cell.environment.cellsimulator.core.common.CommonConfigFactory;
import org.eclipse.ptp.cell.environment.cellsimulator.core.common.ConnectionConfig;
import org.eclipse.ptp.cell.environment.cellsimulator.core.local.LocalSimulatorConfiguration;
import org.eclipse.ptp.cell.environment.cellsimulator.core.remote.RemoteConfigurationBean;
import org.eclipse.ptp.cell.environment.cellsimulator.core.remote.RemoteSimulatorConfiguration;
import org.eclipse.ptp.cell.simulator.conf.Parameters;
import org.eclipse.ptp.cell.simulator.core.ISimulatorParameters;
import org.eclipse.ptp.remotetools.core.IRemoteExecutionManager;
import org.eclipse.ptp.remotetools.utils.verification.ControlAttributes;
import org.eclipse.ptp.remotetools.utils.verification.IllegalAttributeException;

public class RemoteConfigFactory
extends CommonConfigFactory {
    RemoteConfigurationBean bean;

    public RemoteConfigFactory(RemoteConfigurationBean bean) {
        super(bean);
        this.bean = bean;
    }

    public RemoteSimulatorConfiguration createRemoteSimulatorParameters(IRemoteExecutionManager executionManager) throws CoreException {
        RemoteSimulatorConfiguration parameters = new RemoteSimulatorConfiguration(executionManager);
        ControlAttributes attributes = this.bean.getAttributes();
        this.fillSimulatorParameters(parameters);
        try {
            parameters.setWorkDirectory(attributes.getString("work-directory", null));
            parameters.setShowSimulatorGUI(attributes.getBoolean("show-simulator-gui", false));
            parameters.setIpHost(attributes.getString("ip-host", null));
            parameters.setIpSimulator(attributes.getString("ip-simulator", null));
            parameters.setMacSimulator(attributes.getString("mac-simulator", null));
            parameters.setNetmaskSimulator(org.eclipse.ptp.cell.environment.cellsimulator.conf.Parameters.SIMULATOR_NETMASK);
            if (Parameters.doUseJavaAPI()) {
                parameters.setJavaApiSocketInit(true);
                parameters.setJavaApiPort(attributes.verifyInt(AttributeNames.JAVA_API_SOCKET_PORT, "java-api-socket-port"));
                parameters.setJavaApiSocketPortTryWait(Integer.parseInt(org.eclipse.ptp.cell.environment.cellsimulator.conf.Parameters.JAVA_API_SOCKET_PORT_TRY_WAIT));
                parameters.setJavaApiSocketPortMaxTries(Integer.parseInt(org.eclipse.ptp.cell.environment.cellsimulator.conf.Parameters.JAVA_API_SOCKET_PORT_MAX_TRIES));
                if (Parameters.doHandleJavaApiGuiIssue()) {
                    parameters.setShowSimulatorGUI(false);
                }
            } else {
                parameters.setJavaApiSocketInit(false);
            }
            parameters.setConsoleSocketInit(true);
            parameters.setConsolePort(attributes.verifyInt(AttributeNames.CONSOLE_SOCKET_PORT, "console-socket-port"));
            parameters.setConsoleSocketPortMaxTries(Integer.parseInt(org.eclipse.ptp.cell.environment.cellsimulator.conf.Parameters.CONSOLE_SOCKET_PORT_MAX_TRIES));
            parameters.setConsoleSocketPortTryWait(Integer.parseInt(org.eclipse.ptp.cell.environment.cellsimulator.conf.Parameters.CONSOLE_SOCKET_PORT_TRY_WAIT));
            parameters.setConsoleEcho(false);
            parameters.setConsoleTerminalInit(false);
            return parameters;
        }
        catch (IllegalAttributeException e) {
            throw new CoreException((IStatus)new Status(4, CellSimulatorTargetPlugin.getDefault().getBundle().getSymbolicName(), 0, e.getMessage(), (Throwable)e));
        }
    }

    public ConnectionConfig createRemoteConnectionConfig() throws CoreException {
        ControlAttributes attributes = this.bean.getAttributes();
        try {
            ConnectionConfig config = new ConnectionConfig();
            config.setConnectionAddress(attributes.getString("remote-connection-address"));
            config.setConnectionPort(attributes.verifyInt(AttributeNames.REMOTE_CONNECTION_PORT, "remote-connection-port"));
            config.setConnectionTimeout(attributes.verifyInt(AttributeNames.REMOTE_TIMEOUT, "remote-timeout"));
            config.setCipherType(attributes.getString("remote-cipher-type"));
            config.setIsPasswordAuth(attributes.getBoolean("remote-is-password-auth"));
            config.setKeyPassphrase(attributes.getString("remote-key-passphrase"));
            config.setKeyPath(attributes.getString("remote-key-path"));
            config.setLoginPassword(attributes.getString("remote-login-password"));
            config.setLoginUserName(attributes.getString("remote-login-username"));
            return config;
        }
        catch (IllegalAttributeException e) {
            throw new CoreException((IStatus)new Status(4, CellSimulatorTargetPlugin.getDefault().getBundle().getSymbolicName(), 0, e.getMessage(), (Throwable)e));
        }
    }

    public void completeSimulatorParametersWithConsoleConfig(LocalSimulatorConfiguration parameters, int port) {
        parameters.setConsoleSocketHost(null);
        parameters.setConsoleSocketPort(port);
    }

    public void completeSimulatorParametersWithJavaApiConfig(LocalSimulatorConfiguration parameters, int port) {
        parameters.setJavaApiSocketHost(null);
        parameters.setJavaApiSocketPort(port);
    }

    public ISimulatorParameters createSimulatorParameters() throws CoreException {
        return this.createRemoteSimulatorParameters(null);
    }
}

