/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.environment.cellsimulator.core.remote;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.cell.environment.cellsimulator.CellSimulatorTargetPlugin;
import org.eclipse.ptp.cell.environment.cellsimulator.core.common.AbstractTargetControl;
import org.eclipse.ptp.cell.environment.cellsimulator.core.common.ConnectionConfig;
import org.eclipse.ptp.cell.environment.cellsimulator.core.common.TargetConfig;
import org.eclipse.ptp.cell.environment.cellsimulator.core.remote.Messages;
import org.eclipse.ptp.cell.environment.cellsimulator.core.remote.RemoteConfigFactory;
import org.eclipse.ptp.cell.environment.cellsimulator.core.remote.RemoteConfigurationBean;
import org.eclipse.ptp.cell.environment.cellsimulator.core.remote.RemoteSimulatorConfiguration;
import org.eclipse.ptp.cell.simulator.core.AbstractSimulatorConfiguration;
import org.eclipse.ptp.cell.simulator.core.ISimulatorListener;
import org.eclipse.ptp.cell.simulator.core.ISimulatorParameters;
import org.eclipse.ptp.cell.simulator.core.IllegalConfigurationException;
import org.eclipse.ptp.cell.ui.progress.ICancelCallback;
import org.eclipse.ptp.cell.ui.progress.ProgressQueue;
import org.eclipse.ptp.remotetools.RemotetoolsPlugin;
import org.eclipse.ptp.remotetools.core.AuthToken;
import org.eclipse.ptp.remotetools.core.IRemoteConnection;
import org.eclipse.ptp.remotetools.core.IRemoteExecutionManager;
import org.eclipse.ptp.remotetools.core.IRemoteTunnel;
import org.eclipse.ptp.remotetools.core.KeyAuthToken;
import org.eclipse.ptp.remotetools.core.PasswdAuthToken;
import org.eclipse.ptp.remotetools.environment.control.ITargetControl;
import org.eclipse.ptp.remotetools.environment.control.SSHTargetControl;
import org.eclipse.ptp.remotetools.environment.core.ITargetElement;
import org.eclipse.ptp.remotetools.environment.extension.ITargetVariables;
import org.eclipse.ptp.remotetools.exception.CancelException;
import org.eclipse.ptp.remotetools.exception.LocalPortBoundException;
import org.eclipse.ptp.remotetools.exception.RemoteConnectionException;

public class RemoteTargetControl
extends AbstractTargetControl
implements ITargetVariables {
    protected static final int REMOTE_CONNECT_EVENT = 10000;
    protected static final int REMOTE_FORWARDING_EVENT = 10001;
    protected static final int REMOTE_DISCONNECT_EVENT = 10002;
    RemoteConfigFactory factory;
    IRemoteConnection remoteHostConnection;
    IRemoteExecutionManager remoteHostManager;
    Map tunnels = null;
    private IRemoteTunnel shhTunnel;
    private IRemoteTunnel javaApiTunnel;
    private IRemoteTunnel consoleTunnel;
    private int state = 1;
    private static final int NOT_OPERATIONAL = 1;
    private static final int CONNECTING = 2;
    private static final int CONNECTED = 3;
    private static final int DISCONNECTING = 4;
    public static final String DEFAULT_HOST_CIPHER = RemotetoolsPlugin.CIPHER_DEFAULT;
    RemoteHostDisconnector remoteHostDisconnector = new RemoteHostDisconnector(this);

    public RemoteTargetControl(ITargetElement element) throws CoreException {
        super(element);
        RemoteConfigurationBean configurationBean = new RemoteConfigurationBean(this.targetElement.getAttributes());
        this.factory = new RemoteConfigFactory(configurationBean);
        this.setCurrentTargetConfig(this.factory.createTargetConfig());
        this.updateConsoles();
    }

    private synchronized void setState(int state) {
        this.state = state;
    }

    public boolean create(IProgressMonitor monitor) throws CoreException {
        this.setCurrentTargetConfig(this.factory.createTargetConfig());
        RemoteSimulatorConfiguration currentSimulatorParameters = this.factory.createRemoteSimulatorParameters(null);
        ConnectionConfig currentConnectionConfig = this.factory.createRemoteConnectionConfig();
        this.updateConsoles();
        this.resetConsoles();
        ProgressQueue progressQueue = new ProgressQueue(monitor);
        progressQueue.setCancelMessage(Messages.RemoteTargetControl_LocalCellSimulatorLaunchCancelation);
        progressQueue.setInterruptMessage(Messages.RemoteTargetControl_LocalCellSimulatorLaunchInterruption);
        progressQueue.setTaskName(Messages.RemoteTargetControl_LaunchLocalCellSimulator);
        progressQueue.addWait(-1, Messages.RemoteTargetControl_Preparing, 0);
        progressQueue.addWait(10000, Messages.RemoteTargetControl_RemoteHostconnection, 5);
        progressQueue.addWait(10001, Messages.RemoteTargetControl_ForwardingRemoteConnection, 1);
        this.populateProgressQueueWithSimulatorLaunch(progressQueue);
        this.populateProgressQueueWithConnection(progressQueue);
        progressQueue.addWait(-2, Messages.RemoteTargetControl_LaunchCompleted, 0);
        progressQueue.setCancelCallBack((ICancelCallback)new LaunchCancelCallback(this));
        progressQueue.start();
        if (progressQueue.isCancelled()) {
            throw new CoreException((IStatus)new Status(8, this.getPluginId(), 0, Messages.RemoteTargetControl_RemoteSimulatorLaunchCancelled, null));
        }
        try {
            this.setState(2);
            this.connectRemoteHost(progressQueue, currentConnectionConfig);
            currentSimulatorParameters = this.factory.createRemoteSimulatorParameters(this.remoteHostManager);
            try {
                currentSimulatorParameters.verify();
            }
            catch (IllegalConfigurationException e) {
                Status status = new Status(4, CellSimulatorTargetPlugin.getDefault().getBundle().getSymbolicName(), 0, NLS.bind((String)Messages.RemoteTargetControl_InvalidParameter, (Object)e.getMessage()), (Throwable)e);
                throw new CoreException((IStatus)status);
            }
            this.preparePortForwarding(progressQueue, currentConnectionConfig, currentSimulatorParameters, this.getCurrentTargetConfig());
            this.setState(3);
            this.launchSimulator(progressQueue, (ISimulatorParameters)currentSimulatorParameters);
            this.remoteHostDisconnector.enable();
            TargetConfig currentTargetConfig = this.getCurrentTargetConfig();
            SSHTargetControl.SSHParameters parameters = new SSHTargetControl.SSHParameters((SSHTargetControl)this, "localhost", this.shhTunnel.getLocalPort(), currentTargetConfig.getLoginUserName(), currentTargetConfig.getLoginPassword(), currentTargetConfig.getSimulatorCipherType(), currentTargetConfig.getLoginTimeout() * 1000);
            this.setConnectionParameters(parameters);
            this.connectSimulator(monitor, progressQueue);
            this.launchResumePauseStrategy(progressQueue);
            progressQueue.finish();
            return true;
        }
        catch (Exception e) {
            progressQueue.interrupt();
            this.releaseResumePauseStrategy();
            this.disconnect();
            this.releaseSimulator();
            this.disconnectRemoteHost();
            this.setState(1);
            if (e instanceof CoreException) {
                throw (CoreException)((Object)e);
            }
            throw new CoreException((IStatus)new Status(4, this.getPluginId(), 0, NLS.bind((String)Messages.RemoteTargetControl_UnexpectedErrorLaunchingSimulator, (Object)e), (Throwable)e));
        }
        finally {
            monitor.done();
        }
    }

    private void connectRemoteHost(ProgressQueue progressQueue, ConnectionConfig currentConnectionConfig) throws CoreException {
        progressQueue.notifyOperationStarted(10000);
        try {
            if (progressQueue.isCancelled()) {
                throw new CoreException((IStatus)new Status(8, this.getPluginId(), 0, Messages.RemoteTargetControl_RemoteSimulatorLaunchCancelledDuringConnection, null));
            }
            Object token = currentConnectionConfig.isPasswordAuth() ? new PasswdAuthToken(currentConnectionConfig.getLoginUserName(), currentConnectionConfig.getLoginPassword()) : new KeyAuthToken(currentConnectionConfig.getLoginUserName(), new File(currentConnectionConfig.getKeyPath()), currentConnectionConfig.getKeyPassphrase());
            this.remoteHostConnection = RemotetoolsPlugin.createSSHConnection((AuthToken)token, (String)currentConnectionConfig.getConnectionAddress(), (int)currentConnectionConfig.getConnectionPort(), (String)currentConnectionConfig.getCipherType(), (int)(currentConnectionConfig.getConnectionTimeout() * 1000));
            this.remoteHostConnection.connect();
            if (progressQueue.isCancelled()) {
                throw new CoreException((IStatus)new Status(8, this.getPluginId(), 0, Messages.RemoteTargetControl_RemoteSimulatorLaunchCancelledDuringConnection, null));
            }
            this.remoteHostManager = this.remoteHostConnection.createRemoteExecutionManager();
            if (progressQueue.isCancelled()) {
                throw new CoreException((IStatus)new Status(8, this.getPluginId(), 0, Messages.RemoteTargetControl_RemoteSimulatorLaunchCancelledDuringConnection, null));
            }
            progressQueue.notifyOperationCompleted(10000);
            this.tunnels = new HashMap();
        }
        catch (RemoteConnectionException e) {
            this.disconnectRemoteHost();
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.remotetools.environment.cellsimulator", 1, Messages.RemoteTargetControl_CouldNotConnectToRemoteHost, (Throwable)e));
        }
    }

    private void preparePortForwarding(ProgressQueue progressQueue, ConnectionConfig currentConnectionConfig, AbstractSimulatorConfiguration simulatorParameters, TargetConfig targetConfig) throws CoreException {
        try {
            progressQueue.notifyOperationStarted(10001);
            if (progressQueue.isCancelled()) {
                throw new CoreException((IStatus)new Status(8, this.getPluginId(), 0, Messages.RemoteTargetControl_RemoteSimulatorLaunchCancelledDuringPortForwarding, null));
            }
            this.shhTunnel = this.remoteHostManager.createTunnel(simulatorParameters.getIpSimulator(), targetConfig.getLoginPort());
            if (progressQueue.isCancelled()) {
                throw new CoreException((IStatus)new Status(8, this.getPluginId(), 0, Messages.RemoteTargetControl_RemoteSimulatorLaunchCancelledDuringPortForwarding, null));
            }
            if (simulatorParameters.doJavaApiSocketInit()) {
                this.javaApiTunnel = this.remoteHostManager.createTunnel(currentConnectionConfig.getConnectionAddress(), simulatorParameters.getJavaApiPort());
                simulatorParameters.setJavaApiSocketHost(null);
                simulatorParameters.setJavaApiSocketPort(this.javaApiTunnel.getLocalPort());
            }
            if (progressQueue.isCancelled()) {
                throw new CoreException((IStatus)new Status(8, this.getPluginId(), 0, Messages.RemoteTargetControl_RemoteSimulatorLaunchCancelledDuringPortForwarding, null));
            }
            if (simulatorParameters.doConsoleSocketInit()) {
                this.consoleTunnel = this.remoteHostManager.createTunnel(currentConnectionConfig.getConnectionAddress(), simulatorParameters.getConsolePort());
                simulatorParameters.setConsoleSocketHost(null);
                simulatorParameters.setConsoleSocketPort(this.consoleTunnel.getLocalPort());
            }
            if (progressQueue.isCancelled()) {
                throw new CoreException((IStatus)new Status(8, this.getPluginId(), 0, Messages.RemoteTargetControl_RemoteSimulatorLaunchCancelledDuringPortForwarding, null));
            }
            progressQueue.notifyOperationCompleted(10001);
        }
        catch (RemoteConnectionException e) {
            this.disconnectRemoteHost();
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.remotetools.environment.cellsimulator", 1, Messages.RemoteTargetControl_CouldNotCreatePortForward, (Throwable)e));
        }
        catch (LocalPortBoundException e) {
            this.disconnectRemoteHost();
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.remotetools.environment.cellsimulator", 1, Messages.RemoteTargetControl_CouldNotCreatePortForward, (Throwable)e));
        }
        catch (CancelException e) {
            this.disconnectRemoteHost();
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.remotetools.environment.cellsimulator", 1, Messages.RemoteTargetControl_CouldNotCreatePortForward, (Throwable)e));
        }
    }

    private void disconnectRemoteHost() {
        this.remoteHostDisconnector.disable();
        this.shhTunnel = null;
        this.javaApiTunnel = null;
        this.consoleTunnel = null;
        this.tunnels = null;
        if (this.remoteHostManager != null) {
            try {
                this.remoteHostManager.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.remoteHostManager = null;
        }
        if (this.remoteHostConnection != null) {
            try {
                this.remoteHostConnection.disconnect();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.remoteHostConnection = null;
        }
    }

    public boolean kill(IProgressMonitor monitor) throws CoreException {
        if (this.query() == 1) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.remotetools.environment.cellsimulator", 1, Messages.RemoteTargetControl_SimulatorNotLaunched, null));
        }
        if (this.simulatorControl.getStatus().isNotRunning()) {
            this.disconnectRemoteHost();
            this.setState(1);
            return true;
        }
        this.releaseResumePauseStrategy();
        if (!this.simulatorControl.getStatus().isOperational()) {
            this.disconnect();
            this.simulatorControl.kill();
            this.disconnectRemoteHost();
            return true;
        }
        ProgressQueue progressQueue = new ProgressQueue(monitor);
        progressQueue.setCancelMessage(Messages.RemoteTargetControl_LocalCellSimulatorLaunchShutdownCancelation);
        progressQueue.setInterruptMessage(Messages.RemoteTargetControl_LocalCellSimulatorForceShutdown);
        progressQueue.setTaskName(Messages.RemoteTargetControl_LocalCellSimulatorShutdown);
        progressQueue.addWait(-1, Messages.RemoteTargetControl_ShuttingDown, 0);
        this.populateProgressQueueWithSimulatorShutdown(progressQueue);
        progressQueue.addWait(-2, Messages.RemoteTargetControl_ShutDownCompleted, 1);
        progressQueue.addWait(-3, Messages.RemoteTargetControl_CleaningUp, 1);
        progressQueue.addWait(10000, Messages.RemoteTargetControl_Disconnecting, 1);
        progressQueue.setCancelCallBack((ICancelCallback)new ShutdownCancelCallback(this));
        progressQueue.start();
        try {
            try {
                try {
                    this.simulatorControl.resume();
                    this.terminateJobs(monitor);
                }
                finally {
                    this.disconnect();
                }
                this.kindlyReleaseSimulator(progressQueue);
                this.setState(4);
                this.disconnectRemoteHost();
                progressQueue.notifyOperationCompleted(10002);
                this.setState(1);
                progressQueue.finish();
            }
            catch (Exception exception) {
                progressQueue.interrupt();
                this.releaseResumePauseStrategy();
                this.disconnect();
                this.releaseSimulator();
                this.disconnectRemoteHost();
                monitor.done();
                this.setState(1);
            }
        }
        finally {
            monitor.done();
            this.setState(1);
        }
        return true;
    }

    public synchronized int query() {
        if (this.state == 2) {
            return 0;
        }
        if (this.state == 3) {
            if (this.simulatorControl.getStatus().isOperational()) {
                if (!this.isConnected()) {
                    return 0;
                }
                if (this.simulatorControl.getStatus().isPaused()) {
                    return 3;
                }
                return 2;
            }
            return 0;
        }
        if (this.state == 4) {
            return 0;
        }
        return 1;
    }

    public void updateConfiguration() throws CoreException {
        RemoteConfigurationBean configurationBean = new RemoteConfigurationBean(this.targetElement.getAttributes());
        this.factory = new RemoteConfigFactory(configurationBean);
        this.setCurrentTargetConfig(this.factory.createTargetConfig());
        this.updateConsoles();
    }

    private IRemoteTunnel createTunnel(int remotePort) throws RemoteConnectionException, LocalPortBoundException, CancelException {
        Integer remotePortInteger = new Integer(remotePort);
        if (this.tunnels.containsKey(remotePortInteger)) {
            return (IRemoteTunnel)this.tunnels.get(remotePortInteger);
        }
        IRemoteTunnel tunnel = this.remoteHostManager.createTunnel(this.simulatorControl.getParameters().getIpSimulator(), remotePort);
        this.tunnels.put(remotePortInteger, tunnel);
        return tunnel;
    }

    public ITargetControl.TargetSocket createTargetSocket(int port) throws CoreException {
        Assert.isTrue((boolean)this.isConnected());
        try {
            IRemoteTunnel tunnel = this.createTunnel(port);
            ITargetControl.TargetSocket socket = new ITargetControl.TargetSocket();
            socket.host = "localhost";
            socket.port = tunnel.getLocalPort();
            return socket;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.remotetools.environment.cellsimulator", 0, Messages.RemoteTargetControl_CouldNotCreateSocket, (Throwable)e));
        }
    }

    public String getSystemWorkspace() {
        IPreferenceStore store = CellSimulatorTargetPlugin.getDefault().getPreferenceStore();
        return store.getString("local-system-workspace-dir");
    }

    public void destroy() throws CoreException {
        if (this.query() == 1) {
            return;
        }
        if (this.simulatorControl.getStatus().isNotRunning()) {
            this.disconnectRemoteHost();
            this.setState(1);
            return;
        }
        this.releaseResumePauseStrategy();
        if (!this.simulatorControl.getStatus().isOperational()) {
            this.disconnect();
            this.simulatorControl.kill();
            this.disconnectRemoteHost();
            return;
        }
        try {
            try {
                try {
                    this.simulatorControl.resume();
                    this.terminateJobs(null);
                }
                finally {
                    this.disconnect();
                }
                this.simulatorControl.shutdown();
                this.setState(4);
                this.disconnectRemoteHost();
                this.setState(1);
            }
            catch (Exception exception) {
                this.disconnect();
                this.releaseSimulator();
                this.disconnectRemoteHost();
                this.setState(1);
            }
        }
        finally {
            this.setState(1);
        }
    }

    protected class LaunchCancelCallback
    implements ICancelCallback {
        RemoteTargetControl control;

        public LaunchCancelCallback(RemoteTargetControl control) {
            this.control = control;
        }

        public void cancel(boolean byUser) {
            RemoteTargetControl.this.releaseSimulator();
        }
    }

    class RemoteHostDisconnector
    implements ISimulatorListener {
        boolean enabled = false;
        RemoteTargetControl control;

        public RemoteHostDisconnector(RemoteTargetControl control) {
            this.control = control;
            this.control.simulatorControl.addListener((ISimulatorListener)this);
        }

        void enable() {
            this.enabled = true;
        }

        void disable() {
            this.enabled = false;
        }

        public void lifecycleStateChanged(int state) {
            if (!this.enabled) {
                return;
            }
            if (state == 13) {
                this.control.disconnectRemoteHost();
                this.control.setState(1);
            }
        }

        public void progressChanged(int progress) {
        }

        public void simulationStatus(int status) {
        }
    }

    protected class ShutdownCancelCallback
    implements ICancelCallback {
        RemoteTargetControl control;

        public ShutdownCancelCallback(RemoteTargetControl control) {
            this.control = control;
        }

        public void cancel(boolean byUser) {
            RemoteTargetControl.this.releaseSimulator();
        }
    }
}

