/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMNode;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.PDOMNodeLinkedList;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPSpecialization;
import org.eclipse.core.runtime.CoreException;

abstract class PDOMCPPInstance
extends PDOMCPPSpecialization
implements ICPPTemplateInstance {
    private static final int ARGUMENTS = 44;
    protected static final int RECORD_SIZE = 48;

    public PDOMCPPInstance(PDOM pdom, PDOMNode parent, ICPPTemplateInstance inst, PDOMBinding instantiated) throws CoreException {
        super(pdom, parent, inst, instantiated);
        PDOMNodeLinkedList list = new PDOMNodeLinkedList(pdom, this.record + 44, this.getLinkageImpl());
        IType[] args = inst.getArguments();
        int i = 0;
        while (i < args.length) {
            PDOMNode typeNode = this.getLinkageImpl().addType(this, args[i]);
            if (typeNode != null) {
                list.addMember(typeNode);
            }
            ++i;
        }
    }

    public PDOMCPPInstance(PDOM pdom, int bindingRecord) {
        super(pdom, bindingRecord);
    }

    public ICPPTemplateDefinition getTemplateDefinition() {
        return (ICPPTemplateDefinition)this.getSpecializedBinding();
    }

    public IType[] getArguments() {
        try {
            PDOMNodeLinkedList list = new PDOMNodeLinkedList(this.pdom, this.record + 44, this.getLinkageImpl());
            TemplateArgumentCollector visitor = new TemplateArgumentCollector();
            list.accept(visitor);
            return visitor.getTemplateArguments();
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return IType.EMPTY_TYPE_ARRAY;
        }
    }

    public boolean matchesArguments(IType[] arguments) {
        IType[] args = this.getArguments();
        if (args.length == arguments.length) {
            int i = 0;
            while (i < args.length) {
                if (!CPPTemplates.isSameTemplateArgument(args[i], arguments[i])) break;
                ++i;
            }
            return i == args.length;
        }
        return false;
    }

    private static class TemplateArgumentCollector
    implements IPDOMVisitor {
        private List<IType> args = new ArrayList<IType>();

        private TemplateArgumentCollector() {
        }

        public boolean visit(IPDOMNode node) throws CoreException {
            if (node instanceof IType) {
                this.args.add((IType)((Object)node));
            }
            return false;
        }

        public void leave(IPDOMNode node) throws CoreException {
        }

        public IType[] getTemplateArguments() {
            return this.args.toArray(new IType[this.args.size()]);
        }
    }
}

