/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.internal.core.parser.scanner.ASTFileLocation;
import org.eclipse.cdt.internal.core.parser.scanner.ASTInclusionStatement;
import org.eclipse.cdt.internal.core.parser.scanner.ILocationCtx;
import org.eclipse.cdt.internal.core.parser.scanner.LocationCtxContainer;
import org.eclipse.cdt.internal.core.parser.scanner.LocationCtxMacroExpansion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class LocationCtx
implements ILocationCtx {
    final LocationCtxContainer fParent;
    final int fSequenceNumber;
    final int fOffsetInParent;
    final int fEndOffsetInParent;

    public LocationCtx(LocationCtxContainer parent, int parentOffset, int parentEndOffset, int sequenceNumber) {
        this.fParent = parent;
        this.fOffsetInParent = parentOffset;
        this.fEndOffsetInParent = parentEndOffset;
        this.fSequenceNumber = sequenceNumber;
        if (parent != null) {
            parent.addChild(this);
        }
    }

    @Override
    public String getFilePath() {
        return this.fParent.getFilePath();
    }

    @Override
    public final ILocationCtx getParent() {
        return this.fParent;
    }

    public abstract int getSequenceLength();

    public int getSequenceNumberForOffset(int offset, boolean checkChildren) {
        return this.fSequenceNumber + offset;
    }

    public void addChildSequenceLength(int childLength) {
        assert (false);
    }

    public int getLineNumber(int offset) {
        return 0;
    }

    public LocationCtx findSurroundingContext(int sequenceNumber, int length) {
        return this;
    }

    public LocationCtxMacroExpansion findEnclosingMacroExpansion(int sequenceNumber, int length) {
        return null;
    }

    public ASTFileLocation findMappedFileLocation(int sequenceNumber, int length) {
        return this.fParent.createMappedFileLocation(this.fOffsetInParent, this.fEndOffsetInParent - this.fOffsetInParent);
    }

    public ASTFileLocation createMappedFileLocation(int offset, int length) {
        return this.fParent.createMappedFileLocation(this.fOffsetInParent, this.fEndOffsetInParent - this.fOffsetInParent);
    }

    public abstract boolean collectLocations(int var1, int var2, ArrayList<IASTNodeLocation> var3);

    public void getInclusions(ArrayList<IASTTranslationUnit.IDependencyTree.IASTInclusionNode> result) {
    }

    public ASTInclusionStatement getInclusionStatement() {
        return null;
    }

    public Collection<LocationCtx> getChildren() {
        return Collections.emptySet();
    }
}

