/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import java.lang.reflect.Field;
import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFileSet;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.index.IIndexFragment;
import org.eclipse.cdt.internal.core.index.IIndexFragmentBinding;
import org.eclipse.cdt.internal.core.index.IIndexScope;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.db.IString;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMFile;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMName;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNamedNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNotImplementedError;
import org.eclipse.core.runtime.CoreException;

public abstract class PDOMBinding
extends PDOMNamedNode
implements IIndexFragmentBinding {
    public static final PDOMBinding[] EMPTY_PDOMBINDING_ARRAY = new PDOMBinding[0];
    private static final int FIRST_DECL_OFFSET = 12;
    private static final int FIRST_DEF_OFFSET = 16;
    private static final int FIRST_REF_OFFSET = 20;
    private static final int LOCAL_TO_FILE = 24;
    protected static final int RECORD_SIZE = 28;

    protected PDOMBinding(PDOM pdom, PDOMNode parent, char[] name) throws CoreException {
        super(pdom, parent, name);
    }

    public PDOMBinding(PDOM pdom, int record) {
        super(pdom, record);
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(PDOMBinding.class)) {
            return this;
        }
        return null;
    }

    public static boolean isOrphaned(PDOM pdom, int record) throws CoreException {
        Database db = pdom.getDB();
        return db.getInt(record + 12) == 0 && db.getInt(record + 16) == 0 && db.getInt(record + 20) == 0;
    }

    public int getRecord() {
        return this.record;
    }

    public final boolean hasDeclaration() throws CoreException {
        Database db = this.pdom.getDB();
        return db.getInt(this.record + 12) != 0 || db.getInt(this.record + 16) != 0;
    }

    public void addDeclaration(PDOMName name) throws CoreException {
        PDOMName first = this.getFirstDeclaration();
        if (first != null) {
            first.setPrevInBinding(name);
            name.setNextInBinding(first);
        }
        this.setFirstDeclaration(name);
    }

    public void addDefinition(PDOMName name) throws CoreException {
        PDOMName first = this.getFirstDefinition();
        if (first != null) {
            first.setPrevInBinding(name);
            name.setNextInBinding(first);
        }
        this.setFirstDefinition(name);
    }

    public void addReference(PDOMName name) throws CoreException {
        PDOMName first = this.getFirstReference();
        if (first != null) {
            first.setPrevInBinding(name);
            name.setNextInBinding(first);
        }
        this.setFirstReference(name);
    }

    public PDOMName getFirstDeclaration() throws CoreException {
        int namerec = this.pdom.getDB().getInt(this.record + 12);
        return namerec != 0 ? new PDOMName(this.pdom, namerec) : null;
    }

    public void setFirstDeclaration(PDOMName name) throws CoreException {
        int namerec = name != null ? name.getRecord() : 0;
        this.pdom.getDB().putInt(this.record + 12, namerec);
    }

    public PDOMName getFirstDefinition() throws CoreException {
        int namerec = this.pdom.getDB().getInt(this.record + 16);
        return namerec != 0 ? new PDOMName(this.pdom, namerec) : null;
    }

    public void setFirstDefinition(PDOMName name) throws CoreException {
        int namerec = name != null ? name.getRecord() : 0;
        this.pdom.getDB().putInt(this.record + 16, namerec);
    }

    public PDOMName getFirstReference() throws CoreException {
        int namerec = this.pdom.getDB().getInt(this.record + 20);
        return namerec != 0 ? new PDOMName(this.pdom, namerec) : null;
    }

    public void setFirstReference(PDOMName name) throws CoreException {
        int namerec = name != null ? name.getRecord() : 0;
        this.pdom.getDB().putInt(this.record + 20, namerec);
    }

    public final PDOMFile getLocalToFile() throws CoreException {
        int filerec = PDOMBinding.getLocalToFileRec(this.pdom, this.record);
        return filerec == 0 ? null : new PDOMFile(this.pdom, filerec);
    }

    public final int getLocalToFileRec() throws CoreException {
        return this.pdom.getDB().getInt(this.record + 24);
    }

    public static int getLocalToFileRec(PDOM pdom, int record) throws CoreException {
        return pdom.getDB().getInt(record + 24);
    }

    public final void setLocalToFileRec(int rec) throws CoreException {
        this.pdom.getDB().putInt(this.record + 24, rec);
    }

    public String getName() {
        try {
            return super.getDBName().getString();
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return "";
        }
    }

    public char[] getNameCharArray() {
        try {
            return super.getNameCharArray();
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return CharArrayUtils.EMPTY;
        }
    }

    public IIndexScope getParent() {
        try {
            IIndexBinding parent = this.getParentBinding();
            if (parent instanceof IIndexScope) {
                return (IIndexScope)((Object)parent);
            }
        }
        catch (CoreException ce) {
            CCorePlugin.log((Throwable)ce);
        }
        return null;
    }

    public IIndexScope getScope() {
        try {
            IIndexBinding parent = this.getParentBinding();
            if (parent instanceof IIndexScope) {
                return (IIndexScope)((Object)parent);
            }
            if (parent instanceof ICPPUnknownBinding) {
                return (IIndexScope)((Object)((ICPPUnknownBinding)((Object)parent)).getUnknownScope());
            }
        }
        catch (DOMException dOMException) {
        }
        catch (CoreException ce) {
            CCorePlugin.log((Throwable)ce);
        }
        return null;
    }

    public IIndexBinding getParentBinding() throws CoreException {
        PDOMNode parent = this.getParentNode();
        if (parent instanceof IIndexBinding) {
            return (IIndexBinding)((Object)parent);
        }
        return null;
    }

    public IIndexFragment getFragment() {
        return this.pdom;
    }

    protected abstract int getRecordSize();

    public String toString() {
        try {
            return String.valueOf(this.getName()) + " " + PDOMBinding.getConstantNameForValue(this.getLinkageImpl(), this.getNodeType());
        }
        catch (CoreException coreException) {
            return String.valueOf(this.getName()) + " " + this.getNodeType();
        }
    }

    protected static String getConstantNameForValue(PDOMLinkage linkage, int value) {
        Field[] fields;
        Class<?> c = linkage.getClass();
        Field[] fieldArray = fields = c.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            try {
                int fvalue;
                field.setAccessible(true);
                if ((field.getModifiers() & 8) != 0 && Integer.TYPE.equals(field.getType()) && (fvalue = field.getInt(null)) == value) {
                    return field.getName();
                }
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            ++n2;
        }
        return Integer.toString(value);
    }

    protected final void fail() {
        throw new PDOMNotImplementedError("in " + this.getClass().getCanonicalName());
    }

    public PDOMName getScopeName() {
        try {
            PDOMName name = this.getFirstDefinition();
            if (name == null) {
                name = this.getFirstDeclaration();
            }
            return name;
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return null;
        }
    }

    public final String[] getQualifiedName() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            PDOMNode node = this;
            while (node != null) {
                if (node instanceof PDOMBinding && !(node instanceof ICPPTemplateInstance)) {
                    result.add(0, ((PDOMBinding)node).getName());
                }
                node = node.getParentNode();
            }
            return result.toArray(new String[result.size()]);
        }
        catch (CoreException ce) {
            CCorePlugin.log((Throwable)ce);
            return null;
        }
    }

    public final boolean isFileLocal() throws CoreException {
        return this.pdom.getDB().getInt(this.record + 24) != 0;
    }

    public boolean hasDefinition() throws CoreException {
        return this.getFirstDefinition() != null;
    }

    private static int comparePDOMBindingQNs(PDOMBinding b0, PDOMBinding b1) {
        try {
            int cmp = 0;
            do {
                int l2;
                IString s1;
                IString s0;
                if ((cmp = (s0 = b0.getDBName()).compare(s1 = b1.getDBName(), true)) != 0) continue;
                int l1 = b0.getLocalToFileRec();
                if (l1 != (l2 = b1.getLocalToFileRec())) {
                    return l1 < l2 ? -1 : 1;
                }
                b0 = (PDOMBinding)b0.getParentBinding();
                b1 = (PDOMBinding)b1.getParentBinding();
                if (b0 != null && b1 != null) continue;
                int n = b0 == b1 ? 0 : (cmp = b0 == null ? -1 : 1);
            } while (cmp == 0 && b1 != null && b0 != null);
            return cmp;
        }
        catch (CoreException ce) {
            CCorePlugin.log((Throwable)ce);
            return -1;
        }
    }

    public int pdomCompareTo(PDOMBinding other) {
        int cmp = PDOMBinding.comparePDOMBindingQNs(this, other);
        if (cmp == 0) {
            int t2;
            int t1 = this.getNodeType();
            return t1 < (t2 = other.getNodeType()) ? -1 : (t1 > t2 ? 1 : 0);
        }
        return cmp;
    }

    public final boolean pdomEquals(PDOMBinding other) {
        return this.pdomCompareTo(other) == 0;
    }

    public final int getBindingConstant() {
        return this.getNodeType();
    }

    public void update(PDOMLinkage linkage, IBinding newBinding) throws CoreException {
    }

    public final void delete(PDOMLinkage linkage) throws CoreException {
        assert (false);
    }

    public int getAdditionalNameFlags(int standardFlags, IASTName name) {
        return 0;
    }

    public final IBinding getBinding(IASTName name, boolean resolve) throws DOMException {
        return this.getBinding(name, resolve, null);
    }

    public IBinding getBinding(IASTName name, boolean resolve, IIndexFileSet fileSet) throws DOMException {
        return null;
    }

    public final IBinding[] getBindings(IASTName name, boolean resolve, boolean prefix) throws DOMException {
        return this.getBindings(name, resolve, prefix, null);
    }

    public IBinding[] getBindings(IASTName name, boolean resolve, boolean prefix, IIndexFileSet fileSet) throws DOMException {
        return null;
    }
}

