/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPScope;
import org.eclipse.cdt.core.parser.util.IObjectMatcher;
import org.eclipse.cdt.core.parser.util.ObjectMap;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.core.runtime.Assert;

public class CPPTypedefSpecialization
extends CPPSpecialization
implements ITypedef,
ITypeContainer {
    public static final int MAX_RESOLUTION_DEPTH = 5;
    private IType type;
    private int fResolutionDepth;

    public CPPTypedefSpecialization(IBinding specialized, ICPPScope scope, ObjectMap argumentMap) {
        super(specialized, scope, argumentMap);
    }

    private ITypedef getTypedef() {
        return (ITypedef)this.getSpecializedBinding();
    }

    public IType getType() throws DOMException {
        if (this.type == null) {
            try {
                if (++this.fResolutionDepth > 5) {
                    this.type = new RecursionResolvingBinding(this.getDefinition(), this.getNameCharArray());
                } else {
                    this.type = CPPTemplates.instantiateType(this.getTypedef().getType(), this.argumentMap, this.getScope());
                    if (this.type instanceof CPPTypedefSpecialization && ((CPPTypedefSpecialization)this.type).getSpecializedBinding().equals(this.getSpecializedBinding()) && ((CPPTypedefSpecialization)this.type).getArgumentMap().isEquivalent(this.argumentMap, (IObjectMatcher)IType.TYPE_MATCHER)) {
                        this.type = new RecursionResolvingBinding(this.getDefinition(), this.getNameCharArray());
                    }
                }
            }
            finally {
                --this.fResolutionDepth;
            }
        }
        return this.type;
    }

    public int incResolutionDepth(int increment) {
        this.fResolutionDepth += increment;
        return this.fResolutionDepth;
    }

    public Object clone() {
        IType t = null;
        try {
            t = (IType)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return t;
    }

    public boolean isSameType(IType o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ITypedef) {
            try {
                IType t = this.getType();
                if (t != null) {
                    return t.isSameType(((ITypedef)o).getType());
                }
                return false;
            }
            catch (DOMException dOMException) {
                return false;
            }
        }
        try {
            IType t = this.getType();
            if (t != null) {
                return t.isSameType(o);
            }
        }
        catch (DOMException dOMException) {
            return false;
        }
        return false;
    }

    public void setType(IType type) {
        this.type = type;
    }

    static final class RecursionResolvingBinding
    extends ProblemBinding {
        public RecursionResolvingBinding(IASTNode node, char[] arg) {
            super(node, 14, arg);
            Assert.isTrue((boolean)CPPASTName.fAllowRecursionBindings, (String)this.getMessage());
        }
    }
}

