/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTVisibilityLabel;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTBaseDeclSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassScope;

public class CPPASTCompositeTypeSpecifier
extends CPPASTBaseDeclSpecifier
implements ICPPASTCompositeTypeSpecifier,
IASTAmbiguityParent {
    private int k;
    private IASTName n;
    private IScope scope;
    private IASTDeclaration[] declarations = new IASTDeclaration[4];
    private ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier[] baseSpecs = null;
    private int baseSpecsPos = -1;

    public CPPASTCompositeTypeSpecifier() {
    }

    public CPPASTCompositeTypeSpecifier(int k, IASTName n) {
        this.k = k;
        this.setName(n);
    }

    public String getRawSignature() {
        return this.getName().toString() == null ? "" : this.getName().toString();
    }

    public ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier[] getBaseSpecifiers() {
        if (this.baseSpecs == null) {
            return ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier.EMPTY_BASESPECIFIER_ARRAY;
        }
        this.baseSpecs = (ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier[])ArrayUtil.removeNullsAfter(ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier.class, this.baseSpecs, this.baseSpecsPos);
        return this.baseSpecs;
    }

    public void addBaseSpecifier(ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier baseSpec) {
        if (baseSpec != null) {
            baseSpec.setParent(this);
            baseSpec.setPropertyInParent(BASE_SPECIFIER);
            this.baseSpecs = (ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier[])ArrayUtil.append(ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier.class, this.baseSpecs, ++this.baseSpecsPos, baseSpec);
        }
    }

    public int getKey() {
        return this.k;
    }

    public void setKey(int key) {
        this.k = key;
    }

    public IASTName getName() {
        return this.n;
    }

    public void setName(IASTName name) {
        this.n = name;
        if (name != null) {
            name.setParent(this);
            name.setPropertyInParent(TYPE_NAME);
        }
    }

    public IASTDeclaration[] getMembers() {
        if (this.declarations == null) {
            return IASTDeclaration.EMPTY_DECLARATION_ARRAY;
        }
        return (IASTDeclaration[])ArrayUtil.trim(IASTDeclaration.class, this.declarations);
    }

    public void addMemberDeclaration(IASTDeclaration decl) {
        this.declarations = (IASTDeclaration[])ArrayUtil.append(IASTDeclaration.class, this.declarations, decl);
        if (decl != null) {
            decl.setParent(this);
            decl.setPropertyInParent(decl instanceof ICPPASTVisibilityLabel ? VISIBILITY_LABEL : MEMBER_DECLARATION);
        }
    }

    public IScope getScope() {
        if (this.scope == null) {
            this.scope = new CPPClassScope(this);
        }
        return this.scope;
    }

    public void setScope(IScope scope) {
        this.scope = scope;
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitDeclSpecifiers) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.n != null && !this.n.accept(action)) {
            return false;
        }
        ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier[] bases = this.getBaseSpecifiers();
        int i = 0;
        while (i < bases.length) {
            if (!bases[i].accept(action)) {
                return false;
            }
            ++i;
        }
        IASTDeclaration[] decls = this.getMembers();
        int i2 = 0;
        while (i2 < decls.length) {
            if (!decls[i2].accept(action)) {
                return false;
            }
            ++i2;
        }
        if (action.shouldVisitDeclSpecifiers) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public int getRoleForName(IASTName name) {
        if (name == this.n) {
            return 2;
        }
        return 3;
    }

    public void replace(IASTNode child, IASTNode other) {
        if (this.declarations == null) {
            return;
        }
        int i = 0;
        while (i < this.declarations.length) {
            if (this.declarations[i] == null) break;
            if (this.declarations[i] == child) {
                other.setParent(child.getParent());
                other.setPropertyInParent(child.getPropertyInParent());
                this.declarations[i] = (IASTDeclaration)other;
            }
            ++i;
        }
    }
}

