/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import java.util.ArrayList;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTReferenceOperator;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.cpp.OverloadableOperator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;

class ImplicitsAnalysis {
    private boolean hasUserDeclaredConstructor;
    private boolean hasUserDeclaredCopyConstructor;
    private boolean hasUserDeclaredCopyAssignmentOperator;
    private boolean hasUserDeclaredDestructor;

    ImplicitsAnalysis(ICPPASTCompositeTypeSpecifier compSpec) {
        boolean hasUserDeclaredCAO;
        ICPPASTFunctionDeclarator[] ctors = ImplicitsAnalysis.getUserDeclaredCtorOrDtor(compSpec, true);
        this.hasUserDeclaredConstructor = ctors.length > 0;
        this.hasUserDeclaredCopyConstructor = false;
        this.hasUserDeclaredCopyAssignmentOperator = false;
        this.hasUserDeclaredDestructor = ImplicitsAnalysis.getUserDeclaredCtorOrDtor(compSpec, false).length > 0;
        int i = 0;
        while (i < ctors.length) {
            block4: {
                ICPPASTFunctionDeclarator dcltor = ctors[i];
                IASTParameterDeclaration[] ps = dcltor.getParameters();
                if (ps.length >= 1 && ImplicitsAnalysis.paramHasTypeReferenceToTheAssociatedClassType(ps[0], compSpec.getName().getRawSignature())) {
                    int j = 1;
                    while (j < ps.length) {
                        if (ps[j].getDeclarator().getInitializer() != null) {
                            ++j;
                            continue;
                        }
                        break block4;
                    }
                    this.hasUserDeclaredCopyConstructor = true;
                }
            }
            ++i;
        }
        this.hasUserDeclaredCopyAssignmentOperator = hasUserDeclaredCAO = ImplicitsAnalysis.getUserDeclaredCopyAssignmentOperators(compSpec).length > 0;
    }

    public int getImplicitsToDeclareCount() {
        return (!this.hasUserDeclaredDestructor ? 1 : 0) + (!this.hasUserDeclaredConstructor ? 1 : 0) + (!this.hasUserDeclaredCopyConstructor ? 1 : 0) + (!this.hasUserDeclaredCopyAssignmentOperator ? 1 : 0);
    }

    private static ICPPASTFunctionDeclarator[] getUserDeclaredCtorOrDtor(ICPPASTCompositeTypeSpecifier compSpec, boolean constructor) {
        ArrayList<ICPPASTFunctionDeclarator> result = new ArrayList<ICPPASTFunctionDeclarator>();
        IASTDeclaration[] members = compSpec.getMembers();
        char[] name = compSpec.getName().toCharArray();
        IASTDeclarator dcltor = null;
        IASTDeclSpecifier spec = null;
        IASTDeclaration[] iASTDeclarationArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            block8: {
                block9: {
                    IASTDeclaration member;
                    block7: {
                        member = iASTDeclarationArray[n2];
                        if (!(member instanceof IASTSimpleDeclaration)) break block7;
                        IASTDeclarator[] dtors = ((IASTSimpleDeclaration)member).getDeclarators();
                        if (dtors.length == 0 || dtors.length > 1) break block8;
                        dcltor = dtors[0];
                        spec = ((IASTSimpleDeclaration)member).getDeclSpecifier();
                        break block9;
                    }
                    if (member instanceof IASTFunctionDefinition) {
                        dcltor = ((IASTFunctionDefinition)member).getDeclarator();
                        spec = ((IASTFunctionDefinition)member).getDeclSpecifier();
                    }
                }
                if (dcltor instanceof ICPPASTFunctionDeclarator && spec instanceof IASTSimpleDeclSpecifier && ((IASTSimpleDeclSpecifier)spec).getType() == 0) {
                    boolean nameEquals = false;
                    char[] dtorname = CPPVisitor.findInnermostDeclarator(dcltor).getName().toCharArray();
                    if (constructor) {
                        nameEquals = CharArrayUtils.equals(dtorname, name);
                    } else if (dtorname.length > 0 && dtorname[0] == '~') {
                        nameEquals = CharArrayUtils.equals(dtorname, 1, name.length, name);
                    }
                    if (nameEquals) {
                        result.add((ICPPASTFunctionDeclarator)dcltor);
                    }
                }
            }
            ++n2;
        }
        return result.toArray(new ICPPASTFunctionDeclarator[result.size()]);
    }

    private static ICPPASTFunctionDeclarator[] getUserDeclaredCopyAssignmentOperators(ICPPASTCompositeTypeSpecifier compSpec) {
        ArrayList<ICPPASTFunctionDeclarator> result = new ArrayList<ICPPASTFunctionDeclarator>();
        IASTDeclaration[] members = compSpec.getMembers();
        IASTDeclarator dcltor = null;
        IASTDeclaration[] iASTDeclarationArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            block4: {
                IASTParameterDeclaration[] ps;
                char[] nchars;
                block5: {
                    IASTDeclaration member;
                    block3: {
                        member = iASTDeclarationArray[n2];
                        if (!(member instanceof IASTSimpleDeclaration)) break block3;
                        IASTDeclarator[] dtors = ((IASTSimpleDeclaration)member).getDeclarators();
                        if (dtors.length == 0 || dtors.length > 1) break block4;
                        dcltor = dtors[0];
                        break block5;
                    }
                    if (member instanceof IASTFunctionDefinition) {
                        dcltor = ((IASTFunctionDefinition)member).getDeclarator();
                    }
                }
                if (dcltor instanceof ICPPASTFunctionDeclarator && CharArrayUtils.equals(nchars = CPPVisitor.findInnermostDeclarator(dcltor).getName().toCharArray(), OverloadableOperator.ASSIGN.toCharArray()) && (ps = ((ICPPASTFunctionDeclarator)dcltor).getParameters()).length == 1 && ImplicitsAnalysis.paramHasTypeReferenceToTheAssociatedClassType(ps[0], null)) {
                    result.add((ICPPASTFunctionDeclarator)dcltor);
                }
            }
            ++n2;
        }
        return result.toArray(new ICPPASTFunctionDeclarator[result.size()]);
    }

    private static boolean paramHasTypeReferenceToTheAssociatedClassType(IASTParameterDeclaration dec, String name) {
        boolean result = false;
        IASTDeclarator pdtor = CPPVisitor.findTypeRelevantDeclarator(dec.getDeclarator());
        if (pdtor.getPointerOperators().length == 1 && pdtor.getPointerOperators()[0] instanceof ICPPASTReferenceOperator && pdtor.getParent() == dec && dec.getDeclSpecifier() instanceof ICPPASTNamedTypeSpecifier) {
            ICPPASTNamedTypeSpecifier nts = (ICPPASTNamedTypeSpecifier)dec.getDeclSpecifier();
            if (name == null || name.equals(nts.getName().getRawSignature())) {
                result = true;
            }
        }
        return result;
    }

    public boolean hasUserDeclaredConstructor() {
        return this.hasUserDeclaredConstructor;
    }

    public boolean hasUserDeclaredCopyConstructor() {
        return this.hasUserDeclaredCopyConstructor;
    }

    public boolean hasUserDeclaredCopyAssignmentOperator() {
        return this.hasUserDeclaredCopyAssignmentOperator;
    }

    public boolean hasUserDeclaredDestructor() {
        return this.hasUserDeclaredDestructor;
    }
}

