/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.dom.lrparser.lpgextensions;

import lpg.lpgjavaruntime.BadParseException;
import lpg.lpgjavaruntime.BadParseSymFileException;
import lpg.lpgjavaruntime.ConfigurationElement;
import lpg.lpgjavaruntime.ConfigurationStack;
import lpg.lpgjavaruntime.IntTuple;
import lpg.lpgjavaruntime.Monitor;
import lpg.lpgjavaruntime.NotBacktrackParseTableException;
import lpg.lpgjavaruntime.ParseTable;
import lpg.lpgjavaruntime.PrsStream;
import lpg.lpgjavaruntime.RuleAction;
import lpg.lpgjavaruntime.Stacks;
import lpg.lpgjavaruntime.TokenStream;

public class FixedBacktrackingParser
extends Stacks {
    private Monitor monitor = null;
    private int START_STATE;
    private int NUM_RULES;
    private int LA_STATE_OFFSET;
    private int EOFT_SYMBOL;
    private int ERROR_SYMBOL;
    private int ACCEPT_ACTION;
    private int ERROR_ACTION;
    private int lastToken;
    private int currentAction;
    private TokenStream tokStream;
    private ParseTable prs;
    private RuleAction ra;
    private IntTuple action = new IntTuple(1024);
    private IntTuple tokens;
    private int[] actionStack;
    private boolean skipTokens = false;

    public final int getToken(int i) {
        return this.tokens.get(this.locationStack[this.stateStackTop + (i - 1)]);
    }

    public final int getCurrentRule() {
        return this.currentAction;
    }

    public final int getFirstToken() {
        return this.tokStream.getFirstErrorToken(this.getToken(1));
    }

    public final int getFirstToken(int i) {
        return this.tokStream.getFirstErrorToken(this.getToken(i));
    }

    public final int getLastToken() {
        return this.tokStream.getLastErrorToken(this.lastToken);
    }

    public final int getLastToken(int i) {
        int l = i >= this.prs.rhs(this.currentAction) ? this.lastToken : this.tokens.get(this.locationStack[this.stateStackTop + i] - 1);
        return this.tokStream.getLastErrorToken(l);
    }

    public FixedBacktrackingParser(TokenStream tokStream, ParseTable prs, RuleAction ra) throws BadParseSymFileException, NotBacktrackParseTableException {
        this.tokStream = (PrsStream)tokStream;
        this.prs = prs;
        this.ra = ra;
        this.START_STATE = prs.getStartState();
        this.NUM_RULES = prs.getNumRules();
        this.LA_STATE_OFFSET = prs.getLaStateOffset();
        this.EOFT_SYMBOL = prs.getEoftSymbol();
        this.ERROR_SYMBOL = prs.getErrorSymbol();
        this.ACCEPT_ACTION = prs.getAcceptAction();
        this.ERROR_ACTION = prs.getErrorAction();
        if (!prs.isValidForParser()) {
            throw new BadParseSymFileException();
        }
        if (!prs.getBacktrack()) {
            throw new NotBacktrackParseTableException();
        }
    }

    public FixedBacktrackingParser(Monitor monitor, TokenStream tokStream, ParseTable prs, RuleAction ra) throws BadParseSymFileException, NotBacktrackParseTableException {
        this(tokStream, prs, ra);
        this.monitor = monitor;
    }

    public void reallocateOtherStacks(int start_token_index) {
        if (this.actionStack == null) {
            this.actionStack = new int[this.stateStack.length];
            this.locationStack = new int[this.stateStack.length];
            this.parseStack = new Object[this.stateStack.length];
            this.actionStack[0] = 0;
            this.locationStack[0] = start_token_index;
        } else if (this.actionStack.length < this.stateStack.length) {
            int old_length = this.actionStack.length;
            this.actionStack = new int[this.stateStack.length];
            System.arraycopy(this.actionStack, 0, this.actionStack, 0, old_length);
            this.locationStack = new int[this.stateStack.length];
            System.arraycopy(this.locationStack, 0, this.locationStack, 0, old_length);
            this.parseStack = new Object[this.stateStack.length];
            System.arraycopy(this.parseStack, 0, this.parseStack, 0, old_length);
        }
    }

    public Object parse() throws BadParseException {
        return this.parse(0);
    }

    public Object parse(int max_error_count) throws BadParseException {
        int initial_error_token;
        max_error_count = 1000;
        this.action.reset();
        this.tokStream.reset();
        this.reallocateStateStack();
        this.stateStackTop = 0;
        this.stateStack[0] = this.START_STATE;
        this.skipTokens = max_error_count < 0;
        this.tokens = new IntTuple(this.tokStream.getStreamLength());
        this.tokens.add(this.tokStream.getPrevious(this.tokStream.peek()));
        int repair_token = 0;
        int start_token_index = this.tokStream.peek();
        int start_action_index = this.action.size();
        int[] temp_stack = new int[]{this.START_STATE};
        int error_token = initial_error_token = this.backtrackParse(repair_token);
        int count = 0;
        while (error_token != 0) {
            if (count == max_error_count) {
                throw new BadParseException(initial_error_token);
            }
            this.action.reset(start_action_index);
            this.tokStream.reset(start_token_index);
            this.stateStackTop = temp_stack.length - 1;
            System.arraycopy(temp_stack, 0, this.stateStack, 0, temp_stack.length);
            this.reallocateOtherStacks(start_token_index);
            this.backtrackParseUpToError(repair_token, error_token);
            this.stateStackTop = this.findRecoveryStateIndex(this.stateStackTop);
            while (this.stateStackTop >= 0) {
                int recovery_token = this.tokens.get(this.locationStack[this.stateStackTop] - 1);
                repair_token = this.errorRepair(recovery_token >= start_token_index ? recovery_token : error_token, error_token);
                if (repair_token != 0) break;
                this.stateStackTop = this.findRecoveryStateIndex(this.stateStackTop - 1);
            }
            if (this.stateStackTop < 0) {
                throw new BadParseException(initial_error_token);
            }
            temp_stack = new int[this.stateStackTop + 1];
            System.arraycopy(this.stateStack, 0, temp_stack, 0, temp_stack.length);
            start_action_index = this.action.size();
            start_token_index = this.tokStream.peek();
            error_token = this.backtrackParse(repair_token);
            ++count;
        }
        if (repair_token != 0) {
            this.tokens.add(repair_token);
        }
        int t = start_token_index;
        while (this.tokStream.getKind(t) != this.EOFT_SYMBOL) {
            this.tokens.add(t);
            t = this.tokStream.getNext(t);
        }
        this.tokens.add(t);
        return this.parseActions();
    }

    private final void process_reductions() {
        do {
            this.stateStackTop -= this.prs.rhs(this.currentAction) - 1;
            this.ra.ruleAction(this.currentAction);
            this.currentAction = this.prs.ntAction(this.stateStack[this.stateStackTop], this.prs.lhs(this.currentAction));
        } while (this.currentAction <= this.NUM_RULES);
    }

    private Object parseActions() throws BadParseException {
        int ti = -1;
        this.lastToken = this.tokens.get(++ti);
        int curtok = this.tokens.get(++ti);
        this.allocateOtherStacks();
        this.stateStackTop = -1;
        this.currentAction = this.START_STATE;
        int i = 0;
        while (i < this.action.size()) {
            if (this.monitor != null && this.monitor.isCancelled()) {
                return null;
            }
            this.stateStack[++this.stateStackTop] = this.currentAction;
            this.locationStack[this.stateStackTop] = ti++;
            this.currentAction = this.action.get(i);
            if (this.currentAction <= this.NUM_RULES) {
                --this.stateStackTop;
                this.process_reductions();
            } else {
                this.lastToken = curtok;
                curtok = this.tokens.get(ti);
                if (this.currentAction > this.ERROR_ACTION) {
                    this.currentAction -= this.ERROR_ACTION;
                    this.process_reductions();
                }
            }
            ++i;
        }
        return this.parseStack[0];
    }

    private int process_backtrack_reductions(int act) {
        do {
            this.stateStackTop -= this.prs.rhs(act) - 1;
        } while ((act = this.prs.ntAction(this.stateStack[this.stateStackTop], this.prs.lhs(act))) <= this.NUM_RULES);
        return act;
    }

    private int backtrackParse(int initial_token) {
        ConfigurationStack configuration_stack = new ConfigurationStack(this.prs);
        int error_token = 0;
        int maxStackTop = this.stateStackTop;
        int start_token = this.tokStream.peek();
        int curtok = initial_token > 0 ? initial_token : this.tokStream.getToken();
        int current_kind = this.tokStream.getKind(curtok);
        int act = this.tAction(this.stateStack[this.stateStackTop], current_kind);
        while (true) {
            if (this.monitor != null && this.monitor.isCancelled()) {
                return 0;
            }
            if (act <= this.NUM_RULES) {
                this.action.add(act);
                --this.stateStackTop;
                act = this.process_backtrack_reductions(act);
            } else if (act > this.ERROR_ACTION) {
                this.action.add(act);
                curtok = this.tokStream.getToken();
                current_kind = this.tokStream.getKind(curtok);
                act = this.process_backtrack_reductions(act - this.ERROR_ACTION);
            } else if (act < this.ACCEPT_ACTION) {
                this.action.add(act);
                curtok = this.tokStream.getToken();
                current_kind = this.tokStream.getKind(curtok);
            } else {
                if (act == this.ERROR_ACTION) {
                    error_token = error_token > curtok ? error_token : curtok;
                    ConfigurationElement configuration = configuration_stack.pop();
                    if (configuration == null) {
                        act = this.ERROR_ACTION;
                        break;
                    }
                    this.action.reset(configuration.action_length);
                    act = configuration.act;
                    curtok = configuration.curtok;
                    current_kind = this.tokStream.getKind(curtok);
                    this.tokStream.reset(curtok == initial_token ? start_token : this.tokStream.getNext(curtok));
                    this.stateStackTop = configuration.stack_top;
                    configuration.retrieveStack(this.stateStack);
                    continue;
                }
                if (act <= this.ACCEPT_ACTION) break;
                if (configuration_stack.findConfiguration(this.stateStack, this.stateStackTop, curtok)) {
                    act = this.ERROR_ACTION;
                    continue;
                }
                configuration_stack.push(this.stateStack, this.stateStackTop, act + 1, curtok, this.action.size());
                act = this.prs.baseAction(act);
                maxStackTop = this.stateStackTop > maxStackTop ? this.stateStackTop : maxStackTop;
                continue;
            }
            try {
                this.stateStack[++this.stateStackTop] = act;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.reallocateStateStack();
                this.stateStack[this.stateStackTop] = act;
            }
            act = this.tAction(act, current_kind);
        }
        return act == this.ERROR_ACTION ? error_token : 0;
    }

    private void backtrackParseUpToError(int initial_token, int error_token) {
        ConfigurationStack configuration_stack = new ConfigurationStack(this.prs);
        int start_token = this.tokStream.peek();
        int curtok = initial_token > 0 ? initial_token : this.tokStream.getToken();
        int current_kind = this.tokStream.getKind(curtok);
        int act = this.tAction(this.stateStack[this.stateStackTop], current_kind);
        this.tokens.add(curtok);
        this.locationStack[this.stateStackTop] = this.tokens.size();
        this.actionStack[this.stateStackTop] = this.action.size();
        while (true) {
            if (this.monitor != null && this.monitor.isCancelled()) {
                return;
            }
            if (act <= this.NUM_RULES) {
                this.action.add(act);
                --this.stateStackTop;
                act = this.process_backtrack_reductions(act);
            } else if (act > this.ERROR_ACTION) {
                this.action.add(act);
                curtok = this.tokStream.getToken();
                current_kind = this.tokStream.getKind(curtok);
                this.tokens.add(curtok);
                act = this.process_backtrack_reductions(act - this.ERROR_ACTION);
            } else if (act < this.ACCEPT_ACTION) {
                this.action.add(act);
                curtok = this.tokStream.getToken();
                current_kind = this.tokStream.getKind(curtok);
                this.tokens.add(curtok);
            } else {
                if (act == this.ERROR_ACTION) {
                    if (curtok == error_token) break;
                    ConfigurationElement configuration = configuration_stack.pop();
                    if (configuration == null) {
                        act = this.ERROR_ACTION;
                        break;
                    }
                    this.action.reset(configuration.action_length);
                    act = configuration.act;
                    int next_token_index = configuration.curtok;
                    this.tokens.reset(next_token_index);
                    curtok = this.tokens.get(next_token_index - 1);
                    current_kind = this.tokStream.getKind(curtok);
                    this.tokStream.reset(curtok == initial_token ? start_token : this.tokStream.getNext(curtok));
                    this.stateStackTop = configuration.stack_top;
                    configuration.retrieveStack(this.stateStack);
                    this.locationStack[this.stateStackTop] = this.tokens.size();
                    this.actionStack[this.stateStackTop] = this.action.size();
                    continue;
                }
                if (act <= this.ACCEPT_ACTION) break;
                if (configuration_stack.findConfiguration(this.stateStack, this.stateStackTop, this.tokens.size())) {
                    act = this.ERROR_ACTION;
                    continue;
                }
                configuration_stack.push(this.stateStack, this.stateStackTop, act + 1, this.tokens.size(), this.action.size());
                act = this.prs.baseAction(act);
                continue;
            }
            this.stateStack[++this.stateStackTop] = act;
            this.locationStack[this.stateStackTop] = this.tokens.size();
            this.actionStack[this.stateStackTop] = this.action.size();
            act = this.tAction(act, current_kind);
        }
    }

    private boolean repairable(int error_token) {
        ConfigurationStack configuration_stack = new ConfigurationStack(this.prs);
        int start_token = this.tokStream.peek();
        int final_token = this.tokStream.getStreamLength();
        int curtok = 0;
        int current_kind = this.ERROR_SYMBOL;
        int act = this.tAction(this.stateStack[this.stateStackTop], current_kind);
        while (true) {
            if (act <= this.NUM_RULES) {
                --this.stateStackTop;
                act = this.process_backtrack_reductions(act);
            } else if (act > this.ERROR_ACTION) {
                curtok = this.tokStream.getToken();
                if (curtok > final_token) {
                    return true;
                }
                current_kind = this.tokStream.getKind(curtok);
                act = this.process_backtrack_reductions(act - this.ERROR_ACTION);
            } else if (act < this.ACCEPT_ACTION) {
                curtok = this.tokStream.getToken();
                if (curtok > final_token) {
                    return true;
                }
                current_kind = this.tokStream.getKind(curtok);
            } else {
                if (act == this.ERROR_ACTION) {
                    ConfigurationElement configuration = configuration_stack.pop();
                    if (configuration == null) {
                        act = this.ERROR_ACTION;
                        break;
                    }
                    this.stateStackTop = configuration.stack_top;
                    configuration.retrieveStack(this.stateStack);
                    act = configuration.act;
                    curtok = configuration.curtok;
                    if (curtok == 0) {
                        current_kind = this.ERROR_SYMBOL;
                        this.tokStream.reset(start_token);
                        continue;
                    }
                    current_kind = this.tokStream.getKind(curtok);
                    this.tokStream.reset(this.tokStream.getNext(curtok));
                    continue;
                }
                if (act <= this.ACCEPT_ACTION) break;
                if (configuration_stack.findConfiguration(this.stateStack, this.stateStackTop, curtok)) {
                    act = this.ERROR_ACTION;
                    continue;
                }
                configuration_stack.push(this.stateStack, this.stateStackTop, act + 1, curtok, 0);
                act = this.prs.baseAction(act);
                continue;
            }
            try {
                if (curtok > error_token && final_token == this.tokStream.getStreamLength() && this.recoverableState(act)) {
                    final_token = this.skipTokens ? curtok : this.tokStream.getNext(curtok);
                }
                this.stateStack[++this.stateStackTop] = act;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.reallocateStateStack();
                this.stateStack[this.stateStackTop] = act;
            }
            act = this.tAction(act, current_kind);
        }
        return act == this.ACCEPT_ACTION;
    }

    private boolean recoverableState(int state) {
        int k = this.prs.asi(state);
        while (this.prs.asr(k) != 0) {
            if (this.prs.asr(k) == this.ERROR_SYMBOL) {
                return true;
            }
            ++k;
        }
        return false;
    }

    private int findRecoveryStateIndex(int start_index) {
        int i = start_index;
        while (i >= 0) {
            if (this.recoverableState(this.stateStack[i])) break;
            --i;
        }
        if (i >= 0) {
            int k = i - 1;
            while (k >= 0) {
                if (this.locationStack[k] != this.locationStack[i]) break;
                --k;
            }
            i = k + 1;
        }
        return i;
    }

    private int errorRepair(int recovery_token, int error_token) {
        int[] temp_stack = new int[this.stateStackTop + 1];
        System.arraycopy(this.stateStack, 0, temp_stack, 0, temp_stack.length);
        while (this.tokStream.getKind(recovery_token) != this.EOFT_SYMBOL) {
            this.tokStream.reset(recovery_token);
            if (this.repairable(error_token)) break;
            this.stateStackTop = temp_stack.length - 1;
            System.arraycopy(temp_stack, 0, this.stateStack, 0, temp_stack.length);
            recovery_token = this.tokStream.getNext(recovery_token);
        }
        if (this.tokStream.getKind(recovery_token) == this.EOFT_SYMBOL) {
            this.tokStream.reset(recovery_token);
            if (!this.repairable(error_token)) {
                this.stateStackTop = temp_stack.length - 1;
                System.arraycopy(temp_stack, 0, this.stateStack, 0, temp_stack.length);
                return 0;
            }
        }
        this.stateStackTop = temp_stack.length - 1;
        System.arraycopy(temp_stack, 0, this.stateStack, 0, temp_stack.length);
        this.tokStream.reset(recovery_token);
        this.tokens.reset(this.locationStack[this.stateStackTop] - 1);
        this.action.reset(this.actionStack[this.stateStackTop]);
        return this.tokStream.makeErrorToken(this.tokens.get(this.locationStack[this.stateStackTop] - 1), this.tokStream.getPrevious(recovery_token), error_token, this.ERROR_SYMBOL);
    }

    private int tAction(int act, int sym) {
        if ((act = this.prs.tAction(act, sym)) > this.LA_STATE_OFFSET) {
            int next_token = this.tokStream.peek();
            act = this.prs.lookAhead(act - this.LA_STATE_OFFSET, this.tokStream.getKind(next_token));
            while (act > this.LA_STATE_OFFSET) {
                next_token = this.tokStream.getNext(next_token);
                act = this.prs.lookAhead(act - this.LA_STATE_OFFSET, this.tokStream.getKind(next_token));
            }
        }
        return act;
    }
}

