/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.environment.generichost.core;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.remotetools.RemotetoolsPlugin;
import org.eclipse.ptp.remotetools.environment.control.ITargetControl;
import org.eclipse.ptp.remotetools.environment.control.SSHTargetControl;
import org.eclipse.ptp.remotetools.environment.core.ITargetElement;
import org.eclipse.ptp.remotetools.environment.extension.ITargetVariables;
import org.eclipse.ptp.remotetools.environment.generichost.Activator;
import org.eclipse.ptp.remotetools.environment.generichost.core.ConfigFactory;
import org.eclipse.ptp.remotetools.environment.generichost.core.Messages;
import org.eclipse.ptp.remotetools.environment.generichost.core.TargetConfig;

public class TargetControl
extends SSHTargetControl
implements ITargetControl,
ITargetVariables {
    ConfigFactory configFactory;
    TargetConfig currentTargetConfig;
    ITargetElement targetElement;
    private int state = 1;
    private static final int NOT_OPERATIONAL = 1;
    private static final int CONNECTING = 2;
    private static final int CONNECTED = 3;
    private static final int DISCONNECTING = 4;
    public static final String DEFAULT_CIPHER = RemotetoolsPlugin.CIPHER_DEFAULT;

    public TargetControl(ITargetElement element) throws CoreException {
        this.targetElement = element;
        this.configFactory = new ConfigFactory(this.targetElement.getAttributes());
        this.currentTargetConfig = this.configFactory.createTargetConfig();
    }

    public boolean create(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(Messages.TargetControl_create_MonitorConnecting, 1);
        if (this.currentTargetConfig.isPasswordAuth()) {
            this.setConnectionParameters(new SSHTargetControl.SSHParameters((SSHTargetControl)this, this.currentTargetConfig.getConnectionAddress(), this.currentTargetConfig.getConnectionPort(), this.currentTargetConfig.getLoginUserName(), this.currentTargetConfig.getLoginPassword(), this.currentTargetConfig.getCipherType(), this.currentTargetConfig.getConnectionTimeout() * 1000));
        } else {
            this.setConnectionParameters(new SSHTargetControl.SSHParameters((SSHTargetControl)this, this.currentTargetConfig.getConnectionAddress(), this.currentTargetConfig.getConnectionPort(), this.currentTargetConfig.getLoginUserName(), this.currentTargetConfig.getKeyPath(), this.currentTargetConfig.getKeyPassphrase(), this.currentTargetConfig.getCipherType(), this.currentTargetConfig.getConnectionTimeout() * 1000));
        }
        try {
            this.setState(2);
            super.create(monitor);
            this.setState(3);
            monitor.worked(1);
        }
        catch (CoreException coreException) {
            this.disconnect();
            this.setState(1);
        }
        monitor.done();
        return true;
    }

    private synchronized void setState(int state) {
        this.state = state;
    }

    public boolean kill(IProgressMonitor monitor) throws CoreException {
        try {
            this.setState(4);
            super.kill(monitor);
        }
        finally {
            this.setState(1);
        }
        return true;
    }

    public synchronized int query() {
        switch (this.state) {
            case 1: {
                return 1;
            }
            case 2: 
            case 4: {
                return 0;
            }
            case 3: {
                if (this.isConnected()) {
                    return 2;
                }
                return 0;
            }
        }
        return 1;
    }

    public boolean resume(IProgressMonitor monitor) throws CoreException {
        throw new CoreException((IStatus)new Status(4, this.getPluginId(), 0, Messages.TargetControl_resume_CannotResume, null));
    }

    public boolean stop(IProgressMonitor monitor) throws CoreException {
        throw new CoreException((IStatus)new Status(4, this.getPluginId(), 0, Messages.TargetControl_stop_CannotPause, null));
    }

    public void updateConfiguration() throws CoreException {
        this.configFactory = new ConfigFactory(this.targetElement.getAttributes());
        this.currentTargetConfig = this.configFactory.createTargetConfig();
    }

    public String getName() {
        return this.targetElement.getName();
    }

    protected String getPluginId() {
        return Activator.getDefault().getBundle().getSymbolicName();
    }

    public ITargetControl.TargetSocket createTargetSocket(int port) {
        Assert.isTrue((boolean)this.isConnected());
        ITargetControl.TargetSocket socket = new ITargetControl.TargetSocket();
        socket.host = this.currentTargetConfig.getConnectionAddress();
        socket.port = port;
        return socket;
    }

    public String getSystemWorkspace() {
        return this.currentTargetConfig.getSystemWorkspace();
    }

    public void destroy() throws CoreException {
        try {
            this.terminateJobs(null);
        }
        finally {
            this.disconnect();
        }
    }
}

