/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.contentassist;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.internal.ui.text.contentassist.CContentAssistInvocationContext;
import org.eclipse.cdt.ui.text.contentassist.ContentAssistInvocationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ptp.internal.rdt.core.RemoteIndexerInfoProviderFactory;
import org.eclipse.ptp.internal.rdt.core.RemoteScannerInfo;
import org.eclipse.ptp.internal.rdt.core.contentassist.Proposal;
import org.eclipse.ptp.internal.rdt.core.contentassist.RemoteContentAssistInvocationContext;
import org.eclipse.ptp.internal.rdt.core.model.ModelAdapter;
import org.eclipse.ptp.internal.rdt.core.model.Scope;
import org.eclipse.ptp.internal.rdt.core.model.TranslationUnit;
import org.eclipse.ptp.internal.rdt.core.model.WorkingCopy;
import org.eclipse.ptp.internal.rdt.core.serviceproviders.AbstractRemoteService;
import org.eclipse.ptp.internal.rdt.core.subsystems.ICIndexSubsystem;
import org.eclipse.ptp.internal.rdt.ui.contentassist.ContentAssistUtil;
import org.eclipse.ptp.internal.rdt.ui.contentassist.IContentAssistService;
import org.eclipse.ptp.rdt.core.RDTLog;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.IConnectorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteContentAssistService
extends AbstractRemoteService
implements IContentAssistService {
    public RemoteContentAssistService(IHost host, IConnectorService connectorService) {
        super(host, connectorService);
    }

    @Override
    public List<Proposal> computeCompletionProposals(Scope scope, ContentAssistInvocationContext context, ITranslationUnit unit) {
        ITranslationUnit targetUnit;
        if (!(context instanceof CContentAssistInvocationContext)) {
            return Collections.emptyList();
        }
        CContentAssistInvocationContext cContext = (CContentAssistInvocationContext)context;
        if (cContext.getEditor().isDirty()) {
            String contents = cContext.getDocument().get();
            targetUnit = new WorkingCopy(null, unit, contents);
        } else {
            try {
                targetUnit = (ITranslationUnit)ModelAdapter.adaptElement(null, (ICElement)unit, (int)0, (boolean)true);
            }
            catch (CModelException e) {
                RDTLog.logError((Throwable)e);
                return Collections.emptyList();
            }
        }
        RemoteContentAssistInvocationContext remoteContext = ContentAssistUtil.adaptContext(cContext);
        ICIndexSubsystem subsystem = this.getSubSystem();
        IProject project = unit.getCProject().getProject();
        NullProgressMonitor monitor = new NullProgressMonitor();
        subsystem.checkProject(project, (IProgressMonitor)monitor);
        if (targetUnit instanceof TranslationUnit) {
            RemoteScannerInfo scannerInfo = RemoteIndexerInfoProviderFactory.getScannerInfo((IResource)unit.getResource());
            Map langaugeProperties = null;
            try {
                String languageId = unit.getLanguage().getId();
                langaugeProperties = RemoteIndexerInfoProviderFactory.getLanguageProperties((String)languageId, (IProject)project);
            }
            catch (Exception e) {
                RDTLog.logError((Throwable)e);
            }
            ((TranslationUnit)targetUnit).setASTContext((IScannerInfo)scannerInfo, langaugeProperties);
        }
        return subsystem.computeCompletionProposals(scope, remoteContext, targetUnit);
    }
}

