/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.scannerinfo;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ptp.internal.rdt.ui.scannerinfo.Messages;
import org.eclipse.ptp.internal.rdt.ui.wizards.settings.ProjectSettingsExportWizard;
import org.eclipse.ptp.internal.rdt.ui.wizards.settings.ProjectSettingsImportWizard;
import org.eclipse.ptp.internal.rdt.ui.wizards.settings.ProjectSettingsWizard;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ImportExportWizardButtons {
    public static void createControls(final Composite parent, final IAdaptable selection) {
        final Image importIcon = new Image((Device)parent.getDisplay(), ImportExportWizardButtons.class.getResourceAsStream("/icons/etool16/importc_settings.gif"));
        final Image exportIcon = new Image((Device)parent.getDisplay(), ImportExportWizardButtons.class.getResourceAsStream("/icons/etool16/exportc_settings.gif"));
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent _) {
                importIcon.dispose();
                exportIcon.dispose();
            }
        });
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        comp.setLayout((Layout)layout);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        comp.setLayoutData((Object)data);
        Button importButton = new Button(comp, 0);
        importButton.setText(Messages.RemoteIncludeTab_import);
        importButton.setImage(importIcon);
        importButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean finishedPressed = ImportExportWizardButtons.launchWizard(parent.getShell(), selection, false);
                if (finishedPressed) {
                    parent.getShell().close();
                }
            }
        });
        Button exportButton = new Button(comp, 0);
        exportButton.setText(Messages.RemoteIncludeTab_export);
        exportButton.setImage(exportIcon);
        exportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportExportWizardButtons.launchWizard(parent.getShell(), selection, true);
            }
        });
    }

    private static boolean launchWizard(Shell shell, IAdaptable selection, boolean export) {
        ProjectSettingsWizard wizard = export ? new ProjectSettingsExportWizard() : new ProjectSettingsImportWizard();
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)selection));
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        dialog.create();
        dialog.open();
        return wizard.isFinishedPressed();
    }
}

