/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.search;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.utils.FileSystemUtilityManager;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ptp.internal.rdt.core.RemoteScannerInfo;
import org.eclipse.ptp.internal.rdt.core.model.ModelAdapter;
import org.eclipse.ptp.internal.rdt.core.model.Scope;
import org.eclipse.ptp.internal.rdt.core.model.TranslationUnit;
import org.eclipse.ptp.internal.rdt.core.search.RemoteSearchElementQuery;
import org.eclipse.ptp.internal.rdt.core.search.RemoteSearchPatternQuery;
import org.eclipse.ptp.internal.rdt.core.search.RemoteSearchTextSelectionQuery;
import org.eclipse.ptp.internal.rdt.core.serviceproviders.AbstractRemoteService;
import org.eclipse.ptp.internal.rdt.ui.search.ISearchService;
import org.eclipse.ptp.internal.rdt.ui.search.RemoteSearchElementQueryAdapter;
import org.eclipse.ptp.internal.rdt.ui.search.RemoteSearchPatternQueryAdapter;
import org.eclipse.ptp.internal.rdt.ui.search.actions.RemoteSearchTextSelectionQueryAdapter;
import org.eclipse.ptp.rdt.core.RDTLog;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.search.ui.ISearchQuery;

public class RemoteSearchService
extends AbstractRemoteService
implements ISearchService {
    public RemoteSearchService(IHost host, IConnectorService connectorService) {
        super(host, connectorService);
    }

    public ISearchQuery createSearchPatternQuery(Scope indexScope, ICElement[] searchScope, String scopeDescription, String patternStr, boolean isCaseSensitive, int searchFlags) {
        RemoteSearchPatternQuery query = new RemoteSearchPatternQuery(this.convertScope(searchScope), scopeDescription, patternStr, isCaseSensitive, searchFlags);
        return new RemoteSearchPatternQueryAdapter(this.getSubSystem(), indexScope, query);
    }

    private ICElement[] convertScope(ICElement[] searchScope) {
        if (searchScope == null) {
            return null;
        }
        ICElement[] result = new ICElement[searchScope.length];
        int i = 0;
        while (i < searchScope.length) {
            try {
                result[i] = ModelAdapter.adaptElement(null, (ICElement)searchScope[i], (int)0, (boolean)false);
            }
            catch (CModelException e) {
                RDTLog.logError((Throwable)e);
            }
            ++i;
        }
        return result;
    }

    private ISourceReference adaptReference(ISourceReference object) {
        if (object instanceof ICElement) {
            try {
                ICElement element = ModelAdapter.adaptElement(null, (ICElement)((ICElement)object), (int)0, (boolean)true);
                if (element instanceof ISourceReference) {
                    return (ISourceReference)element;
                }
            }
            catch (CModelException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return null;
    }

    public ISearchQuery createSearchElementQuery(Scope indexScope, ICElement[] searchScope, ISourceReference object, int limitTo) {
        String path = FileSystemUtilityManager.getDefault().getPathFromURI(object.getTranslationUnit().getLocationURI());
        RemoteSearchElementQuery query = new RemoteSearchElementQuery(this.convertScope(searchScope), this.adaptReference(object), path, limitTo);
        return new RemoteSearchElementQueryAdapter(this.getSubSystem(), indexScope, query);
    }

    public ISearchQuery createSearchTextSelectionQuery(Scope indexScope, ICElement[] searchScope, ITranslationUnit element, ITextSelection selNode, int limitTo) {
        try {
            ITranslationUnit unit = (ITranslationUnit)ModelAdapter.adaptElement(null, (ICElement)element, (int)0, (boolean)false);
            if (unit instanceof TranslationUnit) {
                TranslationUnit tu = (TranslationUnit)unit;
                tu.setASTContext((IScannerInfo)new RemoteScannerInfo(), null);
            }
            RemoteSearchTextSelectionQuery query = new RemoteSearchTextSelectionQuery(this.convertScope(searchScope), unit, selNode.getText(), selNode.getOffset(), selNode.getLength(), limitTo);
            return new RemoteSearchTextSelectionQueryAdapter(this.getSubSystem(), indexScope, query);
        }
        catch (CModelException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

