/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.typehierarchy;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.typehierarchy.TypeHierarchyUI;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ptp.internal.rdt.core.typehierarchy.ITypeHierarchyService;
import org.eclipse.ptp.internal.rdt.ui.typehierarchy.RemoteTHViewPart;
import org.eclipse.ptp.internal.rdt.ui.typehierarchy.TypeHierarchyUtil;
import org.eclipse.ptp.rdt.core.serviceproviders.IIndexServiceProvider;
import org.eclipse.ptp.rdt.services.core.IService;
import org.eclipse.ptp.rdt.services.core.IServiceConfiguration;
import org.eclipse.ptp.rdt.services.core.IServiceProvider;
import org.eclipse.ptp.rdt.services.core.ServiceModelManager;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;

public class THDropTargetListener
implements DropTargetListener {
    private ICElement fInput;
    private boolean fEnabled = true;
    private IWorkbenchWindow fWindow;

    public THDropTargetListener(RemoteTHViewPart view) {
        this.fWindow = view.getSite().getWorkbenchWindow();
    }

    public void setEnabled(boolean val) {
        this.fEnabled = val;
    }

    public void dragEnter(DropTargetEvent event) {
        this.fInput = null;
        this.checkOperation(event);
        if (event.detail != 0 && LocalSelectionTransfer.getTransfer().isSupportedType(event.currentDataType)) {
            this.fInput = this.checkLocalSelection();
            if (!TypeHierarchyUI.isValidInput((ICElement)this.fInput)) {
                event.detail = 0;
                this.fInput = null;
            }
        }
    }

    private ICElement checkLocalSelection() {
        ISelection sel = LocalSelectionTransfer.getTransfer().getSelection();
        if (sel instanceof IStructuredSelection) {
            for (Object element : (IStructuredSelection)sel) {
                ICElement adapter;
                if (element instanceof ICElement) {
                    return (ICElement)element;
                }
                if (!(element instanceof IAdaptable) || (adapter = (ICElement)((IAdaptable)element).getAdapter(ICElement.class)) == null) continue;
                return adapter;
            }
        }
        return null;
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dragOperationChanged(DropTargetEvent event) {
        this.checkOperation(event);
    }

    public void dragOver(DropTargetEvent event) {
    }

    public void drop(DropTargetEvent event) {
        if (this.fInput == null) {
            Display.getCurrent().beep();
        } else {
            IService indexingService;
            IProject project = this.fInput.getCProject().getProject();
            ServiceModelManager smm = ServiceModelManager.getInstance();
            IServiceConfiguration serviceConfig = smm.getActiveConfiguration(project);
            IServiceProvider serviceProvider = serviceConfig.getServiceProvider(indexingService = smm.getService("org.eclipse.ptp.rdt.core.CIndexingService"));
            if (serviceProvider instanceof IIndexServiceProvider) {
                ITypeHierarchyService service = ((IIndexServiceProvider)serviceProvider).getTypeHierarchyService();
                TypeHierarchyUtil.open(service, this.fInput, this.fWindow);
            }
        }
    }

    public void dropAccept(DropTargetEvent event) {
    }

    private void checkOperation(DropTargetEvent event) {
        event.detail = this.fEnabled && (event.operations & 1) != 0 ? 1 : 0;
    }
}

