/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.ui.serviceproviders;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ptp.rdt.services.core.IServiceConfiguration;
import org.eclipse.ptp.rdt.services.core.ServiceModelManager;
import org.eclipse.ptp.rdt.services.ui.NewServiceModelWidget;
import org.eclipse.ptp.rdt.ui.UIPlugin;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;

public class ServiceModelPropertyPage
extends PropertyPage {
    private NewServiceModelWidget fModelWidget;

    protected Control createContents(Composite parent) {
        this.fModelWidget = new NewServiceModelWidget(parent, 0);
        IProject project = this.getProject();
        IServiceConfiguration config = ServiceModelManager.getInstance().getActiveConfiguration(project);
        Set natures = Collections.emptySet();
        try {
            natures = new HashSet<String>(Arrays.asList(project.getDescription().getNatureIds()));
        }
        catch (CoreException e) {
            UIPlugin.log(e);
        }
        this.fModelWidget.setServiceConfiguration(config, natures);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fModelWidget, "org.eclipse.ptp.rdt.ui.service_model_properties_context");
        return this.fModelWidget;
    }

    private IProject getProject() {
        IAdaptable element = this.getElement();
        if (element instanceof IProject) {
            return (IProject)element;
        }
        return ((ICProject)element).getProject();
    }

    public boolean performOk() {
        this.fModelWidget.applyChangesToConfiguration();
        try {
            ServiceModelManager.getInstance().saveModelConfiguration();
        }
        catch (IOException e) {
            UIPlugin.log(e);
        }
        return true;
    }
}

