/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.ui.wizards;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ptp.rdt.services.core.IServiceProvider;
import org.eclipse.ptp.rdt.ui.messages.Messages;
import org.eclipse.ptp.rdt.ui.serviceproviders.RemoteCIndexServiceProvider;
import org.eclipse.ptp.rdt.ui.wizards.IFilePathChangeListener;
import org.eclipse.ptp.rdt.ui.wizards.IndexFileLocationWidget;
import org.eclipse.rse.connectorservice.dstore.DStoreConnectorService;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.SystemStartHere;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.ui.wizards.newconnection.RSEDefaultNewConnectionWizard;
import org.eclipse.rse.ui.wizards.newconnection.RSEMainNewConnectionWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class HostSelectionDialog
extends Dialog {
    private RemoteCIndexServiceProvider fProvider;
    private Map<Integer, IHost> fHostComboIndexToHostMap = new HashMap<Integer, IHost>();
    private IHost fSelectedHost;
    private String configPath;

    public HostSelectionDialog(IServiceProvider provider, Shell parentShell) {
        super(parentShell);
        if (!(provider instanceof RemoteCIndexServiceProvider)) {
            throw new IllegalArgumentException();
        }
        this.fProvider = (RemoteCIndexServiceProvider)provider;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        this.getShell().setText(Messages.getString("HostSelectionDialog.1"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        container.setLayout((Layout)layout);
        Label hostLabel = new Label(container, 16384);
        hostLabel.setText(Messages.getString("HostSelectionDialog_0"));
        final Combo hostCombo = new Combo(container, 12);
        hostCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        IHost hostSelected = this.fProvider.getHost();
        IHost[] hosts = SystemStartHere.getConnections();
        int toSelect = 0;
        int k = 0;
        while (k < hosts.length) {
            hostCombo.add(hosts[k].getAliasName(), k);
            this.fHostComboIndexToHostMap.put(k, hosts[k]);
            if (hostSelected != null && hostSelected.getAliasName().compareTo(hosts[k].getAliasName()) == 0) {
                toSelect = k;
            }
            ++k;
        }
        hostCombo.select(toSelect);
        this.fSelectedHost = this.fHostComboIndexToHostMap.get(toSelect);
        Button newConnectionButton = new Button(container, 8);
        newConnectionButton.setText(Messages.getString("HostSelectionDialog.0"));
        newConnectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RSEMainNewConnectionWizard wizard = new RSEMainNewConnectionWizard();
                WizardDialog wizardDialog = new WizardDialog(HostSelectionDialog.this.getShell(), (IWizard)wizard);
                wizardDialog.open();
                IWizard actualWizard = wizard.getSelectedWizard();
                if (actualWizard instanceof RSEDefaultNewConnectionWizard) {
                    IHost host = ((RSEDefaultNewConnectionWizard)actualWizard).getCreatedHost();
                    int index = hostCombo.getItemCount() - 1;
                    hostCombo.add(host.getAliasName(), index);
                    HostSelectionDialog.this.fHostComboIndexToHostMap.put(index, host);
                    hostCombo.select(index);
                    HostSelectionDialog.this.fSelectedHost = host;
                }
            }
        });
        this.configPath = this.fProvider.getIndexLocation();
        if (this.fProvider.isConfigured() && this.configPath == null) {
            this.configPath = "";
        }
        final IndexFileLocationWidget scopeWidget = new IndexFileLocationWidget(container, 0, this.fSelectedHost, this.configPath);
        GridData data = new GridData(4, 4, true, false);
        data.horizontalSpan = 3;
        scopeWidget.setLayoutData(data);
        scopeWidget.addPathListener(new IFilePathChangeListener(){

            public void pathChanged(String newPath) {
                HostSelectionDialog.this.configPath = newPath;
            }
        });
        hostCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = hostCombo.getSelectionIndex();
                HostSelectionDialog.this.fSelectedHost = (IHost)HostSelectionDialog.this.fHostComboIndexToHostMap.get(selectionIndex);
                scopeWidget.setHost(HostSelectionDialog.this.fSelectedHost);
            }
        });
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(500, 300);
    }

    protected void okPressed() {
        super.okPressed();
        this.fProvider.setConnection(this.fSelectedHost, this.getDStoreConnectorService(this.fSelectedHost));
        this.fProvider.setIndexLocation(this.configPath);
        this.fProvider.setConfigured(true);
    }

    private IConnectorService getDStoreConnectorService(IHost host) {
        IConnectorService[] connectorServices = host.getConnectorServices();
        int k = 0;
        while (k < connectorServices.length) {
            if (connectorServices[k] instanceof DStoreConnectorService) {
                return connectorServices[k];
            }
            ++k;
        }
        return null;
    }
}

