/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.ui.wizards;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.ptp.internal.rdt.ui.RSEUtils;
import org.eclipse.ptp.rdt.ui.messages.Messages;
import org.eclipse.ptp.rdt.ui.wizards.IFilePathChangeListener;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.files.ui.dialogs.SystemRemoteFolderDialog;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class IndexFileLocationWidget
extends Composite {
    private final Text text;
    private final Button browseButton;
    private final Button defaultButton;
    private IHost host;
    private ListenerList pathListeners = new ListenerList();
    private Map<String, String> previousSelections = new HashMap<String, String>();

    public IndexFileLocationWidget(Composite parent, int style, IHost initialHost, String defaultPath) {
        super(parent, style);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(1808));
        Group group = new Group((Composite)this, 0);
        group.setText(Messages.getString("IndexFileLocationWidget.0"));
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(1808));
        this.text = new Text((Composite)group, 2048);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        this.text.setLayoutData((Object)data);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String path = IndexFileLocationWidget.this.text.getText();
                IndexFileLocationWidget.this.previousSelections.put(IndexFileLocationWidget.key(IndexFileLocationWidget.this.host), path);
                Object[] objectArray = IndexFileLocationWidget.this.pathListeners.getListeners();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object listener = objectArray[n2];
                    ((IFilePathChangeListener)listener).pathChanged(path);
                    ++n2;
                }
            }
        });
        this.browseButton = new Button((Composite)group, 0);
        this.browseButton.setText(Messages.getString("IndexFileLocationWidget.1"));
        this.browseButton.setLayoutData((Object)new GridData(768));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IndexFileLocationWidget.this.browse();
            }
        });
        this.defaultButton = new Button((Composite)group, 0);
        this.defaultButton.setText(Messages.getString("IndexFileLocationWidget.2"));
        this.defaultButton.setLayoutData((Object)new GridData(768));
        this.defaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IndexFileLocationWidget.this.restoreDefault();
            }
        });
        this.setHost(initialHost);
        if (defaultPath != null) {
            this.text.setText(defaultPath);
        }
    }

    public IHost getHost() {
        return this.host;
    }

    public void setHost(IHost host) {
        if (host == null) {
            throw new NullPointerException();
        }
        this.host = host;
        String path = this.previousSelections.get(IndexFileLocationWidget.key(host));
        if (path == null) {
            path = RSEUtils.getDefaultConfigDirectory(host);
        }
        if (path == null) {
            path = "";
        }
        this.text.setText(path);
    }

    private static String key(IHost host) {
        return String.valueOf(host.getSystemProfileName()) + "." + host.getAliasName();
    }

    public String getConfigLocationPath() {
        return this.text.getText();
    }

    public void addPathListener(IFilePathChangeListener listener) {
        this.pathListeners.add((Object)listener);
    }

    public void removePathListener(IFilePathChangeListener listener) {
        this.pathListeners.remove((Object)listener);
    }

    private void browse() {
        SystemRemoteFolderDialog folderDialog = new SystemRemoteFolderDialog(this.getShell(), this.host.getAliasName());
        folderDialog.setDefaultSystemConnection(this.host, true);
        folderDialog.open();
        Object remoteObject = folderDialog.getSelectedObject();
        if (remoteObject instanceof IRemoteFile) {
            IRemoteFile folder = (IRemoteFile)remoteObject;
            this.text.setText(folder.getCanonicalPath());
        }
    }

    private void restoreDefault() {
        this.text.setText(RSEUtils.getDefaultConfigDirectory(this.host));
    }
}

