/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.callhierarchy;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.utils.FileSystemUtilityManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ptp.internal.rdt.core.CModelUtil;
import org.eclipse.ptp.internal.rdt.core.callhierarchy.AbstractCallHierarchyService;
import org.eclipse.ptp.internal.rdt.core.callhierarchy.CalledByResult;
import org.eclipse.ptp.internal.rdt.core.callhierarchy.CallsToResult;
import org.eclipse.ptp.internal.rdt.core.index.IndexQueries;
import org.eclipse.ptp.internal.rdt.core.model.ICProjectFactory;
import org.eclipse.ptp.internal.rdt.core.model.LocalCProjectFactory;
import org.eclipse.ptp.internal.rdt.core.model.Scope;

public class LocalCallHierarchyService
extends AbstractCallHierarchyService {
    private static final ICElement[] NO_ELEMENTS = new ICElement[0];

    public CalledByResult findCalledBy(Scope scope, ICElement callee, IProgressMonitor pm) throws CoreException, InterruptedException {
        CalledByResult result = new CalledByResult();
        if (!(callee instanceof ISourceReference)) {
            return result;
        }
        ICProject[] projects = CoreModel.getDefault().getCModel().getCProjects();
        IIndex index = CCorePlugin.getIndexManager().getIndex(projects);
        index.acquireReadLock();
        try {
            String path = FileSystemUtilityManager.getDefault().getPathFromURI(callee.getLocationURI());
            IIndexBinding calleeBinding = IndexQueries.elementToBinding(index, callee, path);
            this.findCalledBy(index, (IBinding)calleeBinding, callee.getCProject(), result);
            CalledByResult calledByResult = result;
            return calledByResult;
        }
        finally {
            index.releaseReadLock();
        }
    }

    private void findCalledBy(IIndex index, IBinding callee, ICProject project, CalledByResult result) throws CoreException {
        if (callee != null) {
            IIndexName[] names = index.findReferences(callee);
            int i = 0;
            while (i < names.length) {
                ICElement elem;
                IIndexName rname = names[i];
                IIndexName caller = rname.getEnclosingDefinition();
                if (caller != null && (elem = IndexQueries.getCElementForName(project, index, caller, null, (ICProjectFactory)new LocalCProjectFactory())) != null) {
                    result.add(elem, rname);
                }
                ++i;
            }
        }
    }

    public CallsToResult findCalls(Scope scope, ICElement caller, IProgressMonitor pm) throws CoreException, InterruptedException {
        ICProject[] projects = CoreModel.getDefault().getCModel().getCProjects();
        IIndex index = CCorePlugin.getIndexManager().getIndex(projects);
        index.acquireReadLock();
        try {
            CallsToResult callsToResult = this.findCalls(caller, index, pm);
            return callsToResult;
        }
        finally {
            index.releaseReadLock();
        }
    }

    private CallsToResult findCalls(ICElement caller, IIndex index, IProgressMonitor pm) throws CoreException {
        CallsToResult result = new CallsToResult();
        IIndexName callerName = IndexQueries.elementToName(index, caller);
        if (callerName != null) {
            IIndexName[] refs = callerName.getEnclosedNames();
            int i = 0;
            while (i < refs.length) {
                ICElement[] defs;
                IIndexName name = refs[i];
                IIndexBinding binding = index.findBinding((IName)name);
                if (this.isRelevantForCallHierarchy((IBinding)binding) && (defs = IndexQueries.findRepresentative(index, (IBinding)binding, null, null, new LocalCProjectFactory())) != null && defs.length > 0) {
                    result.add(defs, name);
                }
                ++i;
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICElement[] findDefinitions(Scope scope, ICElement input, IProgressMonitor pm) {
        try {
            ITranslationUnit tu = CModelUtil.getTranslationUnit(input);
            if (tu == null) return new ICElement[]{input};
            ICProject project = tu.getCProject();
            IIndex index = CCorePlugin.getIndexManager().getIndex(project, 3);
            index.acquireReadLock();
            try {
                ICElement[] result;
                String path;
                IIndexBinding binding;
                LocalCProjectFactory projectFactory = new LocalCProjectFactory();
                if (LocalCallHierarchyService.needToFindDefinition(input) && (binding = IndexQueries.elementToBinding(index, input, path = FileSystemUtilityManager.getDefault().getPathFromURI(input.getLocationURI()))) != null && (result = IndexQueries.findAllDefinitions(index, (IBinding)binding, null, project, projectFactory)).length > 0) {
                    ICElement[] iCElementArray = result;
                    return iCElementArray;
                }
                IIndexName name = IndexQueries.elementToName(index, input);
                if (name == null) return new ICElement[]{input};
                ICElement handle = IndexQueries.getCElementForName(tu, index, name, projectFactory);
                ICElement[] iCElementArray = new ICElement[]{handle};
                return iCElementArray;
            }
            finally {
                if (index != null) {
                    index.releaseReadLock();
                }
            }
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return new ICElement[]{input};
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        return new ICElement[]{input};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICElement[] findDefinitions(Scope scope, ICProject project, IWorkingCopy workingCopy, int selectionStart, int selectionLength, IProgressMonitor pm) throws CoreException {
        try {
            IIndex index = CCorePlugin.getIndexManager().getIndex(project, 3);
            index.acquireReadLock();
            try {
                IASTName name = IndexQueries.getSelectedName(index, (ITranslationUnit)workingCopy, selectionStart, selectionLength);
                if (name == null) return NO_ELEMENTS;
                IBinding binding = name.resolveBinding();
                if (!this.isRelevantForCallHierarchy(binding)) return NO_ELEMENTS;
                LocalCProjectFactory projectFactory = new LocalCProjectFactory();
                if (name.isDefinition()) {
                    ICElement elem = IndexQueries.getCElementForName(project, index, name, null, (ICProjectFactory)projectFactory);
                    if (elem == null) return NO_ELEMENTS;
                    ICElement[] iCElementArray = new ICElement[]{elem};
                    return iCElementArray;
                }
                ICElement[] elems = IndexQueries.findAllDefinitions(index, binding, null, project, projectFactory);
                if (elems.length == 0) {
                    ICElement elem = null;
                    elem = name.isDeclaration() ? IndexQueries.getCElementForName(project, index, name, null, (ICProjectFactory)projectFactory) : IndexQueries.findAnyDeclaration(index, project, binding, null, projectFactory);
                    if (elem != null) {
                        elems = new ICElement[]{elem};
                    }
                }
                ICElement[] iCElementArray = elems;
                return iCElementArray;
            }
            finally {
                if (index != null) {
                    index.releaseReadLock();
                }
            }
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return NO_ELEMENTS;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        return NO_ELEMENTS;
    }

    private static boolean needToFindDefinition(ICElement elem) {
        switch (elem.getElementType()) {
            case 71: 
            case 73: 
            case 88: 
            case 90: {
                return true;
            }
        }
        return false;
    }
}

