/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.index;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ptp.internal.rdt.core.RemoteIndexerInfoProvider;
import org.eclipse.ptp.internal.rdt.core.RemoteIndexerInfoProviderFactory;
import org.eclipse.ptp.internal.rdt.core.index.IIndexLifecycleService;
import org.eclipse.ptp.internal.rdt.core.index.RemoteIndexerTask;
import org.eclipse.ptp.internal.rdt.core.model.Scope;
import org.eclipse.ptp.internal.rdt.core.serviceproviders.AbstractRemoteService;
import org.eclipse.ptp.internal.rdt.core.subsystems.ICIndexSubsystem;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.IConnectorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteIndexLifecycleService
extends AbstractRemoteService
implements IIndexLifecycleService {
    private Map<String, Scope> fStringToScopeMap = new TreeMap<String, Scope>();

    public RemoteIndexLifecycleService(IHost host, IConnectorService connectorService) {
        super(host, connectorService);
    }

    @Override
    public Scope getScope(String name) {
        return this.fStringToScopeMap.get(name);
    }

    @Override
    public Set<Scope> getScopes() {
        TreeSet<Scope> set = new TreeSet<Scope>();
        set.addAll(this.fStringToScopeMap.values());
        return set;
    }

    @Override
    public void reindex(Scope scope, String indexLocation, List<ICElement> changedElements, IProgressMonitor monitor, RemoteIndexerTask task) {
        this.reindex(scope, indexLocation, monitor, task);
    }

    @Override
    public void update(Scope scope, List<ICElement> newElements, List<ICElement> changedElements, List<ICElement> deletedElements, IProgressMonitor monitor, RemoteIndexerTask task) {
        ArrayList<ICElement> elements = new ArrayList<ICElement>(newElements);
        elements.addAll(changedElements);
        RemoteIndexerInfoProvider provider = RemoteIndexerInfoProviderFactory.getProvider(elements);
        ICIndexSubsystem indexSubsystem = this.getSubSystem();
        indexSubsystem.indexDelta(scope, provider, newElements, changedElements, deletedElements, monitor, task);
    }

    @Override
    public void reindex(Scope scope, String indexLocation, IProgressMonitor monitor, RemoteIndexerTask task) {
        RemoteIndexerInfoProvider provider = RemoteIndexerInfoProviderFactory.getProvider(scope.getName());
        ICIndexSubsystem indexSubsystem = this.getSubSystem();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot workspaceRoot = workspace.getRoot();
        IProject project = workspaceRoot.getProject(scope.getName());
        if (project != null && project.isOpen()) {
            indexSubsystem.checkProject(project, (IProgressMonitor)new NullProgressMonitor());
        }
        indexSubsystem.reindexScope(scope, provider, indexLocation, monitor, task);
    }

    @Override
    public String moveIndexFile(String scopeName, String newIndexLocation, IProgressMonitor monitor) {
        ICIndexSubsystem indexSubsystem = this.getSubSystem();
        return indexSubsystem.moveIndexFile(scopeName, newIndexLocation, monitor);
    }
}

