/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.proxy.server;

import java.io.IOException;
import java.net.Socket;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.ptp.proxy.command.IProxyCommand;
import org.eclipse.ptp.proxy.command.IProxyCommandFactory;
import org.eclipse.ptp.proxy.command.IProxyCommandListener;
import org.eclipse.ptp.proxy.command.IProxyExtendedCommand;
import org.eclipse.ptp.proxy.command.IProxyQuitCommand;
import org.eclipse.ptp.proxy.packet.ProxyPacket;
import org.eclipse.ptp.proxy.server.IProxyServer;

public abstract class AbstractProxyServer
implements IProxyServer {
    public static final int MAX_ERRORS = 5;
    private ServerState state = ServerState.SHUTDOWN;
    private String sessHost;
    private int sessPort;
    private Socket sessSocket;
    private ReadableByteChannel sessInput;
    private IProxyCommandFactory proxyCommandFactory;
    private Thread commandThread;
    private List<IProxyCommandListener> listeners = Collections.synchronizedList(new ArrayList());

    public AbstractProxyServer(String host, int port, IProxyCommandFactory factory) {
        this.sessHost = host;
        this.sessPort = port;
        this.proxyCommandFactory = factory;
    }

    public void addListener(IProxyCommandListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IProxyCommandListener listener) {
        this.listeners.remove(listener);
    }

    public void connect() throws IOException {
        this.sessSocket = new Socket(this.sessHost, this.sessPort);
        this.sessInput = this.sessSocket.getChannel();
    }

    public void start() {
        this.commandThread = new Thread("Proxy Server Command Thread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ServerState serverState;
                boolean error = false;
                int errorCount = 0;
                System.out.println("server command thread starting...");
                try {
                    while (errorCount < 5 && !this.isInterrupted()) {
                        serverState = AbstractProxyServer.this.state;
                        synchronized (serverState) {
                            if (AbstractProxyServer.this.state == ServerState.SHUTDOWN) {
                                break;
                            }
                        }
                        if (AbstractProxyServer.this.sessionProgress()) continue;
                        ++errorCount;
                    }
                }
                catch (IOException e) {
                    ServerState serverState2 = AbstractProxyServer.this.state;
                    synchronized (serverState2) {
                        if (!this.isInterrupted() && AbstractProxyServer.this.state != ServerState.SHUTTING_DOWN) {
                            error = true;
                            System.out.println("event thread IOException . . . " + e.getMessage());
                        }
                    }
                }
                if (errorCount >= 5) {
                    error = true;
                }
                try {
                    AbstractProxyServer.this.sessSocket.close();
                }
                catch (IOException iOException) {}
                serverState = AbstractProxyServer.this.state;
                synchronized (serverState) {
                    AbstractProxyServer.this.state = ServerState.SHUTDOWN;
                }
                System.out.println("server thread exited");
                if (error) {
                    System.out.println(" due to errors");
                } else {
                    System.out.println(" normally");
                }
            }
        };
        try {
            this.commandThread.join();
        }
        catch (InterruptedException interruptedException) {}
    }

    private boolean sessionProgress() throws IOException {
        ProxyPacket packet = new ProxyPacket();
        if (!packet.read(this.sessInput)) {
            return false;
        }
        IProxyCommand cmd = this.proxyCommandFactory.toCommand(packet);
        if (cmd != null) {
            if (cmd instanceof IProxyQuitCommand) {
                this.fireProxyQuitCommand((IProxyQuitCommand)cmd);
            } else if (cmd instanceof IProxyExtendedCommand) {
                this.fireProxyExtendedCommand((IProxyExtendedCommand)cmd);
            }
            return true;
        }
        return false;
    }

    protected void fireProxyExtendedCommand(IProxyExtendedCommand cmd) {
        IProxyCommandListener[] la;
        IProxyCommandListener[] iProxyCommandListenerArray = la = this.listeners.toArray(new IProxyCommandListener[0]);
        int n = la.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyCommandListener listener = iProxyCommandListenerArray[n2];
            listener.handleCommand(cmd);
            ++n2;
        }
    }

    protected void fireProxyQuitCommand(IProxyQuitCommand cmd) {
        IProxyCommandListener[] la;
        IProxyCommandListener[] iProxyCommandListenerArray = la = this.listeners.toArray(new IProxyCommandListener[0]);
        int n = la.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyCommandListener listener = iProxyCommandListenerArray[n2];
            listener.handleCommand(cmd);
            ++n2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ServerState {
        WAITING,
        CONNECTED,
        RUNNING,
        SHUTTING_DOWN,
        SHUTDOWN;

    }
}

