/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.ui;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.internal.ui.PDebugUIUtils;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class PInstructionPointerAnnotation
extends MarkerAnnotation {
    private IAnnotationModel annotationModel = null;
    private BitList tasks = null;
    private Position position = null;
    private IMarker marker = null;

    public PInstructionPointerAnnotation(IMarker marker, Position position, IAnnotationModel annotationModel) {
        super(marker);
        this.marker = marker;
        this.position = position;
        this.annotationModel = annotationModel;
    }

    public IAnnotationModel getAnnotationModel() {
        return this.annotationModel;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    public Position getPosition() {
        return this.position;
    }

    public void setMarker(IMarker marker) {
        this.marker = marker;
    }

    public IMarker getMarker() {
        return this.marker;
    }

    public void setMessage(String message) {
        try {
            this.getMarker().setAttribute("message", (Object)message);
        }
        catch (CoreException coreException) {}
        this.setText(message);
    }

    public void setMessage(boolean isRegister) {
        int[] tasks = this.getTasks().toArray();
        if (tasks.length == 0) {
            this.setMessage("");
            this.deleteMarker();
            return;
        }
        String msg = "Suspended on " + (isRegister ? "registered" : "unregistered") + " " + (tasks.length == 1 ? "process" : "processes") + ": ";
        msg = String.valueOf(msg) + PDebugUIUtils.arrayToString(tasks);
        this.setMessage(msg);
    }

    public String getMessage() {
        return this.getText();
    }

    public void setTasks(BitList tasks) {
        this.tasks = tasks;
    }

    public BitList getTasks() {
        return this.tasks;
    }

    public void addTasks(BitList aTasks) {
        if (this.tasks == null) {
            this.tasks = aTasks.copy();
        }
        if (this.tasks.size() < aTasks.size()) {
            aTasks.or(this.tasks);
            this.tasks = aTasks.copy();
        } else {
            this.tasks.or(aTasks);
        }
    }

    public void removeTasks(BitList aTasks) {
        this.tasks.andNot(aTasks);
    }

    public boolean isEmpty() {
        return this.tasks.isEmpty();
    }

    public boolean contains(BitList aTasks) {
        return this.tasks.intersects(aTasks);
    }

    public int[] containTasks(BitList aTasks) {
        aTasks.and(this.tasks);
        return aTasks.toArray();
    }

    public boolean deleteMarker() {
        IMarker marker = this.getMarker();
        if (marker.exists()) {
            try {
                marker.delete();
            }
            catch (CoreException coreException) {
                return false;
            }
        }
        return true;
    }
}

