/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.managedbuilder.core;

import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.ptp.cell.managedbuilder.core.CellDefaultOptionValueHandler;
import org.eclipse.ptp.cell.managedbuilder.debug.Debug;

public class LibraryListValueHandler
extends CellDefaultOptionValueHandler {
    protected static final String COMMA = ",";
    protected static final String EMPTY_STRING = "";

    public boolean handleValue(IBuildObject configuration, IHoldsOptions holder, IOption option, String extraArgument, int event) {
        Debug.read();
        Debug.POLICY.enter(Debug.DEBUG_HANDLER, new Object[]{configuration.getId(), holder.getId(), option.getId(), extraArgument, event});
        if (event == 4) {
            try {
                Debug.POLICY.trace(Debug.DEBUG_HANDLER, "Value is: {0}", new Object[]{option.getValue()});
                String[] libraries = option.getLibraries();
                String[] especialLibrariesIds = extraArgument.split(COMMA);
                if (libraries.length > 0) {
                    int i = 0;
                    while (i < especialLibrariesIds.length) {
                        IOption especialLibraryOption = holder.getOptionBySuperClassId(especialLibrariesIds[i]);
                        String especialLibrary = especialLibraryOption.getCommand().replaceFirst(option.getCommand(), EMPTY_STRING);
                        boolean setTrue = false;
                        int j = 0;
                        while (j < libraries.length) {
                            if (especialLibrary.equals(libraries[j])) {
                                setTrue = true;
                            }
                            ++j;
                        }
                        if (especialLibraryOption.getBooleanValue() != setTrue) {
                            Debug.POLICY.trace(Debug.DEBUG_HANDLER, "Set special library {0} to {1}.", new Object[]{especialLibrary, setTrue});
                            this.setValue(configuration, holder, especialLibraryOption, setTrue);
                        } else {
                            Debug.POLICY.trace(Debug.DEBUG_HANDLER, "Keep special library {0} with {1}.", new Object[]{especialLibrary, especialLibraryOption.getBooleanValue()});
                        }
                        ++i;
                    }
                } else {
                    Debug.POLICY.trace(Debug.DEBUG_HANDLER, "No library set. Set all {0} special libraries to {1}.", new Object[]{especialLibrariesIds.length, false});
                    int i = 0;
                    while (i < especialLibrariesIds.length) {
                        IOption especialLibraryOption = holder.getOptionBySuperClassId(especialLibrariesIds[i]);
                        if (especialLibraryOption.getBooleanValue()) {
                            this.setValue(configuration, holder, especialLibraryOption, false);
                        }
                        ++i;
                    }
                }
            }
            catch (BuildException be) {
                Debug.POLICY.error(Debug.DEBUG_HANDLER, (Throwable)be);
                Debug.POLICY.logError((Throwable)be);
            }
            Debug.POLICY.exit(Debug.DEBUG_HANDLER, (Object)true);
            return true;
        }
        Debug.POLICY.exit(Debug.DEBUG_HANDLER, (Object)false);
        return false;
    }
}

