/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.managedbuilder.core;

import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ptp.cell.managedbuilder.core.CellDefaultOptionValueHandler;
import org.eclipse.ptp.cell.managedbuilder.core.Messages;
import org.eclipse.ptp.cell.managedbuilder.core.PDTBuildProperties;
import org.eclipse.ptp.cell.managedbuilder.debug.Debug;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class PDTEnablementValueHandler
extends CellDefaultOptionValueHandler {
    protected static final String LINKER = "linker";
    protected static final String COMPILER = "compiler";
    protected static final String PPU = "ppu";
    protected static final String SPU = "spu";
    protected static final String PPC32 = "32";
    protected static final String PPC64 = "64";
    protected final String COMMA = ",";
    protected final String EMPTY_STRING = "";

    public boolean handleValue(IBuildObject configuration, IHoldsOptions holder, IOption option, String extraArgument, int event) {
        Debug.read();
        Debug.POLICY.enter(Debug.DEBUG_HANDLER, new Object[]{configuration.getId(), holder.getId(), option.getId(), extraArgument, event});
        try {
            Assert.isLegal((option.getBasicValueType() == 0 ? 1 : 0) != 0, (String)"invalid option type");
            if (event == 4) {
                String[] affectedOptionIds = extraArgument.split(",");
                String optionId = option.getId();
                boolean optionTicked = option.getBooleanValue();
                if (optionId.contains(LINKER)) {
                    if (optionTicked) {
                        Debug.POLICY.trace(Debug.DEBUG_HANDLER, "PDT linker build option was selected");
                        if (optionId.contains(SPU)) {
                            MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.PDTBuildFlagsWarningDialogTitle, (String)Messages.PDTLinkerBuildFlagsWarningDialogMessage);
                        }
                    } else {
                        Debug.POLICY.trace(Debug.DEBUG_HANDLER, "PDT linker build option was deselected");
                    }
                    this.updateLinkerOptions(configuration, holder, optionId, affectedOptionIds, optionTicked);
                } else if (optionId.contains(COMPILER)) {
                    if (optionTicked) {
                        Debug.POLICY.trace(Debug.DEBUG_HANDLER, "PDT compiler build option was selected");
                        MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.PDTBuildFlagsWarningDialogTitle, (String)Messages.PDTCompilerBuildFlagsWarningDialogMessage);
                    } else {
                        Debug.POLICY.trace(Debug.DEBUG_HANDLER, "PDT compiler build option was deselected");
                    }
                    this.updateCompilerOptions(configuration, holder, optionId, affectedOptionIds, optionTicked);
                } else {
                    Assert.isTrue((boolean)false, (String)"Invalid option");
                }
            }
            return true;
        }
        catch (BuildException be) {
            Debug.POLICY.error(Debug.DEBUG_HANDLER, (Throwable)be);
            Debug.POLICY.logError((Throwable)be);
            Debug.POLICY.enter(Debug.DEBUG_HANDLER, new Object[]{false});
            return false;
        }
    }

    private void updateLinkerOptions(IBuildObject configuration, IHoldsOptions holder, String optionId, String[] affectedOptionIds, boolean optionTicked) {
        Assert.isLegal((affectedOptionIds.length == 1 || affectedOptionIds.length == 2 ? 1 : 0) != 0, (String)"PDT linker build options should always affect 1 or 2 other linker options.");
        try {
            this.setValue(configuration, holder, holder.getOptionBySuperClassId(affectedOptionIds[0]), optionTicked);
            if (optionId.contains(SPU)) {
                IOption affectedOption = holder.getOptionBySuperClassId(affectedOptionIds[1]);
                String libraryPath = PDTBuildProperties.SPU_PDT_LIBRARY;
                this.setValue(configuration, holder, affectedOption, affectedOption.getBasicStringListValue(), libraryPath, optionTicked);
            }
        }
        catch (BuildException be) {
            Debug.POLICY.error(Debug.DEBUG_HANDLER, (Throwable)be);
            Debug.POLICY.logError((Throwable)be);
        }
    }

    private void updateCompilerOptions(IBuildObject configuration, IHoldsOptions holder, String optionId, String[] affectedOptionIds, boolean optionTicked) {
        Assert.isLegal((affectedOptionIds.length == 1 || affectedOptionIds.length == 2 ? 1 : 0) != 0, (String)"PDT compiler build options should always affect 1 or 2 other compiler options.");
        try {
            if (optionId.contains(SPU)) {
                IOption affectedOption = holder.getOptionBySuperClassId(affectedOptionIds[0]);
                affectedOption = this.setValue(configuration, holder, affectedOption, affectedOption.getBasicStringListValue(), PDTBuildProperties.PDT_MAIN_SYMBOL, optionTicked);
                affectedOption = this.setValue(configuration, holder, affectedOption, affectedOption.getBasicStringListValue(), PDTBuildProperties.PDT_EXIT_SYMBOL, optionTicked);
                this.setValue(configuration, holder, affectedOption, affectedOption.getBasicStringListValue(), PDTBuildProperties.MFCIO_TRACE_SYMBOL, optionTicked);
                affectedOption = holder.getOptionBySuperClassId(affectedOptionIds[1]);
                String includePath = PDTBuildProperties.SPU_PDT_INCLUDE_PATH;
                if (optionTicked) {
                    affectedOption = this.setValue(configuration, holder, affectedOption, affectedOption.getBasicStringListValue(), includePath, false);
                }
                this.setValue(configuration, holder, affectedOption, affectedOption.getBasicStringListValue(), includePath, optionTicked);
            } else {
                Assert.isTrue((boolean)false, (String)"Invalid option");
            }
        }
        catch (BuildException be) {
            Debug.POLICY.error(Debug.DEBUG_HANDLER, (Throwable)be);
            Debug.POLICY.logError((Throwable)be);
        }
    }
}

