/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.rse.ui;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.rse.core.RSEConnectionManager;
import org.eclipse.ptp.remote.ui.IRemoteUIConnectionManager;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.ui.actions.SystemNewConnectionAction;
import org.eclipse.swt.widgets.Shell;

public class RSEUIConnectionManager
implements IRemoteUIConnectionManager {
    private SystemNewConnectionAction action;
    private RSEConnectionManager manager;

    public RSEUIConnectionManager(IRemoteServices services) {
        this.manager = (RSEConnectionManager)services.getConnectionManager();
    }

    public IRemoteConnection newConnection(Shell shell) {
        IRemoteConnection[] oldConns = this.manager.getConnections();
        if (this.action == null) {
            this.action = new SystemNewConnectionAction(shell, false, false, null);
            IRSESystemType systemType = RSECorePlugin.getTheCoreRegistry().getSystemTypeById("org.eclipse.rse.systemtype.ssh");
            if (systemType != null) {
                this.action.restrictSystemTypes(new IRSESystemType[]{systemType});
            }
        }
        try {
            this.action.run();
        }
        catch (Exception exception) {}
        this.manager.refreshConnections();
        IRemoteConnection[] newConns = this.manager.getConnections();
        if (newConns.length <= oldConns.length) {
            return null;
        }
        Arrays.sort(oldConns, new Comparator<IRemoteConnection>(){

            @Override
            public int compare(IRemoteConnection c1, IRemoteConnection c2) {
                return c1.getName().compareToIgnoreCase(c2.getName());
            }
        });
        Arrays.sort(newConns, new Comparator<IRemoteConnection>(){

            @Override
            public int compare(IRemoteConnection c1, IRemoteConnection c2) {
                return c1.getName().compareToIgnoreCase(c2.getName());
            }
        });
        int i = 0;
        while (i < oldConns.length) {
            if (!oldConns[i].equals(newConns[i])) {
                return newConns[i];
            }
            ++i;
        }
        return newConns[newConns.length - 1];
    }
}

