/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.rse.ui;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.rse.core.RSEConnection;
import org.eclipse.ptp.remote.ui.IRemoteUIFileManager;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.files.ui.dialogs.SystemRemoteFileDialog;
import org.eclipse.rse.files.ui.dialogs.SystemRemoteFolderDialog;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.swt.widgets.Shell;

public class RSEUIFileManager
implements IRemoteUIFileManager {
    private IRemoteConnectionManager connMgr;
    private IRemoteConnection connection = null;
    private IHost connHost = null;

    public RSEUIFileManager(IRemoteServices services) {
        this.connMgr = services.getConnectionManager();
    }

    public IPath browseDirectory(Shell shell, String message, String filterPath) {
        SystemRemoteFolderDialog dlg = new SystemRemoteFolderDialog(shell, message, this.connHost);
        dlg.setBlockOnOpen(true);
        if (dlg.open() == 0) {
            this.connHost = dlg.getSelectedConnection();
            this.connection = this.connMgr.getConnection(this.connHost.getName());
            Object retObj = dlg.getSelectedObject();
            if (retObj instanceof IRemoteFile) {
                IRemoteFile selectedFile = (IRemoteFile)retObj;
                return new Path(selectedFile.getAbsolutePath());
            }
        }
        return null;
    }

    public IPath browseFile(Shell shell, String message, String filterPath) {
        SystemRemoteFileDialog dlg = new SystemRemoteFileDialog(shell, message, this.connHost);
        dlg.setBlockOnOpen(true);
        if (dlg.open() == 0) {
            this.connHost = dlg.getSelectedConnection();
            this.connection = this.connMgr.getConnection(this.connHost.getName());
            Object retObj = dlg.getSelectedObject();
            if (retObj instanceof IRemoteFile) {
                IRemoteFile selectedFile = (IRemoteFile)retObj;
                return new Path(selectedFile.getAbsolutePath());
            }
        }
        return null;
    }

    public IRemoteConnection getConnection() {
        return this.connection;
    }

    public void setConnection(IRemoteConnection connection) {
        this.connection = connection;
        this.connHost = ((RSEConnection)connection).getHost();
    }

    public void showConnections(boolean enable) {
    }
}

