/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.utils.linux.which;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.eclipse.ptp.cell.utils.debug.Debug;
import org.eclipse.ptp.cell.utils.linux.which.Messages;
import org.eclipse.ptp.cell.utils.process.ProcessController;

public class Which {
    protected static final String PROCESS_NAME = "which";
    protected static final String WHICH = "which";
    protected static final long TIMEOUT = 100L;
    protected static final String WHITESPACE = " ";
    public static final String EMPTY_PATH = "";

    public static String which(String fileName) {
        Debug.read();
        Debug.POLICY.enter(Debug.DEBUG_LINUX, new Object[]{fileName});
        String outputLine = EMPTY_PATH;
        String command = "which " + fileName;
        try {
            Debug.POLICY.trace(Debug.DEBUG_LINUX, command);
            Process process = Runtime.getRuntime().exec(command);
            ProcessController processController = new ProcessController("which", process, 100L);
            processController.start();
            BufferedReader processOutput = new BufferedReader(new InputStreamReader(process.getInputStream()));
            outputLine = processOutput.readLine();
            Debug.POLICY.trace(Debug.DEBUG_LINUX_MORE, outputLine);
            processController.interrupt();
        }
        catch (IOException ioe) {
            Debug.POLICY.error(Debug.DEBUG_LINUX, ioe);
            Debug.POLICY.exit(Debug.DEBUG_LINUX, EMPTY_PATH);
            Debug.POLICY.logError(ioe, Messages.FailedExecution0, command);
            return EMPTY_PATH;
        }
        if (outputLine == null) {
            Debug.POLICY.exit(Debug.DEBUG_LINUX, EMPTY_PATH);
            return EMPTY_PATH;
        }
        if (Debug.DEBUG_LINUX) {
            if (outputLine.equals(EMPTY_PATH)) {
                Debug.POLICY.exit(EMPTY_PATH);
            } else {
                Debug.POLICY.exit(outputLine);
            }
        }
        return outputLine;
    }
}

