/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.perf.toolopts;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.ptp.perf.toolopts.IAppInput;
import org.eclipse.ptp.perf.toolopts.ToolMaker;
import org.eclipse.ptp.perf.toolopts.ToolOption;
import org.eclipse.ptp.perf.toolopts.ToolPaneListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolPane
implements IAppInput {
    public static final int ALL_COMPILERS = 0;
    public static final int CC_COMPILER = 1;
    public static final int CXX_COMPILER = 2;
    public static final int F90_COMPILER = 3;
    public static final int EXEC_UTIL = 4;
    public static final int ANALYSIS = 5;
    public static final int ENV_VAR = 6;
    public final boolean virtual;
    private StringBuffer optString = null;
    private Map<String, String> varMap = null;
    protected SelectionListener browseListener;
    protected ToolPaneListener checkListener;
    public boolean displayOptions = true;
    public Text showOpts = null;
    protected ToolOption[] options;
    public String toolName;
    public String prependOpts = "";
    public String encloseOpts = "";
    public String separateOpts = "\n";
    public String encloseValues = "\"";
    public String separateNameValue = "=";
    public String configID = "";
    public String configVarID = "";
    public int paneType = -1;

    @Override
    public Map<String, String> getEnvVars(ILaunchConfiguration configuration) {
        try {
            return configuration.getAttribute(this.configVarID, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String getArgument(ILaunchConfiguration configuration) {
        try {
            return configuration.getAttribute(this.configID, "");
        }
        catch (CoreException e) {
            e.printStackTrace();
            return "";
        }
    }

    public boolean updateOptField(Object source) {
        int i = 0;
        while (i < this.options.length) {
            if (source.equals(this.options[i].argbox)) {
                this.OptArgUpdate(this.options[i]);
                this.updateOptDisplay();
                return true;
            }
            ++i;
        }
        return false;
    }

    public void OptUpdate() {
        this.optString = new StringBuffer(this.prependOpts).append(this.encloseOpts);
        int i = 0;
        while (i < this.options.length) {
            if (this.options[i].unitCheck == null || this.options[i].unitCheck.getSelection()) {
                if (this.options[i].isArgument) {
                    this.optString.append(this.options[i].optionLine).append(this.separateOpts);
                } else if (this.options[i].argbox != null) {
                    String text = this.options[i].argbox.getText();
                    if (!this.options[i].fieldrequired || text.trim().length() > 0) {
                        this.varMap.put(this.options[i].optName, text);
                    } else {
                        this.varMap.remove(this.options[i].optName);
                    }
                } else if (this.options[i].type == 7 && this.options[i].setOn != null) {
                    this.varMap.put(this.options[i].optName, this.options[i].setOn);
                }
                if (this.options[i].argbox != null) {
                    this.options[i].argbox.setEnabled(true);
                    if (this.options[i].browser != null) {
                        this.options[i].browser.setEnabled(true);
                    }
                }
            } else {
                if (this.options[i].argbox != null) {
                    this.options[i].argbox.setEnabled(false);
                    if (this.options[i].browser != null) {
                        this.options[i].browser.setEnabled(false);
                    }
                }
                if (this.options[i].type == 7) {
                    if (this.options[i].setOff != null) {
                        this.varMap.put(this.options[i].optName, this.options[i].setOff);
                    } else {
                        this.varMap.remove(this.options[i].optName);
                    }
                }
            }
            ++i;
        }
        this.optString.append(this.encloseOpts);
        this.updateOptDisplay();
    }

    protected void OptArgUpdate(ToolOption opt) {
        if (opt.type > 0) {
            opt.optionLine = new StringBuffer(opt.optName).append(this.separateNameValue).append(this.encloseValues).append(opt.argbox.getText()).append(this.encloseValues);
            this.OptUpdate();
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        int i = 0;
        while (i < this.options.length) {
            if (this.options[i].visible && !this.options[i].required) {
                configuration.setAttribute(this.options[i].confDefString, this.options[i].defState);
            }
            if (this.options[i].usesTextBox()) {
                configuration.setAttribute(this.options[i].confArgString, this.options[i].defText);
            }
            ++i;
        }
    }

    public void initializePane(ILaunchConfiguration configuration) throws CoreException {
        String arg = "";
        int i = 0;
        while (i < this.options.length) {
            if (this.options[i].unitCheck != null) {
                this.options[i].unitCheck.setSelection(configuration.getAttribute(this.options[i].confDefString, this.options[i].defState));
            }
            if (this.options[i].usesTextBox() && (arg = configuration.getAttribute(this.options[i].confArgString, this.options[i].defText)) != null) {
                this.options[i].argbox.setText(arg);
            }
            ++i;
        }
        this.updateOptDisplay();
    }

    protected void updateOptDisplay() {
        if (this.showOpts != null && this.optString != null) {
            this.showOpts.setText(this.optString.toString());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        int i = 0;
        while (i < this.options.length) {
            boolean set = true;
            if (this.options[i].unitCheck != null) {
                set = this.options[i].unitCheck.getSelection();
                configuration.setAttribute(this.options[i].confDefString, set);
            }
            if (this.options[i].usesTextBox()) {
                configuration.setAttribute(this.options[i].confArgString, this.options[i].argbox.getText());
            }
            ++i;
        }
    }

    public void makeToolPane(Composite comp) {
        ToolMaker.makeToolPane(comp, this, this.browseListener, this.checkListener);
    }

    public void makeToolPane(Composite comp, ToolPaneListener paneListener) {
        ToolMaker.makeToolPane(comp, this, this.browseListener, paneListener);
    }

    public String getOptionString() {
        String out = this.optString.toString();
        if (out.equals(String.valueOf(this.prependOpts) + this.encloseOpts + this.encloseOpts)) {
            return "";
        }
        return this.optString.toString();
    }

    public Map<String, String> getVarMap() {
        return this.varMap;
    }

    public ToolOption getOption(String optName) {
        int i = 0;
        while (i < this.options.length) {
            if (this.options[i].getName().equals(optName)) {
                return this.options[i];
            }
            ++i;
        }
        return null;
    }

    protected void setName(String name) {
        this.toolName = name;
        this.configID = String.valueOf(name) + ".performance.options.configuration_id_";
        this.configVarID = String.valueOf(name) + ".performance.options.environmentvariables.configuration_id_";
    }

    protected void setOptions(List<ToolOption> toptions) {
        this.options = new ToolOption[toptions.size()];
        toptions.toArray(this.options);
    }

    protected ToolPane(boolean virtual) {
        this.virtual = virtual;
        if (!virtual) {
            this.browseListener = new MakeBrowseListener();
            this.checkListener = new ToolPaneListener(this);
            this.optString = new StringBuffer();
            this.varMap = new LinkedHashMap<String, String>();
        }
    }

    protected class MakeBrowseListener
    extends SelectionAdapter {
        protected MakeBrowseListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            int i = 0;
            while (i < ToolPane.this.options.length) {
                if (source == ToolPane.this.options[i].browser) {
                    ToolMaker.optBrowse(ToolPane.this.options[i]);
                    break;
                }
                ++i;
            }
        }
    }
}

