/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.simulator.extensions;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.ptp.cell.simulator.tools.ContentRetrieverTool;

public class Architecture {
    String id;
    String name;
    String tclScriptFileName;
    URL tclScriptURL;

    public Architecture(String id, String name, String tclScriptFileName, URL tclScriptURL) {
        this.id = id;
        this.name = name;
        this.tclScriptFileName = tclScriptFileName;
        this.tclScriptURL = tclScriptURL;
    }

    public String toString() {
        return String.valueOf(this.id) + "; " + this.name + "; " + this.tclScriptFileName + "; " + this.tclScriptURL + "; ";
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getTclScriptFileName() {
        return this.tclScriptFileName;
    }

    public String getTclScriptContent() throws IOException {
        InputStreamReader inputReader = new InputStreamReader(this.getTclScriptInputStream());
        return ContentRetrieverTool.readStreamContent(inputReader);
    }

    public InputStream getTclScriptInputStream() throws IOException {
        URLConnection connection = this.tclScriptURL.openConnection();
        return connection.getInputStream();
    }

    public void writeTclScriptTo(OutputStream outputStream) throws IOException {
        InputStream inputStream = this.getTclScriptInputStream();
        ContentRetrieverTool.copyStreamContent(outputStream, inputStream);
    }
}

