/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.pdi.manager;

import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.pdi.IPDISession;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.manager.IPDITaskManager;
import org.eclipse.ptp.debug.internal.core.pdi.manager.AbstractPDIManager;

public class TaskManager
extends AbstractPDIManager
implements IPDITaskManager {
    private BitList terminatedTasks;
    private BitList suspendedTasks;
    private BitList registeredTasks;
    private BitList pendingTasks;
    private BitList canStepReturnTasks;

    public TaskManager(IPDISession session) {
        super(session, false);
        this.terminatedTasks = new BitList(session.getTotalTasks());
        this.suspendedTasks = new BitList(session.getTotalTasks());
        this.registeredTasks = new BitList(session.getTotalTasks());
        this.pendingTasks = new BitList(session.getTotalTasks());
        this.canStepReturnTasks = new BitList(session.getTotalTasks());
    }

    public boolean canAllStepReturn(BitList tasks) {
        return this.getCannotStepReturnTasks(tasks.copy()).isEmpty();
    }

    public BitList getCannotStepReturnTasks(BitList tasks) {
        tasks.andNot(this.getCanStepReturnTasks());
        return tasks;
    }

    public BitList getCanStepReturnTasks() {
        return this.canStepReturnTasks;
    }

    public BitList getCanStepReturnTasks(BitList tasks) {
        tasks.and(this.getCanStepReturnTasks());
        return tasks;
    }

    public BitList getNonPendingTasks(BitList tasks) {
        tasks.andNot(this.getPendingTasks());
        return tasks;
    }

    public BitList getNonRunningTasks(BitList tasks) {
        tasks.andNot(this.getRunningTasks(tasks.copy()));
        return tasks;
    }

    public BitList getNonSuspendedTasks(BitList tasks) {
        tasks.andNot(this.getSuspendedTasks());
        return tasks;
    }

    public BitList getNonTerminatedTasks(BitList tasks) {
        tasks.andNot(this.getTerminatedTasks());
        return tasks;
    }

    public BitList getPendingTasks() {
        return this.pendingTasks;
    }

    public BitList getPendingTasks(BitList tasks) {
        tasks.and(this.getPendingTasks());
        return tasks;
    }

    public BitList getRegisteredTasks() {
        return this.registeredTasks;
    }

    public BitList getRegisteredTasks(BitList tasks) {
        tasks.and(this.getRegisteredTasks());
        return tasks;
    }

    public BitList getRunningTasks(BitList tasks) {
        tasks.andNot(this.getTerminatedTasks());
        tasks.andNot(this.getSuspendedTasks());
        return tasks;
    }

    public BitList getSuspendedTasks() {
        return this.suspendedTasks;
    }

    public BitList getSuspendedTasks(BitList tasks) {
        tasks.and(this.getSuspendedTasks());
        return tasks;
    }

    public BitList getTerminatedTasks() {
        return this.terminatedTasks;
    }

    public BitList getTerminatedTasks(BitList tasks) {
        tasks.and(this.getTerminatedTasks());
        return tasks;
    }

    public BitList getUnregisteredTasks(BitList tasks) {
        tasks.andNot(this.getRegisteredTasks());
        return tasks;
    }

    public boolean isAllPending(BitList tasks) {
        return this.getNonPendingTasks(tasks.copy()).isEmpty();
    }

    public boolean isAllRegistered(BitList tasks) {
        return this.getUnregisteredTasks(tasks.copy()).isEmpty();
    }

    public boolean isAllRunning(BitList tasks) {
        return !this.isAllSuspended(tasks) && !this.isAllTerminated(tasks);
    }

    public boolean isAllSuspended(BitList tasks) {
        return this.getNonSuspendedTasks(tasks.copy()).isEmpty();
    }

    public boolean isAllTerminated(BitList tasks) {
        return this.getNonTerminatedTasks(tasks.copy()).isEmpty();
    }

    public void setCanStepReturnTasks(boolean isAdd, BitList tasks) {
        if (isAdd) {
            this.canStepReturnTasks = this.addTasks(this.canStepReturnTasks, tasks);
        } else {
            this.removeTasks(this.canStepReturnTasks, tasks);
        }
    }

    public void setPendingTasks(boolean isAdd, BitList tasks) {
        if (isAdd) {
            this.pendingTasks = this.addTasks(this.pendingTasks, tasks);
        } else {
            this.removeTasks(this.pendingTasks, tasks);
        }
    }

    public void setRegisterTasks(boolean isAdd, BitList tasks) {
        if (isAdd) {
            this.registeredTasks = this.addTasks(this.registeredTasks, tasks);
        } else {
            this.removeTasks(this.registeredTasks, tasks);
        }
    }

    public void setSuspendTasks(boolean isAdd, BitList tasks) {
        if (isAdd) {
            this.suspendedTasks = this.addTasks(this.suspendedTasks, tasks);
        } else {
            this.removeTasks(this.suspendedTasks, tasks);
            this.setCanStepReturnTasks(false, tasks);
        }
    }

    public void setTerminateTasks(boolean isAdd, BitList tasks) {
        if (isAdd) {
            this.terminatedTasks = this.addTasks(this.terminatedTasks, tasks);
            this.setSuspendTasks(false, tasks);
        } else {
            this.removeTasks(this.terminatedTasks, tasks);
        }
    }

    public void shutdown() {
    }

    public void update(BitList tasks) throws PDIException {
    }

    private synchronized BitList addTasks(BitList curTasks, BitList newTasks) {
        if (curTasks.size() < newTasks.size()) {
            newTasks.or(curTasks);
            curTasks = newTasks.copy();
        }
        curTasks.or(newTasks);
        return curTasks;
    }

    private synchronized void removeTasks(BitList curTasks, BitList newTasks) {
        curTasks.andNot(newTasks);
    }
}

