/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.sputiming.execution;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.cell.sputiming.Activator;
import org.eclipse.ptp.cell.sputiming.debug.Debug;
import org.eclipse.ptp.cell.sputiming.execution.CompilerParameters;
import org.eclipse.ptp.cell.sputiming.execution.Messages;
import org.eclipse.ptp.cell.sputiming.execution.SPUTimingParameters;
import org.eclipse.ptp.cell.utils.process.ProcessController;
import org.eclipse.ptp.cell.utils.stream.StreamBridge;
import org.eclipse.ptp.utils.core.linux.ArgumentParser;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;

public class SPUTimingExecution {
    private static final long EXEC_TIMEOUT = 360L;
    CompilerParameters compilerParameters;
    SPUTimingParameters spuTimingParameters;

    protected SPUTimingExecution(CompilerParameters compilerParameters, SPUTimingParameters spuTimingParameters) {
        this.compilerParameters = compilerParameters;
        this.spuTimingParameters = spuTimingParameters;
    }

    public static SPUTimingExecution createExecution(CompilerParameters cp, SPUTimingParameters spup) {
        return new SPUTimingExecution(cp, spup);
    }

    public void startCompiler() throws CoreException {
        block11: {
            Debug.read();
            Debug.POLICY.trace(Debug.DEBUG_COMPILER, "Start compiling.");
            Debug.POLICY.trace(Debug.DEBUG_COMPILER, "Parameters: {0}", new Object[]{this.compilerParameters.toString()});
            ArrayList<String> l = new ArrayList<String>();
            l.add(this.compilerParameters.getCompilerPath());
            if (this.compilerParameters.getCompilerFlags() != null) {
                ArgumentParser argumentParser = new ArgumentParser(this.compilerParameters.getCompilerFlags());
                l.addAll(argumentParser.getTokenList());
            }
            l.add(this.compilerParameters.getSourceFile());
            String[] parameterArray = l.toArray(new String[l.size()]);
            Debug.POLICY.trace(Debug.DEBUG_COMPILER, "Command line: {0}", new Object[]{new ArgumentParser(parameterArray).getCommandLine(true)});
            Process compilerProcess = null;
            try {
                IOConsoleOutputStream os = this.compilerParameters.getConsole().newOutputStream();
                OutputStreamWriter w = new OutputStreamWriter((OutputStream)os);
                w.write(String.valueOf(new ArgumentParser(parameterArray).getCommandLine(true)) + "\n");
                w.close();
                String[] path = this.compilerParameters.getCompilerEnvironment();
                String compilerCommand = parameterArray[0];
                int i = 0;
                while (i < path.length) {
                    Debug.POLICY.trace(Debug.DEBUG_COMPILER, "Path entry: {0}", new Object[]{path[i]});
                    File pathEntryFile = new File(path[i]);
                    File compilerFile = new File(pathEntryFile, compilerCommand);
                    parameterArray[0] = compilerFile.getAbsolutePath();
                    try {
                        compilerProcess = Runtime.getRuntime().exec(parameterArray, null, this.compilerParameters.getWorkingDirectory());
                        break;
                    }
                    catch (IOException iOException) {
                        Debug.POLICY.trace(Debug.DEBUG_COMPILER, "Compiler not found on this path entry");
                        ++i;
                    }
                }
                if (compilerProcess == null) {
                    throw new IOException(String.valueOf(Messages.SPUTimingExecution_ExecuteCompiler_CompilerNotFoundInPath) + path);
                }
                Debug.POLICY.trace(Debug.DEBUG_COMPILER, "Compiler is running");
            }
            catch (Exception e) {
                Debug.POLICY.error(Debug.DEBUG_COMPILER, "Failed to execute compiler: {0}", new Object[]{e.getMessage()});
                throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), 0, Messages.StartCompiler_CompilerExecError, (Throwable)e));
            }
            if (this.compilerParameters.getConsole() != null) {
                this.connectConsoleToProcess(this.compilerParameters.getConsole(), compilerProcess);
                Debug.POLICY.trace(Debug.DEBUG_COMPILER, "Connected to console");
            }
            ProcessController pControl = new ProcessController(Messages.StartCompiler_CompilerProcessLabel, compilerProcess, 360L);
            pControl.run();
            Debug.POLICY.trace(Debug.DEBUG_COMPILER, "Created process controller");
            try {
                Debug.POLICY.trace(Debug.DEBUG_COMPILER, "Waiting for compiler to finish");
                int retCode = compilerProcess.waitFor();
                if (retCode == 0) {
                    Debug.POLICY.trace(Debug.DEBUG_COMPILER, "Compiler finished successfully");
                    break block11;
                }
                Debug.POLICY.error(Debug.DEBUG_COMPILER, "Compiler finished with exit code {0}", new Object[]{retCode});
                throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), 0, NLS.bind((String)Messages.StartCompiler_OSCompilerError, (Object)retCode), null));
            }
            catch (InterruptedException e) {
                Debug.POLICY.error(Debug.DEBUG_COMPILER, "Compiler was interrupted: {0}", new Object[]{e.getMessage()});
                throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), 0, Messages.StartCompiler_Timeout, (Throwable)e));
            }
        }
        Debug.POLICY.trace(Debug.DEBUG_COMPILER, "Finished compiling.");
    }

    public void startSPUTimingTool() throws CoreException {
        Debug.POLICY.trace(Debug.DEBUG_SPUTIMING, "Start sputiming.");
        Debug.POLICY.trace(Debug.DEBUG_SPUTIMING, "Parameters: {0}", new Object[]{this.compilerParameters.toString()});
        ArrayList<String> l = new ArrayList<String>();
        l.add(this.spuTimingParameters.getSputimingPath());
        if (this.spuTimingParameters.getParameters() != null) {
            ArgumentParser argumentParser = new ArgumentParser(this.spuTimingParameters.getParameters());
            l.addAll(argumentParser.getTokenList());
        }
        l.add(this.spuTimingParameters.getInputFile());
        String[] commandLine = l.toArray(new String[l.size()]);
        Debug.POLICY.trace(Debug.DEBUG_SPUTIMING, "Command line: {0}", new Object[]{new ArgumentParser(commandLine).getCommandLine(true)});
        Process procsputiming = null;
        try {
            IOConsoleOutputStream os = this.compilerParameters.getConsole().newOutputStream();
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)os);
            w.write(String.valueOf(new ArgumentParser(commandLine).getCommandLine(true)) + "\n");
            w.close();
            procsputiming = Runtime.getRuntime().exec(commandLine, null, this.spuTimingParameters.getWorkingDirectory());
            Debug.POLICY.trace(Debug.DEBUG_SPUTIMING, "sputiming is running");
        }
        catch (Exception e) {
            Debug.POLICY.error(Debug.DEBUG_SPUTIMING, "Failed to execute sputiming: {0}", new Object[]{e.getMessage()});
            throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), 0, Messages.StartSPUTiming_SPUTimingExecError, (Throwable)e));
        }
        if (this.spuTimingParameters.getConsole() != null) {
            this.connectConsoleToProcess(this.spuTimingParameters.getConsole(), procsputiming);
            Debug.POLICY.trace(Debug.DEBUG_SPUTIMING, "Connected to console");
        }
        ProcessController pControl = new ProcessController(Messages.StartSPUTiming_ProcessLabel, procsputiming, 360L);
        pControl.run();
        Debug.POLICY.trace(Debug.DEBUG_SPUTIMING, "Created process controller");
        try {
            int retCode = procsputiming.waitFor();
            if (retCode != 0) {
                Debug.POLICY.error(Debug.DEBUG_SPUTIMING, "sputiming finished with exit code {0}", new Object[]{retCode});
                throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), 0, NLS.bind((String)Messages.StartSPUTiming_OSSPUTimingError, (Object)retCode), null));
            }
            Debug.POLICY.trace(Debug.DEBUG_SPUTIMING, "sputiming finished successfully");
        }
        catch (InterruptedException e) {
            Debug.POLICY.error(Debug.DEBUG_SPUTIMING, "sputiming was interrupted: {0}", new Object[]{e.getMessage()});
            throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), 0, Messages.StartSPUTiming_Timeout, (Throwable)e));
        }
    }

    public void connectConsoleToProcess(IOConsole console, Process process) {
        IOConsoleOutputStream consoleoutputstream = console.newOutputStream();
        StreamBridge bridgeStdOutput = new StreamBridge(process.getInputStream(), (OutputStream)consoleoutputstream, "Output");
        StreamBridge bridgeStdError = new StreamBridge(process.getErrorStream(), (OutputStream)consoleoutputstream, "Error");
        bridgeStdOutput.run();
        bridgeStdError.run();
    }
}

