/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.sputiming.ui;

import java.util.Date;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ptp.cell.sputiming.ui.debug.Debug;
import org.eclipse.ptp.cell.sputiming.ui.parse.ParsedTimingFile;
import org.eclipse.ptp.cell.sputiming.ui.views.SpuTimingDiagramView;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    private static Activator plugin;
    private ParsedTimingFile parsedTiming = null;
    private SpuTimingDiagramView view = null;

    public Activator() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        Debug.read();
        if (Debug.DEBUG) {
            Date date = new Date();
            Debug.POLICY.trace("Bundle started at {0}", new Object[]{date.toString()});
        }
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
        Debug.read();
        if (Debug.DEBUG) {
            Date date = new Date();
            Debug.POLICY.trace("Bundle stopped at {0}", new Object[]{date.toString()});
        }
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ptp.cell.plugin.sputiming", (String)path);
    }

    public void setTiming(ParsedTimingFile parsedTiming) {
        this.parsedTiming = parsedTiming;
        if (this.view != null) {
            this.view.invalidateTiming();
        }
        final IWorkbench workbench = PlatformUI.getWorkbench();
        Display display = workbench.getDisplay();
        display.syncExec(new Runnable(){

            public void run() {
                try {
                    IWorkbenchPage page;
                    IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                    if (window != null && (page = window.getActivePage()) != null) {
                        page.showView("org.eclipse.ptp.cell.sputiming.views.SpuTimingDiagramView");
                    }
                }
                catch (Exception e) {
                    Debug.POLICY.error(Debug.DEBUG_UI, (Throwable)e);
                    Debug.POLICY.logError((Throwable)e);
                }
            }
        });
    }

    public ParsedTimingFile getTiming() {
        return this.parsedTiming;
    }

    public void setView(SpuTimingDiagramView view) {
        this.view = view;
    }
}

