/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.sputiming.ui.views;

import java.util.Iterator;
import org.eclipse.ptp.cell.sputiming.ui.views.DiagramBlock;
import org.eclipse.ptp.cell.sputiming.ui.views.DiagramVector;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class DiagramBar
extends Canvas
implements PaintListener {
    private static final int VERTICAL_BORDER = 2;
    private int gridSize = 10;
    private int height;
    private int width;
    private int arcSize = 7;
    private int totalValue;
    private Color backgroundColor;
    private DiagramVector diagramVector;

    public DiagramBar(Composite parent, Color backgroundColor, int totalValue, int heightPixels, int maxWidthPixels) {
        super(parent, 0);
        this.height = heightPixels;
        this.width = maxWidthPixels + 2;
        this.totalValue = totalValue;
        this.backgroundColor = backgroundColor;
        this.addPaintListener(this);
    }

    public Point getSize() {
        return new Point(this.width, this.height);
    }

    public Point computeSize(int wHint, int hHint) {
        return new Point(this.width, this.height);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return this.computeSize(wHint, hHint);
    }

    public void setDiagramVector(DiagramVector diagramVector) {
        this.diagramVector = diagramVector;
    }

    public void paintControl(PaintEvent e) {
        e.gc.setBackground(this.backgroundColor);
        e.gc.fillRectangle(0, 0, this.width, this.height);
        int i = this.gridSize;
        while (i < this.width) {
            e.gc.setForeground(new Color(null, 150, 150, 150));
            e.gc.setLineStyle(3);
            e.gc.drawLine(i, 0, i, this.height);
            i += this.gridSize;
        }
        if (this.diagramVector != null) {
            e.gc.setLineStyle(1);
            Iterator it = this.diagramVector.iterator();
            while (it.hasNext()) {
                DiagramBlock diagramBlock = (DiagramBlock)it.next();
                int pos = diagramBlock.getPosition() * this.width / this.totalValue;
                int size = diagramBlock.getSize() * this.width / this.totalValue;
                e.gc.setAntialias(1);
                e.gc.setForeground(new Color(null, 10, 10, 10));
                e.gc.setBackground(diagramBlock.getColor());
                e.gc.fillRoundRectangle(pos, 2, size, this.height - 4, this.arcSize, this.arcSize);
                e.gc.drawRoundRectangle(pos, 2, size, this.height - 4, this.arcSize, this.arcSize);
            }
        }
    }
}

