/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.CPPASTVisitor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.core.parser.util.ObjectMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPDeferredClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateDefinition;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeMixin;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalClassTemplate;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalClassTypeMixinHost;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.index.IIndexType;

public class CPPClassTemplate
extends CPPTemplateDefinition
implements ICPPClassTemplate,
ICPPClassType,
ICPPInternalClassTemplate,
ICPPInternalClassTypeMixinHost {
    private ICPPClassTemplatePartialSpecialization[] partialSpecializations = null;
    private ClassTypeMixin mixin = new ClassTypeMixin(this);

    public CPPClassTemplate(IASTName name) {
        super(name);
    }

    public ICPPSpecialization deferredInstance(ObjectMap argMap, IType[] arguments) {
        ICPPSpecialization instance = this.getInstance(arguments);
        if (instance == null) {
            instance = new CPPDeferredClassInstance(this, argMap, arguments);
            this.addSpecialization(arguments, instance);
        }
        return instance;
    }

    public void checkForDefinition() {
        FindDefinitionAction action = new FindDefinitionAction();
        IASTNode node = CPPVisitor.getContainingBlockItem(this.declarations[0]).getParent();
        while (node instanceof ICPPASTTemplateDeclaration) {
            node = node.getParent();
        }
        node.accept(action);
        this.definition = action.result;
        if (this.definition == null) {
            node.getTranslationUnit().accept(action);
            this.definition = action.result;
        }
    }

    public void addPartialSpecialization(ICPPClassTemplatePartialSpecialization spec) {
        this.partialSpecializations = (ICPPClassTemplatePartialSpecialization[])ArrayUtil.append(ICPPClassTemplatePartialSpecialization.class, this.partialSpecializations, spec);
    }

    public ICPPASTCompositeTypeSpecifier getCompositeTypeSpecifier() {
        if (this.definition != null) {
            IASTNode node = this.definition.getParent();
            if (node instanceof ICPPASTQualifiedName) {
                node = node.getParent();
            }
            if (node instanceof ICPPASTCompositeTypeSpecifier) {
                return (ICPPASTCompositeTypeSpecifier)node;
            }
        }
        return null;
    }

    public IScope getCompositeScope() {
        if (this.definition == null) {
            this.checkForDefinition();
        }
        if (this.definition != null) {
            IASTNode parent = this.definition.getParent();
            while (parent instanceof IASTName) {
                parent = parent.getParent();
            }
            if (parent instanceof ICPPASTCompositeTypeSpecifier) {
                ICPPASTCompositeTypeSpecifier compSpec = (ICPPASTCompositeTypeSpecifier)parent;
                return compSpec.getScope();
            }
        }
        return null;
    }

    public int getKey() {
        IASTNode n;
        if (this.definition != null) {
            ICPPASTCompositeTypeSpecifier cts = this.getCompositeTypeSpecifier();
            if (cts != null) {
                return cts.getKey();
            }
            IASTNode n2 = this.definition.getParent();
            if (n2 instanceof ICPPASTElaboratedTypeSpecifier) {
                return ((ICPPASTElaboratedTypeSpecifier)n2).getKind();
            }
        }
        if (this.declarations != null && this.declarations.length > 0 && (n = this.declarations[0].getParent()) instanceof ICPPASTElaboratedTypeSpecifier) {
            return ((ICPPASTElaboratedTypeSpecifier)n).getKind();
        }
        return 3;
    }

    public ICPPClassTemplatePartialSpecialization[] getPartialSpecializations() {
        this.partialSpecializations = (ICPPClassTemplatePartialSpecialization[])ArrayUtil.trim(ICPPClassTemplatePartialSpecialization.class, this.partialSpecializations);
        return this.partialSpecializations;
    }

    public boolean isSameType(IType type) {
        if (type == this) {
            return true;
        }
        if (type instanceof ITypedef || type instanceof IIndexType) {
            return type.isSameType(this);
        }
        return false;
    }

    public ICPPBase[] getBases() {
        return this.mixin.getBases();
    }

    public IField[] getFields() throws DOMException {
        return this.mixin.getFields();
    }

    public ICPPField[] getDeclaredFields() throws DOMException {
        return this.mixin.getDeclaredFields();
    }

    public ICPPMethod[] getMethods() throws DOMException {
        return CPPClassType.getMethods(this);
    }

    public ICPPMethod[] getAllDeclaredMethods() throws DOMException {
        return this.mixin.getAllDeclaredMethods();
    }

    public ICPPMethod[] getDeclaredMethods() throws DOMException {
        return this.mixin.getDeclaredMethods();
    }

    public ICPPConstructor[] getConstructors() throws DOMException {
        return this.mixin.getConstructors();
    }

    public IBinding[] getFriends() {
        return this.mixin.getFriends();
    }

    public ICPPClassType[] getNestedClasses() {
        return this.mixin.getNestedClasses();
    }

    public IField findField(String name) throws DOMException {
        return this.mixin.findField(name);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String toString() {
        return ASTTypeUtil.getType(this);
    }

    private class FindDefinitionAction
    extends CPPASTVisitor {
        private char[] nameArray;
        public IASTName result;

        private FindDefinitionAction() {
            this.nameArray = CPPClassTemplate.this.getNameCharArray();
            this.result = null;
            this.shouldVisitNames = true;
            this.shouldVisitDeclarations = true;
            this.shouldVisitDeclSpecifiers = true;
            this.shouldVisitDeclarators = true;
        }

        public int visit(IASTName name) {
            IBinding binding;
            if (name instanceof ICPPASTTemplateId || name instanceof ICPPASTQualifiedName) {
                return 3;
            }
            char[] c = name.toCharArray();
            if (name.getParent() instanceof ICPPASTTemplateId) {
                name = (IASTName)name.getParent();
            }
            if (name.getParent() instanceof ICPPASTQualifiedName) {
                IASTName[] ns = ((ICPPASTQualifiedName)name.getParent()).getNames();
                if (ns[ns.length - 1] != name) {
                    return 3;
                }
                name = (IASTName)name.getParent();
            }
            if (name.getParent() instanceof ICPPASTCompositeTypeSpecifier && CharArrayUtils.equals(c, this.nameArray) && (binding = name.resolveBinding()) == CPPClassTemplate.this) {
                if (name instanceof ICPPASTQualifiedName) {
                    IASTName[] ns = ((ICPPASTQualifiedName)name).getNames();
                    name = ns[ns.length - 1];
                }
                this.result = name;
                return 2;
            }
            return 3;
        }

        public int visit(IASTDeclaration declaration) {
            if (declaration instanceof IASTSimpleDeclaration || declaration instanceof ICPPASTTemplateDeclaration) {
                return 3;
            }
            return 1;
        }

        public int visit(IASTDeclSpecifier declSpec) {
            return declSpec instanceof ICPPASTCompositeTypeSpecifier ? 3 : 1;
        }

        public int visit(IASTDeclarator declarator) {
            return 1;
        }
    }
}

