/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.db;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.internal.core.pdom.db.Chunk;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.db.IString;
import org.eclipse.cdt.internal.core.pdom.db.LongString;
import org.eclipse.core.runtime.CoreException;

public class ShortString
implements IString {
    private final Database db;
    private final int record;
    private int hash;
    private static final int LENGTH = 0;
    private static final int CHARS = 4;
    public static final int MAX_LENGTH = 2045;

    public ShortString(Database db, int offset) {
        this.db = db;
        this.record = offset;
    }

    public ShortString(Database db, char[] chars) throws CoreException {
        this.db = db;
        this.record = db.malloc(4 + chars.length * 2);
        Chunk chunk = db.getChunk(this.record);
        chunk.putInt(this.record + 0, (char)chars.length);
        int n = chars.length;
        int p = this.record + 4;
        int i = 0;
        while (i < n) {
            chunk.putChar(p, chars[i]);
            p += 2;
            ++i;
        }
    }

    public ShortString(Database db, String string) throws CoreException {
        this.db = db;
        this.record = db.malloc(4 + string.length() * 2);
        Chunk chunk = db.getChunk(this.record);
        chunk.putInt(this.record + 0, string.length());
        int n = string.length();
        int p = this.record + 4;
        int i = 0;
        while (i < n) {
            chunk.putChar(p, string.charAt(i));
            p += 2;
            ++i;
        }
    }

    public int getRecord() {
        return this.record;
    }

    public void delete() throws CoreException {
        this.db.free(this.record);
    }

    public char[] getChars() throws CoreException {
        Chunk chunk = this.db.getChunk(this.record);
        int length = chunk.getInt(this.record + 0);
        char[] chars = new char[length];
        chunk.getCharArray(this.record + 4, chars);
        return chars;
    }

    public String getString() throws CoreException {
        return new String(this.getChars());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        try {
            if (obj instanceof ShortString) {
                int n2;
                ShortString string = (ShortString)obj;
                if (this.db == string.db && this.record == string.record) {
                    return true;
                }
                Chunk chunk1 = this.db.getChunk(this.record);
                Chunk chunk2 = string.db.getChunk(string.record);
                int n1 = chunk1.getInt(this.record);
                if (n1 != (n2 = chunk2.getInt(string.record))) {
                    return false;
                }
                int p1 = this.record + 4;
                int p2 = string.record + 4;
                int i = 0;
                while (i < n1) {
                    if (chunk1.getChar(p1) != chunk2.getChar(p2)) {
                        return false;
                    }
                    p1 += 2;
                    p2 += 2;
                    ++i;
                }
                return true;
            }
            if (obj instanceof char[]) {
                char[] chars = (char[])obj;
                Chunk chunk = this.db.getChunk(this.record);
                int n = chunk.getInt(this.record);
                if (n != chars.length) {
                    return false;
                }
                int p = this.record + 4;
                int i = 0;
                while (i < n) {
                    if (chunk.getChar(p) != chars[i]) {
                        return false;
                    }
                    p += 2;
                    ++i;
                }
                return true;
            }
            if (obj instanceof String) {
                String string = (String)obj;
                Chunk chunk = this.db.getChunk(this.record);
                int n = chunk.getInt(this.record);
                if (n != string.length()) {
                    return false;
                }
                int p = this.record + 4;
                int i = 0;
                while (i < n) {
                    if (chunk.getChar(p) != string.charAt(i)) {
                        return false;
                    }
                    p += 2;
                    ++i;
                }
                return true;
            }
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
        }
        return false;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            try {
                char[] chars = this.getChars();
                int len = chars.length;
                int i = 0;
                while (i < len) {
                    h = 31 * h + chars[i];
                    ++i;
                }
            }
            catch (CoreException coreException) {}
            this.hash = h;
        }
        return h;
    }

    public int compare(char[] other, boolean caseSensitive) throws CoreException {
        Chunk chunk = this.db.getChunk(this.record);
        int i1 = this.record + 4;
        int i2 = 0;
        int n1 = i1 + chunk.getInt(this.record + 0) * 2;
        int n2 = other.length;
        while (i1 < n1 && i2 < n2) {
            int cmp = ShortString.compareChars(chunk.getChar(i1), other[i2], caseSensitive);
            if (cmp != 0) {
                return cmp;
            }
            i1 += 2;
            ++i2;
        }
        if (i1 == n1 && i2 != n2) {
            return -1;
        }
        if (i2 == n2 && i1 != n1) {
            return 1;
        }
        return 0;
    }

    public int compare(IString string, boolean caseSensitive) throws CoreException {
        if (string instanceof ShortString) {
            return this.compare((ShortString)string, caseSensitive);
        }
        if (string instanceof LongString) {
            return -((LongString)string).compare(this, caseSensitive);
        }
        throw new IllegalArgumentException();
    }

    public int compare(ShortString other, boolean caseSensitive) throws CoreException {
        Chunk chunk1 = this.db.getChunk(this.record);
        Chunk chunk2 = other.db.getChunk(other.record);
        int i1 = this.record + 4;
        int i2 = other.record + 4;
        int n1 = i1 + chunk1.getInt(this.record + 0) * 2;
        int n2 = i2 + chunk2.getInt(other.record + 0) * 2;
        while (i1 < n1 && i2 < n2) {
            int cmp = ShortString.compareChars(chunk1.getChar(i1), chunk2.getChar(i2), caseSensitive);
            if (cmp != 0) {
                return cmp;
            }
            i1 += 2;
            i2 += 2;
        }
        if (i1 == n1 && i2 != n2) {
            return -1;
        }
        if (i2 == n2 && i1 != n1) {
            return 1;
        }
        return 0;
    }

    public int compare(String other, boolean caseSensitive) throws CoreException {
        Chunk chunk = this.db.getChunk(this.record);
        int i1 = this.record + 4;
        int i2 = 0;
        int n1 = i1 + chunk.getInt(this.record + 0) * 2;
        int n2 = other.length();
        while (i1 < n1 && i2 < n2) {
            int cmp = ShortString.compareChars(chunk.getChar(i1), other.charAt(i2), caseSensitive);
            if (cmp != 0) {
                return cmp;
            }
            i1 += 2;
            ++i2;
        }
        if (i1 == n1 && i2 != n2) {
            return -1;
        }
        if (i2 == n2 && i1 != n1) {
            return 1;
        }
        return 0;
    }

    public int compareCompatibleWithIgnoreCase(IString string) throws CoreException {
        if (string instanceof ShortString) {
            return this.compareCompatibleWithIgnoreCase((ShortString)string);
        }
        if (string instanceof LongString) {
            return -((LongString)string).compareCompatibleWithIgnoreCase(this);
        }
        throw new IllegalArgumentException();
    }

    public int compareCompatibleWithIgnoreCase(ShortString other) throws CoreException {
        Chunk chunk1 = this.db.getChunk(this.record);
        Chunk chunk2 = other.db.getChunk(other.record);
        int i1 = this.record + 4;
        int i2 = other.record + 4;
        int n1 = i1 + chunk1.getInt(this.record + 0) * 2;
        int n2 = i2 + chunk2.getInt(other.record + 0) * 2;
        int sensitiveCmp = 0;
        while (i1 < n1 && i2 < n2) {
            char c2;
            char c1 = chunk1.getChar(i1);
            if (c1 != (c2 = chunk2.getChar(i2))) {
                int cmp = ShortString.compareChars(c1, c2, false);
                if (cmp != 0) {
                    return cmp;
                }
                if (sensitiveCmp == 0) {
                    sensitiveCmp = c1 < c2 ? -1 : 1;
                }
            }
            i1 += 2;
            i2 += 2;
        }
        if (i1 == n1 && i2 != n2) {
            return -1;
        }
        if (i2 == n2 && i1 != n1) {
            return 1;
        }
        return sensitiveCmp;
    }

    public int compareCompatibleWithIgnoreCase(char[] chars) throws CoreException {
        Chunk chunk1 = this.db.getChunk(this.record);
        int i1 = this.record + 4;
        int i2 = 0;
        int n1 = i1 + chunk1.getInt(this.record + 0) * 2;
        int n2 = chars.length;
        int sensitiveCmp = 0;
        while (i1 < n1 && i2 < n2) {
            char c2;
            char c1 = chunk1.getChar(i1);
            if (c1 != (c2 = chars[i2])) {
                int cmp = ShortString.compareChars(c1, c2, false);
                if (cmp != 0) {
                    return cmp;
                }
                if (sensitiveCmp == 0) {
                    sensitiveCmp = c1 < c2 ? -1 : 1;
                }
            }
            i1 += 2;
            ++i2;
        }
        if (i1 == n1 && i2 != n2) {
            return -1;
        }
        if (i2 == n2 && i1 != n1) {
            return 1;
        }
        return sensitiveCmp;
    }

    public int comparePrefix(char[] other, boolean caseSensitive) throws CoreException {
        Chunk chunk = this.db.getChunk(this.record);
        int i1 = this.record + 4;
        int i2 = 0;
        int n1 = i1 + chunk.getInt(this.record + 0) * 2;
        int n2 = other.length;
        while (i1 < n1 && i2 < n2) {
            int cmp = ShortString.compareChars(chunk.getChar(i1), other[i2], caseSensitive);
            if (cmp != 0) {
                return cmp;
            }
            i1 += 2;
            ++i2;
        }
        if (i1 == n1 && i2 != n2) {
            return -1;
        }
        return 0;
    }

    public char charAt(int i) throws CoreException {
        int ptr = this.record + 4 + i * 2;
        return this.db.getChar(ptr);
    }

    public int getLength() throws CoreException {
        return this.db.getInt(this.record + 0);
    }

    public static int compareChars(char a, char b, boolean caseSensitive) {
        if (caseSensitive) {
            if (a < b) {
                return -1;
            }
            if (a > b) {
                return 1;
            }
        } else if (a != b) {
            a = a >= 'a' && a <= 'z' ? (char)(a - 32) : a;
            char c = b = b >= 'a' && b <= 'z' ? (char)(b - 32) : b;
            if (a < b) {
                return -1;
            }
            if (a > b) {
                return 1;
            }
        }
        return 0;
    }
}

