/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.indexer;

import java.util.Collection;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementVisitor;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TranslationUnitCollector
implements ICElementVisitor {
    private final Collection<ITranslationUnit> fSources;
    private final Collection<ITranslationUnit> fHeaders;
    private final IProgressMonitor fProgressMonitor;

    public TranslationUnitCollector(Collection<ITranslationUnit> sources, Collection<ITranslationUnit> headers, IProgressMonitor pm) {
        this.fSources = sources;
        this.fHeaders = headers;
        this.fProgressMonitor = pm;
    }

    public boolean visit(ICElement element) throws CoreException {
        if (this.fProgressMonitor.isCanceled()) {
            return false;
        }
        switch (element.getElementType()) {
            case 60: {
                ITranslationUnit tu = (ITranslationUnit)element;
                if (tu.isSourceUnit()) {
                    this.fSources.add(tu);
                } else if (this.fHeaders != null && tu.isHeaderUnit()) {
                    this.fHeaders.add(tu);
                }
                return false;
            }
            case 11: 
            case 12: {
                return true;
            }
        }
        return false;
    }
}

