/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.dstore.universal.miners.command;

import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.dstore.core.miners.MinerThread;
import org.eclipse.dstore.core.model.Client;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.rse.dstore.universal.miners.CommandMiner;
import org.eclipse.rse.internal.dstore.universal.miners.command.OutputHandler;
import org.eclipse.rse.internal.dstore.universal.miners.command.patterns.ParsedOutput;
import org.eclipse.rse.internal.dstore.universal.miners.command.patterns.Patterns;

public class CommandMinerThread
extends MinerThread {
    private DataElement _status;
    private String _invocation;
    private DataInputStream _stdInput;
    private DataInputStream _stdError;
    private BufferedWriter _stdOutput;
    private Patterns _patterns;
    private Process _theProcess;
    private DataElement _subject;
    private String _cwdStr;
    private OutputHandler _stdOutputHandler;
    private OutputHandler _stdErrorHandler;
    private boolean _isShell = false;
    private boolean _isDone = false;
    private boolean _isWindows;
    private boolean _isTTY;
    private boolean _didInitialCWDQuery = false;
    private int _maxLineLength = 4096;
    private CommandMiner.CommandMinerDescriptors _descriptors;
    private String PSEUDO_TERMINAL;
    private DataElement _lastPrompt;
    private InitRunnable _initRunnable;
    private Thread _cdThread;

    public CommandMinerThread(DataElement theElement, String invocation, DataElement status, Patterns thePatterns, CommandMiner.CommandMinerDescriptors descriptors) {
        super(theElement.getDataStore());
        this._status = status;
        this._descriptors = descriptors;
        boolean isBash = false;
        this._subject = theElement;
        String maxLineLengthStr = System.getProperty("DSTORE_SHELL_MAX_LINE");
        if (maxLineLengthStr != null) {
            try {
                this._maxLineLength = Integer.parseInt(maxLineLengthStr);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        String theOS = System.getProperty("os.name");
        this._invocation = invocation.trim();
        this._patterns = thePatterns;
        this._patterns.refresh(this._invocation);
        boolean isZ = theOS.toLowerCase().startsWith("z");
        if (isZ) {
            System.setProperty("dstore.stdin.encoding", "Cp037");
        }
        this._isWindows = theOS.toLowerCase().startsWith("win");
        if (!this._isWindows) {
            this.PSEUDO_TERMINAL = String.valueOf(this._dataStore.getAttribute(0)) + File.separatorChar + "rseterm" + File.separatorChar + "rseterm";
        }
        try {
            File theDirectory;
            String suCommand = null;
            String userHome = null;
            Client client = this._dataStore.getClient();
            if (client != null && !theOS.equals("z/OS")) {
                String clientActualUserId = client.getProperty("user.name");
                String clientUserId = client.getUserid();
                userHome = client.getProperty("user.home");
                if (clientUserId != null && !clientActualUserId.equals(clientUserId)) {
                    suCommand = "su " + clientUserId + " -c ";
                }
            } else {
                userHome = System.getProperty("user.home");
            }
            this._cwdStr = theElement.getSource();
            if (this._cwdStr == null || this._cwdStr.length() == 0) {
                this._cwdStr = userHome;
            }
            if (!(theDirectory = new File(this._cwdStr)).isDirectory()) {
                theDirectory = theDirectory.getParentFile();
            }
            try {
                this._cwdStr = theDirectory.getAbsolutePath();
            }
            catch (Exception exception) {
                this._cwdStr = userHome;
            }
            this._status.setAttribute(4, this._cwdStr);
            boolean didLogin = false;
            String theShell = null;
            if (!this._isWindows) {
                ArrayList<String> argsList;
                File psuedoTerminal = new File(this.PSEUDO_TERMINAL);
                if (psuedoTerminal.exists()) {
                    this._isTTY = true;
                    this.PSEUDO_TERMINAL = psuedoTerminal.getAbsolutePath();
                } else {
                    this._isTTY = false;
                }
                this._patterns.setIsTerminal(this._isTTY);
                String property = "SHELL=";
                String[] env = this.getEnvironment(this._subject);
                boolean isBashonZ = false;
                boolean isSHonZ = false;
                int i = 0;
                while (i < env.length) {
                    String var = env[i];
                    if (var.startsWith(property)) {
                        theShell = var.substring(property.length(), var.length());
                        if (theShell.endsWith("bash")) {
                            if (isZ) {
                                isBashonZ = true;
                            } else {
                                isBash = true;
                            }
                        } else if (theShell.endsWith("sh") && isZ) {
                            isSHonZ = true;
                        }
                    }
                    if (this._dataStore.getClient() != null && var.startsWith("HOME")) {
                        env[i] = "HOME=" + this._dataStore.getClient().getProperty("user.home");
                    }
                    ++i;
                }
                String customShellInvocation = System.getProperty("DSTORE_SHELL_INVOCATION");
                if (customShellInvocation != null && customShellInvocation.length() > 0) {
                    theShell = customShellInvocation;
                }
                if (theShell == null) {
                    if (this._invocation.equals(">")) {
                        this._invocation = "sh";
                        this._isShell = true;
                        if (isZ) {
                            isSHonZ = true;
                        }
                    }
                    if (this._isTTY) {
                        if (isSHonZ) {
                            String[] args = new String[]{this.PSEUDO_TERMINAL, "sh", "-L"};
                            try {
                                this._theProcess = Runtime.getRuntime().exec(args, env, theDirectory);
                            }
                            catch (Exception exception) {
                                this._theProcess = Runtime.getRuntime().exec(this._invocation, env, theDirectory);
                            }
                            didLogin = true;
                        } else {
                            argsList = new ArrayList();
                            if (suCommand != null) {
                                String[] suSplit = suCommand.split(" ");
                                int i2 = 0;
                                while (i2 < suSplit.length) {
                                    argsList.add(suSplit[i2]);
                                    ++i2;
                                }
                            }
                            argsList.add(this.PSEUDO_TERMINAL);
                            argsList.add(invocation);
                            String[] args = argsList.toArray(new String[argsList.size()]);
                            this._theProcess = Runtime.getRuntime().exec(args, env, theDirectory);
                        }
                    } else {
                        if (suCommand != null) {
                            this._invocation = String.valueOf(suCommand) + this._invocation;
                        }
                        this._theProcess = Runtime.getRuntime().exec(this._invocation, env, theDirectory);
                    }
                } else if (this._invocation.equals(">")) {
                    this._invocation = theShell;
                    this._isShell = true;
                    if (this._isTTY) {
                        argsList = new ArrayList();
                        if (!isBashonZ && !isSHonZ && suCommand != null) {
                            String[] suArgs = suCommand.split(" ");
                            int i3 = 0;
                            while (i3 < suArgs.length) {
                                argsList.add(suArgs[i3]);
                                ++i3;
                            }
                        }
                        argsList.add(this.PSEUDO_TERMINAL);
                        if (!isBashonZ && !isSHonZ && suCommand != null) {
                            argsList.add("sh");
                            argsList.add("-c");
                        } else {
                            argsList.add("-w");
                            argsList.add("" + this._maxLineLength);
                        }
                        argsList.add(this._invocation);
                        if (isBashonZ) {
                            argsList.add("--login");
                            didLogin = true;
                        } else if (isBash) {
                            argsList.add("-l");
                            didLogin = true;
                        } else if (isSHonZ) {
                            argsList.add("-L");
                            didLogin = true;
                        }
                        String[] args = argsList.toArray(new String[argsList.size()]);
                        try {
                            this._theProcess = Runtime.getRuntime().exec(args, env, theDirectory);
                        }
                        catch (Exception exception) {
                            this._theProcess = Runtime.getRuntime().exec(this._invocation, env, theDirectory);
                        }
                    } else {
                        if (!isBashonZ && !isSHonZ && suCommand != null) {
                            this._invocation = String.valueOf(suCommand) + this._invocation;
                        }
                        if (customShellInvocation != null && customShellInvocation.length() > 0) {
                            this._theProcess = Runtime.getRuntime().exec(this._invocation, env, theDirectory);
                        } else if (isBashonZ) {
                            this._theProcess = Runtime.getRuntime().exec(String.valueOf(this._invocation) + " --login", env, theDirectory);
                            didLogin = true;
                        } else if (isBash) {
                            this._theProcess = Runtime.getRuntime().exec(String.valueOf(this._invocation) + " -l", env, theDirectory);
                            didLogin = true;
                        } else if (isSHonZ) {
                            this._theProcess = Runtime.getRuntime().exec(String.valueOf(this._invocation) + " -L", env, theDirectory);
                            didLogin = true;
                        } else {
                            this._theProcess = Runtime.getRuntime().exec(this._invocation, env, theDirectory);
                        }
                    }
                } else {
                    if (suCommand != null) {
                        theShell = String.valueOf(suCommand) + theShell;
                    }
                    argsList = new ArrayList<String>();
                    String[] shellArray = theShell.split(" ");
                    int i4 = 0;
                    while (i4 < shellArray.length) {
                        argsList.add(shellArray[i4]);
                        ++i4;
                    }
                    argsList.add("-c");
                    argsList.add(this._invocation);
                    String[] args = argsList.toArray(new String[argsList.size()]);
                    this._theProcess = Runtime.getRuntime().exec(args, env, theDirectory);
                }
            } else {
                theShell = theOS.indexOf("95") >= 0 || theOS.indexOf("98") >= 0 || theOS.indexOf("ME") >= 0 ? "start" : "cmd";
                if (this._invocation.equals(">")) {
                    this._invocation = theShell;
                    this._isShell = true;
                }
                String[] args = new String[]{theShell, theShell.equals("start") ? "/B " : "/C ", this._invocation};
                String[] env = this.getEnvironment(this._subject);
                this._theProcess = this._invocation.equals(theShell) ? Runtime.getRuntime().exec(this._invocation, env, theDirectory) : Runtime.getRuntime().exec(args, env, theDirectory);
            }
            OutputStream output = this._theProcess.getOutputStream();
            this._stdInput = new DataInputStream(this._theProcess.getInputStream());
            this._stdError = new DataInputStream(this._theProcess.getErrorStream());
            String specialEncoding = System.getProperty("dstore.stdin.encoding");
            if (specialEncoding != null) {
                try {
                    this._stdOutput = new BufferedWriter(new OutputStreamWriter(output, specialEncoding));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    this._stdOutput = new BufferedWriter(new OutputStreamWriter(output));
                }
            } else {
                this._stdOutput = new BufferedWriter(new OutputStreamWriter(output));
            }
            this.createObject("command", this._invocation);
            this.createObject("stdout", "");
            status.setAttribute(2, "progress");
            this._dataStore.update(status);
            this._dataStore.disconnectObjects(status);
            this._stdOutputHandler = new OutputHandler(this._stdInput, null, this._isWindows || this._isTTY, false, this._isShell, this);
            this._stdOutputHandler.setWaitTime(100);
            this._stdOutputHandler.setDataStore(this._dataStore);
            this._stdOutputHandler.start();
            this._stdErrorHandler = new OutputHandler(this._stdError, null, this._isWindows || this._isTTY, true, this._isShell, this);
            this._stdErrorHandler.setWaitTime(100);
            this._stdOutputHandler.setDataStore(this._dataStore);
            this._stdErrorHandler.start();
            if (didLogin || this._isTTY) {
                String initCmd = "";
                if (this._isTTY) {
                    initCmd = "export PS1='$PWD>';";
                }
                if (didLogin && !userHome.equals(this._cwdStr)) {
                    initCmd = String.valueOf(initCmd) + "cd " + this._cwdStr;
                }
                this._initRunnable = new InitRunnable(initCmd);
                this._cdThread = new Thread(this._initRunnable);
                this._cdThread.start();
            } else if (this._isShell && !this._isWindows && !this._isTTY) {
                this.createPrompt(String.valueOf(this._cwdStr) + ">", this._cwdStr);
                this.refreshStatus();
            }
        }
        catch (IOException e) {
            this._theProcess = null;
            this._dataStore.trace((Throwable)e);
            this.createObject("command", e.getMessage());
            status.setAttribute(2, "done");
            return;
        }
    }

    public Process getProcess() {
        return this._theProcess;
    }

    public String getCWD() {
        return this._cwdStr;
    }

    public void queryCWD() {
        BufferedWriter writer = this._stdOutput;
        try {
            writer.write("echo '<'PWD=$PWD");
            writer.newLine();
            writer.flush();
        }
        catch (Exception exception) {}
        this._didInitialCWDQuery = true;
    }

    public void sendInput(String input) {
        if (!this._isDone) {
            if (this._initRunnable != null && !this._initRunnable.isDone()) {
                try {
                    this._cdThread.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            String origInput = input;
            input.getBytes();
            try {
                BufferedWriter writer = this._stdOutput;
                if (input.equals("#break") && !this._isTTY) {
                    this._theProcess.destroy();
                    return;
                }
                if (input.equals("#enter")) {
                    writer.newLine();
                    writer.flush();
                    return;
                }
                if (this._isShell) {
                    String promptText;
                    if (this._lastPrompt != null && !this._isTTY && (promptText = this._lastPrompt.getName()).endsWith(">")) {
                        this._lastPrompt.setAttribute(2, String.valueOf(promptText) + input);
                        this._dataStore.refresh(this._lastPrompt);
                    }
                    this._patterns.update(input);
                }
                if (!this._isWindows && !this._isTTY) {
                    this.createObject("input", origInput);
                }
                writer.write(input);
                writer.newLine();
                try {
                    writer.flush();
                }
                catch (Exception exception) {}
                if (!this._isWindows && (input.startsWith("cd ") || input.equals("cd"))) {
                    if (!this._isTTY) {
                        this.queryCWD();
                    }
                } else if (!this._didInitialCWDQuery && !this._isTTY) {
                    this.queryCWD();
                }
                if (!this._isWindows && !this._isTTY) {
                    writer.write("echo $PWD'>'");
                    writer.newLine();
                    writer.flush();
                }
            }
            catch (IOException iOException) {
                this.cleanupThread();
            }
        }
    }

    private String[] getEnvironment(DataElement theSubject) {
        DataElement envMiner = this._dataStore.findMinerInformation("org.eclipse.rse.dstore.universal.miners.EnvironmentMiner");
        DataElement systemEnv = this._dataStore.find(envMiner, 2, "System Environment", 1);
        DataElement theProject = theSubject;
        List projectEnvReference = null;
        while (theProject != null && !theProject.getValue().equals("Data")) {
            projectEnvReference = theProject.getAssociated("inhabits");
            if (projectEnvReference.size() > 0) break;
            theProject = theProject.getParent();
        }
        DataElement projectEnv = null;
        if (projectEnvReference != null && projectEnvReference.size() > 0) {
            projectEnv = (DataElement)projectEnvReference.get(0);
        }
        String[] theEnv = this.mergeEnvironments(systemEnv, projectEnv);
        return theEnv;
    }

    private String[] mergeEnvironments(DataElement systemEnv, DataElement projectEnv) {
        String theOS;
        List prjVars = null;
        List sysVars = null;
        if (systemEnv != null) {
            sysVars = systemEnv.getNestedData();
        }
        if (projectEnv != null) {
            prjVars = projectEnv.getNestedData();
        }
        if (sysVars == null || sysVars.size() == 0) {
            return this.listToArray(prjVars);
        }
        if (prjVars == null || prjVars.size() == 0) {
            return this.listToArray(sysVars);
        }
        Hashtable<String, String> varTable = new Hashtable<String, String>();
        varTable.putAll(this.mapVars(sysVars));
        int i = 0;
        while (i < prjVars.size()) {
            DataElement envElement = (DataElement)prjVars.get(i);
            if (envElement.getType().equals("Environment Variable")) {
                String theVariable = envElement.getValue();
                String theKey = this.getKey(theVariable);
                String theValue = this.getValue(theVariable);
                theValue = this.calculateValue(theValue, varTable);
                varTable.put(theKey, theValue);
            }
            ++i;
        }
        if (this._isTTY) {
            varTable.put("PS1", "'$PWD/>'");
            varTable.put("COLUMNS", "" + this._maxLineLength);
        }
        if ((theOS = System.getProperty("os.name")).toLowerCase().startsWith("os")) {
            varTable.put("QIBM_JAVA_STDIO_CONVERT", "Y");
            varTable.put("QIBM_USE_DESCRIPTOR_STDIO", "I");
            varTable.put("PASE_STDIO_ISATTY", "N");
            varTable.put("TERMINAL_TYPE", "REMOTE");
            varTable.put("STDIO_ISATTY", "Y");
        }
        return this.tableToArray(varTable);
    }

    private String calculateValue(String value, Hashtable theTable) {
        value = value.replaceAll("}", "\n}");
        StringBuffer theValue = new StringBuffer(value);
        try {
            int index = 0;
            while (index < theValue.length()) {
                char c = theValue.charAt(index);
                if (c == '{') {
                    c = theValue.charAt(++index);
                    while (index < theValue.length() && c != '}') {
                        c = theValue.charAt(++index);
                    }
                } else if (c == '$' && !this._isWindows) {
                    int nextIndex = index + 1;
                    if (nextIndex < theValue.length()) {
                        String replacementValue;
                        c = theValue.charAt(nextIndex);
                        if (c == '{') {
                            int next = theValue.toString().indexOf("}", nextIndex);
                            if (next > 0) {
                                replacementValue = this.findValue(theValue.substring(nextIndex + 1, next), theTable, true);
                                theValue.replace(index, next + 1, replacementValue);
                                index += replacementValue.length() - 1;
                            }
                        } else if (Character.isJavaIdentifierStart(c)) {
                            while (nextIndex + 1 < theValue.length() && Character.isJavaIdentifierPart(c)) {
                                c = theValue.charAt(++nextIndex);
                                if (nextIndex + 1 != theValue.length() || !Character.isJavaIdentifierPart(c)) continue;
                                ++nextIndex;
                            }
                            String v = theValue.substring(index + 1, nextIndex);
                            replacementValue = this.findValue(v, theTable, true);
                            theValue.replace(index, nextIndex, replacementValue);
                            index += replacementValue.length() - 1;
                        }
                    }
                } else if (c == '%' && this._isWindows) {
                    int next = theValue.toString().indexOf("%", index + 1);
                    if (next > 0) {
                        String replacementValue = this.findValue(theValue.substring(index + 1, next), theTable, false);
                        theValue.replace(index, next + 1, replacementValue);
                        index += replacementValue.length() - 1;
                    }
                } else if (c == '\"') {
                    c = theValue.charAt(++index);
                    while (index < theValue.length() && c != '\"') {
                        c = theValue.charAt(++index);
                    }
                }
                ++index;
            }
        }
        catch (Throwable e) {
            this._dataStore.trace(e);
        }
        return theValue.toString();
    }

    private String findValue(String key, Hashtable theTable, boolean caseSensitive) {
        Object theValue = null;
        if (caseSensitive) {
            theValue = theTable.get(key);
        } else {
            String matchString = key.toUpperCase();
            Enumeration e = theTable.keys();
            while (e.hasMoreElements()) {
                String theKey = (String)e.nextElement();
                if (!matchString.equals(theKey.toUpperCase())) continue;
                theValue = theTable.get(theKey);
            }
        }
        if (theValue == null) {
            return "";
        }
        return theValue;
    }

    private String getKey(String var) {
        int index = var.indexOf("=");
        if (index < 0) {
            return var;
        }
        return var.substring(0, index);
    }

    private String getValue(String var) {
        var = var.replaceAll("}", "\n}");
        int index = var.indexOf("=") + 1;
        int varLength = var.length();
        if (index < 1 || index == var.length()) {
            return "";
        }
        return var.substring(index, varLength);
    }

    private Hashtable mapVars(List theVars) {
        Hashtable<String, String> theTable = new Hashtable<String, String>();
        int theSize = theVars.size();
        int i = 0;
        while (i < theSize) {
            String theVar = ((DataElement)theVars.get(i)).getValue();
            theTable.put(this.getKey(theVar), this.getValue(theVar));
            ++i;
        }
        return theTable;
    }

    private String[] listToArray(List theList) {
        if (theList == null) {
            theList = new ArrayList();
        }
        int theSize = theList.size();
        String[] theArray = new String[theSize];
        int i = 0;
        while (i < theSize) {
            theArray[i] = ((DataElement)theList.get(i)).getValue();
            ++i;
        }
        return theArray;
    }

    private String[] tableToArray(Hashtable theTable) {
        if (theTable == null) {
            theTable = new Hashtable();
        }
        int theSize = theTable.size();
        String[] theArray = new String[theSize];
        int i = 0;
        Enumeration e = theTable.keys();
        while (e.hasMoreElements()) {
            String theKey = (String)e.nextElement();
            String theValue = (String)theTable.get(theKey);
            theArray[i++] = String.valueOf(theKey) + "=" + theValue;
        }
        return theArray;
    }

    public boolean doThreadedWork() {
        return this._stdOutputHandler != null && !this._stdOutputHandler.isFinished() || this._stdErrorHandler != null && !this._stdErrorHandler.isFinished();
    }

    public void initializeThread() {
    }

    public void sendExit() {
        if (this._isShell) {
            this.sendInput("exit");
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
            if (this._stdOutputHandler.isAlive() && this._theProcess != null) {
                this._theProcess.destroy();
            }
        }
    }

    public void cleanupThread() {
        this._isDone = true;
        try {
            if (this._theProcess != null) {
                int exitcode;
                try {
                    if (this._isCancelled) {
                        this._theProcess.destroy();
                    } else {
                        exitcode = this._theProcess.exitValue();
                        this.createObject("prompt", "> Shell Completed (exit code = " + exitcode + ")");
                    }
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    exitcode = -1;
                    this._theProcess.destroy();
                }
                this._theProcess = null;
            }
            this._stdOutputHandler.finish();
            this._stdErrorHandler.finish();
            this._stdInput.close();
            this._stdError.close();
            this._status.setAttribute(2, "done");
            this._dataStore.refresh(this._status);
            this._dataStore.disconnectObjects(this._status);
            List projectEnvReference = this._subject.getAssociated("inhabits");
            if (projectEnvReference != null && projectEnvReference.size() > 0) {
                DataElement env = (DataElement)projectEnvReference.get(0);
                DataElement envParent = env.getParent();
                this._dataStore.deleteObject(envParent, env);
                this._dataStore.refresh(envParent);
            }
            this._dataStore.disconnectObject(this._subject);
        }
        catch (IOException e) {
            this._dataStore.trace((Throwable)e);
        }
    }

    public void interpretLine(String line, boolean stdError) {
        int num = line.length();
        String[] lines = new String[num / this._maxLineLength + 1];
        if (lines.length > 1) {
            int beg = 0;
            int end = this._maxLineLength;
            int i = 0;
            while (i < lines.length) {
                lines[i] = end > line.length() ? line.substring(beg) : line.substring(beg, end);
                beg = end;
                end += this._maxLineLength;
                ++i;
            }
        } else {
            lines[0] = line;
        }
        int i = 0;
        while (i < lines.length) {
            line = lines[i];
            if (line.startsWith("<PWD")) {
                String statement = line.substring(1);
                String[] pair = statement.split("=");
                String value = pair[1];
                this._status.setAttribute(4, value);
                return;
            }
            if (line.indexOf("echo '<'PWD=$PWD") <= 0 && line.indexOf("PS1='$PWD>';") <= 0) {
                ParsedOutput parsedMsg = null;
                try {
                    parsedMsg = this._patterns.matchLine(this.removeWhitespace(line));
                }
                catch (Throwable e) {
                    this._dataStore.trace(e);
                }
                if (parsedMsg == null) {
                    if (stdError) {
                        this.createObject(this._descriptors._stderr, line);
                    } else {
                        this.createObject(this._descriptors._stdout, line);
                    }
                } else {
                    try {
                        String fileName = parsedMsg.file;
                        if (parsedMsg.type.equals("prompt")) {
                            File promptFile;
                            int tildaIndex = fileName.indexOf("~");
                            if (tildaIndex == 0) {
                                String userHome = null;
                                userHome = this._dataStore.getClient() != null ? this._dataStore.getClient().getProperty("user.home") : System.getProperty("user.home");
                                fileName = String.valueOf(userHome) + fileName.substring(1);
                            }
                            if ((promptFile = new File(fileName)).exists()) {
                                this.createPrompt(line, fileName);
                            } else {
                                this.createObject(this._descriptors._stdout, line);
                            }
                        } else if (parsedMsg.type.equals("file")) {
                            this.createObject(parsedMsg.type, line, fileName, null);
                        } else {
                            this.createObject(parsedMsg.type, line, fileName, new Integer(parsedMsg.line));
                        }
                    }
                    catch (NumberFormatException e) {
                        this._dataStore.trace((Throwable)e);
                    }
                }
            }
            ++i;
        }
    }

    public void refreshStatus() {
        this._dataStore.refresh(this._status);
    }

    public void createPrompt(String line, String fileName) {
        DataElement lastObject;
        DataElement object = null;
        int size = this._status.getNestedSize();
        if (size > 0 && !(lastObject = this._status.get(size - 1)).getType().equals("prompt")) {
            line = line.replaceAll("//", "/");
            fileName = fileName.replaceAll("//", "/");
            this._lastPrompt = object = this.createObject("prompt", line, fileName, null);
            this._cwdStr = object.getSource();
            this._status.setAttribute(4, fileName);
        }
    }

    public String removeWhitespace(String theLine) {
        StringBuffer strippedLine = new StringBuffer();
        boolean inWhitespace = true;
        int i = 0;
        while (i < theLine.length()) {
            char curChar = theLine.charAt(i);
            if (curChar == '\t') {
                if (!inWhitespace) {
                    strippedLine.append(' ');
                    inWhitespace = true;
                }
            } else if (curChar == ' ') {
                if (!inWhitespace) {
                    strippedLine.append(' ');
                    inWhitespace = true;
                }
            } else {
                strippedLine.append(curChar);
                inWhitespace = false;
            }
            ++i;
        }
        return strippedLine.toString();
    }

    public DataElement createObject(String type, String text) {
        DataElement newObj = null;
        DataElement descriptorType = this._descriptors.getDescriptorFor(type);
        newObj = descriptorType != null ? this._dataStore.createObject(this._status, descriptorType, text, "") : this._dataStore.createObject(this._status, type, text, "");
        return newObj;
    }

    public DataElement createObject(DataElement type, String text) {
        return this._dataStore.createObject(this._status, type, text, "");
    }

    private DataElement createObject(String type, String text, String file, Integer line) {
        DataElement descriptorType = null;
        if (file != null && file.length() > 0) {
            boolean foundFile = false;
            String expectedPath = null;
            File aFile = new File(file);
            if (type.equals("prompt")) {
                descriptorType = this._descriptors._prompt;
                expectedPath = file;
                this._cwdStr = file.replaceAll("//", "/");
            } else if (aFile.exists()) {
                file = expectedPath = aFile.getAbsolutePath();
                if (aFile.isDirectory() && type.equals("file")) {
                    type = "directory";
                }
                foundFile = true;
            } else {
                expectedPath = this._cwdStr.endsWith("/") ? (file.equals("/") ? this._cwdStr : String.valueOf(this._cwdStr) + file) : String.valueOf(this._cwdStr) + "/" + file;
            }
            if (!foundFile) {
                File qfile = new File(expectedPath);
                if (!qfile.exists()) {
                    expectedPath = file;
                    qfile = new File(expectedPath);
                    if (qfile.exists()) {
                        if (qfile.isDirectory() && type.equals("file")) {
                            type = "directory";
                        }
                    } else {
                        File cwdFile = new File(this._cwdStr);
                        String cwdParent = cwdFile.getAbsolutePath();
                        if (cwdFile.getParent() != null) {
                            cwdParent = cwdFile.getParentFile().getAbsolutePath();
                        }
                        if ((qfile = new File(expectedPath = cwdParent.endsWith("/") ? String.valueOf(cwdParent) + file : String.valueOf(cwdParent) + "/" + file)).exists()) {
                            if (qfile.isDirectory() && type.equals("file")) {
                                type = "directory";
                            }
                            file = expectedPath;
                        } else if (type.equals("file")) {
                            type = "stdout";
                            descriptorType = this._descriptors._stdout;
                        } else if (type.equals("error")) {
                            type = "stderr";
                            descriptorType = this._descriptors._stderr;
                        } else {
                            type = "stdout";
                            descriptorType = this._descriptors._stdout;
                        }
                    }
                } else {
                    if (qfile.isDirectory() && type.equals("file")) {
                        type = "directory";
                        expectedPath = expectedPath.replaceAll("//", "/");
                    }
                    file = expectedPath;
                }
            }
            DataElement obj = null;
            if (line == null || line == 1) {
                obj = descriptorType != null ? this._dataStore.createObject(this._status, descriptorType, text, file) : this._dataStore.createObject(this._status, type, text, file);
            } else {
                obj = descriptorType != null ? this._dataStore.createObject(this._status, descriptorType, text, file) : this._dataStore.createObject(this._status, type, text, file);
                obj.setAttribute(4, String.valueOf(obj.getSource()) + ':' + line.toString());
            }
            return obj;
        }
        return this.createObject(type, text);
    }

    class InitRunnable
    implements Runnable {
        private boolean _done = false;
        private String _initCmd;

        public InitRunnable(String command) {
            this._initCmd = command;
        }

        public boolean isDone() {
            return this._done;
        }

        public void run() {
            try {
                CommandMinerThread.sleep((long)1000L);
            }
            catch (Exception exception) {}
            this._done = true;
            CommandMinerThread.this.sendInput(this._initCmd);
        }
    }
}

