/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.dom.lrparser.action.gnu;

import java.util.List;
import lpg.lpgjavaruntime.IToken;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPointer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTPointerToMember;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.IGPPASTExplicitTemplateInstantiation;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.IGPPASTPointer;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.IGPPASTPointerToMember;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.IGPPASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.lrparser.action.ITokenMap;
import org.eclipse.cdt.core.dom.lrparser.action.ITokenStream;
import org.eclipse.cdt.core.dom.lrparser.action.ParserUtil;
import org.eclipse.cdt.core.dom.lrparser.action.ScopedStack;
import org.eclipse.cdt.core.dom.lrparser.action.TokenMap;
import org.eclipse.cdt.core.dom.lrparser.action.cpp.CPPBuildASTParserAction;
import org.eclipse.cdt.core.dom.lrparser.action.cpp.ICPPNodeFactory;
import org.eclipse.cdt.core.dom.lrparser.action.cpp.ICPPSecondaryParserFactory;
import org.eclipse.cdt.core.parser.util.CollectionUtils;
import org.eclipse.cdt.internal.core.dom.lrparser.gpp.GPPParsersym;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GPPBuildASTParserAction
extends CPPBuildASTParserAction {
    private final ICPPNodeFactory nodeFactory;
    private final ITokenMap gppTokenMap;

    public GPPBuildASTParserAction(ITokenStream stream, ScopedStack<Object> astStack, ICPPNodeFactory nodeFactory, ICPPSecondaryParserFactory parserFactory) {
        super(stream, astStack, nodeFactory, parserFactory);
        this.nodeFactory = nodeFactory;
        this.gppTokenMap = new TokenMap(GPPParsersym.orderedTerminalSymbols, stream.getOrderedTerminalSymbols());
    }

    public void consumeDeclarationSpecifiersTypeof() {
        List topScope = this.astStack.closeScope();
        IASTExpression expr = (IASTExpression)CollectionUtils.findFirstAndRemove(topScope, IASTExpression.class);
        IGPPASTSimpleDeclSpecifier declSpec = this.nodeFactory.newSimpleDeclSpecifierGPP();
        declSpec.setTypeofExpression(expr);
        for (Object token : topScope) {
            this.setSpecifier((ICPPASTDeclSpecifier)declSpec, token);
        }
        this.setOffsetAndLength((IASTNode)declSpec);
        this.astStack.push(declSpec);
    }

    @Override
    public void consumeDeclarationSpecifiersSimple() {
        ICPPASTSimpleDeclSpecifier declSpec;
        boolean isComplex = false;
        boolean isImaginary = false;
        int numLong = 0;
        List tokens = this.astStack.closeScope();
        for (Object o : tokens) {
            if (!(o instanceof IToken)) continue;
            IToken token = (IToken)o;
            switch (this.gppTokenMap.mapKind(token.getKind())) {
                case 14: {
                    isComplex = true;
                    break;
                }
                case 15: {
                    isImaginary = true;
                    break;
                }
                case 21: {
                    ++numLong;
                }
            }
        }
        if (isComplex || isImaginary || numLong > 1) {
            IGPPASTSimpleDeclSpecifier gppDeclSpec = this.nodeFactory.newSimpleDeclSpecifierGPP();
            gppDeclSpec.setComplex(isComplex);
            gppDeclSpec.setImaginary(isImaginary);
            gppDeclSpec.setLongLong(numLong > 1);
            gppDeclSpec.setLong(numLong == 1);
            declSpec = gppDeclSpec;
        } else {
            declSpec = this.nodeFactory.newSimpleDeclSpecifier();
        }
        for (Object token : tokens) {
            this.setSpecifier((ICPPASTDeclSpecifier)declSpec, token);
        }
        this.setOffsetAndLength((IASTNode)declSpec);
        this.astStack.push(declSpec);
    }

    private boolean hasRestrict(List<Object> tokens) {
        for (Object o : tokens) {
            IToken t = (IToken)o;
            if (this.gppTokenMap.mapKind(t.getKind()) != 30) continue;
            return true;
        }
        return false;
    }

    @Override
    public void consumePointer() {
        boolean hasRestrict = this.hasRestrict(this.astStack.topScope());
        super.consumePointer();
        if (hasRestrict) {
            IGPPASTPointer gppPointer = this.nodeFactory.newPointerGPP();
            GPPBuildASTParserAction.initializeGPPPointer((IASTPointer)this.astStack.pop(), gppPointer);
            this.astStack.push(gppPointer);
        }
    }

    private static void initializeGPPPointer(IASTPointer pointer, IGPPASTPointer gppPointer) {
        gppPointer.setConst(pointer.isConst());
        gppPointer.setVolatile(pointer.isVolatile());
        gppPointer.setRestrict(true);
        ParserUtil.setOffsetAndLength((IASTNode)gppPointer, (IASTNode)pointer);
    }

    @Override
    public void consumePointerToMember() {
        boolean hasRestrict = this.hasRestrict(this.astStack.topScope());
        super.consumePointerToMember();
        if (hasRestrict) {
            ICPPASTPointerToMember pointer = (ICPPASTPointerToMember)this.astStack.pop();
            IGPPASTPointerToMember gppPointer = this.nodeFactory.newPointerToMemberGPP(pointer.getName());
            GPPBuildASTParserAction.initializeGPPPointer((IASTPointer)pointer, (IGPPASTPointer)gppPointer);
            this.astStack.push(gppPointer);
        }
    }

    public void consumeTemplateExplicitInstantiationGCC(int modifier) {
        IASTDeclaration declaration = (IASTDeclaration)this.astStack.pop();
        IGPPASTExplicitTemplateInstantiation instantiation = this.nodeFactory.newExplicitTemplateInstantiationGPP(declaration);
        instantiation.setModifier(modifier);
        this.setOffsetAndLength((IASTNode)instantiation);
        this.astStack.push(instantiation);
    }
}

