/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser;

import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTCastExpression;
import org.eclipse.cdt.core.dom.ast.IASTConditionalExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionList;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguousExpression;

public class ASTQueries {
    public static boolean canContainName(IASTExpression expr) {
        if (expr == null || expr instanceof IASTLiteralExpression) {
            return false;
        }
        if (expr instanceof IASTAmbiguousExpression) {
            return true;
        }
        if (expr instanceof IASTIdExpression) {
            return true;
        }
        if (expr instanceof IASTCastExpression) {
            return true;
        }
        if (expr instanceof IASTUnaryExpression) {
            IASTUnaryExpression uexpr = (IASTUnaryExpression)expr;
            return ASTQueries.canContainName(uexpr.getOperand());
        }
        if (expr instanceof IASTBinaryExpression) {
            IASTBinaryExpression bexpr = (IASTBinaryExpression)expr;
            return ASTQueries.canContainName(bexpr.getOperand1()) || ASTQueries.canContainName(bexpr.getOperand2());
        }
        if (expr instanceof IASTConditionalExpression) {
            IASTConditionalExpression cexpr = (IASTConditionalExpression)expr;
            return ASTQueries.canContainName(cexpr.getLogicalConditionExpression()) || ASTQueries.canContainName(cexpr.getPositiveResultExpression()) || ASTQueries.canContainName(cexpr.getNegativeResultExpression());
        }
        if (expr instanceof IASTExpressionList) {
            IASTExpression[] subexprs;
            IASTExpressionList lexpr = (IASTExpressionList)expr;
            IASTExpression[] iASTExpressionArray = subexprs = lexpr.getExpressions();
            int n = subexprs.length;
            int n2 = 0;
            while (n2 < n) {
                IASTExpression subexpr = iASTExpressionArray[n2];
                if (ASTQueries.canContainName(subexpr)) {
                    return true;
                }
                ++n2;
            }
        }
        return true;
    }
}

