/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.remotetools.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionChangeEvent;
import org.eclipse.ptp.remote.core.IRemoteConnectionChangeListener;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.exception.AddressInUseException;
import org.eclipse.ptp.remote.core.exception.RemoteConnectionException;
import org.eclipse.ptp.remote.core.exception.UnableToForwardPortException;
import org.eclipse.ptp.remote.remotetools.core.environment.PTPTargetControl;
import org.eclipse.ptp.remote.remotetools.core.messages.Messages;
import org.eclipse.ptp.remotetools.core.IPortForwarding;
import org.eclipse.ptp.remotetools.core.IRemoteExecutionManager;
import org.eclipse.ptp.remotetools.core.IRemotePortForwarding;
import org.eclipse.ptp.remotetools.environment.core.ITargetElement;
import org.eclipse.ptp.remotetools.exception.CancelException;
import org.eclipse.ptp.remotetools.exception.LocalPortBoundException;
import org.eclipse.ptp.remotetools.exception.PortForwardingException;
import org.eclipse.ptp.remotetools.exception.RemoteExecutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteToolsConnection
implements IRemoteConnection {
    private final String fConnName;
    private String fAddress;
    private String fUserName;
    private String fWorkingDir = null;
    private Map<String, String> fEnv = null;
    private Map<String, String> fProperties = null;
    private final IRemoteServices fRemoteServices;
    private final ITargetElement fTargetElement;
    private final PTPTargetControl fTargetControl;
    private final ListenerList fListeners = new ListenerList();

    public RemoteToolsConnection(String name, String address, String userName, ITargetElement element, IRemoteServices services) throws CoreException {
        this.fTargetElement = element;
        this.fTargetControl = (PTPTargetControl)element.getControl();
        this.fConnName = name;
        this.fAddress = address;
        this.fUserName = userName;
        this.fRemoteServices = services;
    }

    public void addConnectionChangeListener(IRemoteConnectionChangeListener listener) {
        this.fListeners.add((Object)listener);
    }

    public synchronized void close() {
        NullProgressMonitor monitor = new NullProgressMonitor();
        monitor.beginTask(Messages.RemoteToolsConnection_close, 1);
        if (this.isOpen()) {
            try {
                this.fTargetControl.kill((IProgressMonitor)monitor);
            }
            catch (CoreException coreException) {}
        }
        monitor.done();
    }

    public IRemoteExecutionManager createExecutionManager() throws org.eclipse.ptp.remotetools.exception.RemoteConnectionException {
        return this.fTargetControl.createExecutionManager();
    }

    public void fireConnectionChangeEvent(final IRemoteConnection connection, final int type) {
        if (connection == this && type == -1) {
            this.fTargetElement.getType().removeElement(this.fTargetElement);
            this.fListeners.clear();
        } else {
            IRemoteConnectionChangeEvent event = new IRemoteConnectionChangeEvent(){

                public IRemoteConnection getConnection() {
                    return connection;
                }

                public int getType() {
                    return type;
                }
            };
            Object[] objectArray = this.fListeners.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                ((IRemoteConnectionChangeListener)listener).connectionChanged(event);
                ++n2;
            }
        }
    }

    public void forwardLocalPort(int localPort, String fwdAddress, int fwdPort) throws RemoteConnectionException {
        if (!this.isOpen()) {
            throw new RemoteConnectionException(Messages.RemoteToolsConnection_connectionNotOpen);
        }
        try {
            this.fTargetControl.getExecutionManager().createTunnel(localPort, fwdAddress, fwdPort);
        }
        catch (LocalPortBoundException e) {
            throw new AddressInUseException(e.getMessage());
        }
        catch (org.eclipse.ptp.remotetools.exception.RemoteConnectionException e) {
            throw new RemoteConnectionException(e.getMessage());
        }
        catch (CancelException e) {
            throw new RemoteConnectionException(e.getMessage());
        }
    }

    public int forwardLocalPort(String fwdAddress, int fwdPort, IProgressMonitor monitor) throws RemoteConnectionException {
        if (!this.isOpen()) {
            throw new RemoteConnectionException(Messages.RemoteToolsConnection_connectionNotOpen);
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            progress.beginTask(Messages.RemoteToolsConnection_forwarding, 10);
            int localPort = fwdPort + 1;
            if (!progress.isCanceled()) {
                try {
                    this.forwardLocalPort(localPort, fwdAddress, fwdPort);
                }
                catch (AddressInUseException addressInUseException) {
                    if (++localPort == fwdPort) {
                        throw new UnableToForwardPortException(Messages.RemoteToolsConnection_remotePort);
                    }
                    progress.worked(1);
                }
                int n = localPort;
                return n;
            }
            return -1;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public void forwardRemotePort(int remotePort, String fwdAddress, int fwdPort) throws RemoteConnectionException {
        if (!this.isOpen()) {
            throw new RemoteConnectionException(Messages.RemoteToolsConnection_connectionNotOpen);
        }
        if (fwdPort == -1) {
            try {
                IRemotePortForwarding portForwarding = this.fTargetControl.getExecutionManager().getPortForwardingTools().getRemotePortForwarding(remotePort);
                this.fTargetControl.getExecutionManager().getPortForwardingTools().releaseForwarding((IPortForwarding)portForwarding);
            }
            catch (Exception e) {
                throw new RemoteConnectionException(e.getMessage());
            }
        }
        try {
            this.fTargetControl.getExecutionManager().getPortForwardingTools().forwardRemotePort(remotePort, fwdAddress, fwdPort);
        }
        catch (org.eclipse.ptp.remotetools.exception.RemoteConnectionException e) {
            throw new RemoteConnectionException(e.getMessage());
        }
        catch (CancelException e) {
            throw new RemoteConnectionException(e.getMessage());
        }
        catch (PortForwardingException e) {
            throw new AddressInUseException(e.getMessage());
        }
    }

    public int forwardRemotePort(String fwdAddress, int fwdPort, IProgressMonitor monitor) throws RemoteConnectionException {
        if (!this.isOpen()) {
            throw new RemoteConnectionException(Messages.RemoteToolsConnection_connectionNotOpen);
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            progress.beginTask(Messages.RemoteToolsConnection_forwarding, 10);
            int remotePort = fwdPort + 1;
            if (!progress.isCanceled()) {
                try {
                    this.forwardRemotePort(remotePort, fwdAddress, fwdPort);
                }
                catch (AddressInUseException addressInUseException) {
                    if (++remotePort == fwdPort) {
                        throw new UnableToForwardPortException(Messages.RemoteToolsConnection_remotePort);
                    }
                    progress.worked(1);
                }
                int n = remotePort;
                return n;
            }
            return -1;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public String getAddress() {
        return this.fAddress;
    }

    public Map<String, String> getAttributes() {
        return this.fTargetControl.getAttributes();
    }

    public Map<String, String> getEnv() {
        if (this.fEnv == null) {
            this.fEnv = new HashMap<String, String>();
            IRemoteExecutionManager exeMgr = null;
            try {
                exeMgr = this.createExecutionManager();
            }
            catch (org.eclipse.ptp.remotetools.exception.RemoteConnectionException remoteConnectionException) {}
            if (exeMgr != null) {
                try {
                    String[] vars;
                    String env = exeMgr.getExecutionTools().executeWithOutput("printenv").trim();
                    String[] stringArray = vars = env.split("\n");
                    int n = vars.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String var = stringArray[n2];
                        String[] kv = var.split("=");
                        if (kv.length == 2) {
                            this.fEnv.put(kv[0], kv[1]);
                        }
                        ++n2;
                    }
                }
                catch (RemoteExecutionException remoteExecutionException) {
                }
                catch (org.eclipse.ptp.remotetools.exception.RemoteConnectionException remoteConnectionException) {
                }
                catch (CancelException cancelException) {}
            }
        }
        return Collections.unmodifiableMap(this.fEnv);
    }

    public String getEnv(String name) {
        this.getEnv();
        return this.fEnv.get(name);
    }

    public String getName() {
        return this.fConnName;
    }

    public String getProperty(String key) {
        this.loadProperties();
        return this.fProperties.get(key);
    }

    public IRemoteServices getRemoteServices() {
        return this.fRemoteServices;
    }

    public String getUsername() {
        return this.fUserName;
    }

    public String getWorkingDirectory() {
        if (!this.isOpen()) {
            return "/";
        }
        if (this.fWorkingDir == null) {
            this.fWorkingDir = this.getPwd();
            if (this.fWorkingDir == null) {
                return "/";
            }
        }
        return this.fWorkingDir;
    }

    private String getPwd() {
        IRemoteExecutionManager exeMgr = null;
        try {
            exeMgr = this.createExecutionManager();
        }
        catch (org.eclipse.ptp.remotetools.exception.RemoteConnectionException remoteConnectionException) {}
        if (exeMgr != null) {
            try {
                return exeMgr.getExecutionTools().executeWithOutput("pwd").trim();
            }
            catch (RemoteExecutionException remoteExecutionException) {
            }
            catch (org.eclipse.ptp.remotetools.exception.RemoteConnectionException remoteConnectionException) {
            }
            catch (CancelException cancelException) {}
        }
        return null;
    }

    public synchronized boolean isOpen() {
        return this.fTargetControl.query() == 2;
    }

    public void open(IProgressMonitor monitor) throws RemoteConnectionException {
        block6: {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
            try {
                if (this.isOpen()) break block6;
                progress.beginTask(Messages.RemoteToolsConnection_open, 2);
                try {
                    this.fTargetControl.create((IProgressMonitor)progress.newChild(1));
                }
                catch (CoreException e) {
                    throw new RemoteConnectionException(e.getMessage());
                }
            }
            finally {
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
    }

    public void removeConnectionChangeListener(IRemoteConnectionChangeListener listener) {
        this.fListeners.remove((Object)listener);
    }

    public void setAddress(String address) {
        this.fAddress = address;
    }

    public void setName(String name) {
        this.fTargetElement.setName(name);
        this.fireConnectionChangeEvent(this, 8);
    }

    public void setUsername(String userName) {
        this.fUserName = userName;
    }

    public void setWorkingDirectory(String path) {
        if (new Path(path).isAbsolute()) {
            this.fWorkingDir = path;
        }
    }

    public boolean supportsTCPPortForwarding() {
        return true;
    }

    private void loadProperties() {
        if (this.fProperties == null) {
            this.fProperties = new HashMap<String, String>();
            this.fProperties.put("file.separator", "/");
            this.fProperties.put("path.separator", ":");
            this.fProperties.put("line.separator", "\n");
            this.fProperties.put("user.home", this.getPwd());
            try {
                IRemoteExecutionManager exeMgr = this.createExecutionManager();
                if (exeMgr != null) {
                    String osVersion;
                    String osArch = exeMgr.getExecutionTools().executeWithOutput("uname -m").trim();
                    String osName = exeMgr.getExecutionTools().executeWithOutput("uname").trim();
                    if (osName.equalsIgnoreCase("Darwin")) {
                        String opt;
                        osName = exeMgr.getExecutionTools().executeWithOutput("sw_vers -productName").trim();
                        osVersion = exeMgr.getExecutionTools().executeWithOutput("sw_vers -productVersion").trim();
                        if (osArch.equalsIgnoreCase("i386") && (opt = exeMgr.getExecutionTools().executeWithOutput("sysctl -n hw.optional.x86_64").trim()).equals("1")) {
                            osArch = "x86_64";
                        }
                    } else {
                        osVersion = exeMgr.getExecutionTools().executeWithOutput("uname -r").trim();
                    }
                    this.fProperties.put("os.name", osName);
                    this.fProperties.put("os.version", osVersion);
                    this.fProperties.put("os.arch", osArch);
                }
            }
            catch (RemoteExecutionException remoteExecutionException) {
            }
            catch (org.eclipse.ptp.remotetools.exception.RemoteConnectionException remoteConnectionException) {
            }
            catch (CancelException cancelException) {}
        }
    }
}

