/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.core.elements.attributes;

import java.util.BitSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.utils.core.DisjointBitSets;
import org.eclipse.ptp.utils.core.ICopier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeIndexSet<A extends IAttribute<?, A, ?>>
implements Iterable<DisjointBitSets.Entry<A>> {
    private final DisjointBitSets<A> disjointBitSets;

    public AttributeIndexSet() {
        this.disjointBitSets = new DisjointBitSets(new ICopier<A>(){

            public A copy(A attr) {
                return attr.copy();
            }
        });
    }

    public AttributeIndexSet(AttributeIndexSet<A> other) {
        this.disjointBitSets = other.disjointBitSets.copy();
    }

    public AttributeIndexSet(int nIndices) {
        this.disjointBitSets = new DisjointBitSets(nIndices, new ICopier<A>(){

            public A copy(A attr) {
                return attr.copy();
            }
        });
    }

    private AttributeIndexSet(DisjointBitSets<A> subSet) {
        this.disjointBitSets = subSet;
    }

    public void addIndicesToAttribute(A attribute, BitSet indices) {
        this.disjointBitSets.or(attribute, indices);
    }

    public void clear() {
        this.disjointBitSets.clear();
    }

    public void clearAttribute(A attribute) {
        this.disjointBitSets.remove(attribute);
    }

    public void clearIndices(BitSet clearedIndices) {
        this.disjointBitSets.andNot(clearedIndices);
    }

    public void clearIndicesForAttribute(A attribute, BitSet clearedIndices) {
        this.disjointBitSets.andNot(attribute, clearedIndices);
    }

    public AttributeIndexSet<A> copy() {
        return new AttributeIndexSet<A>(this);
    }

    public A getAttribute(int index) {
        return (A)((IAttribute)this.disjointBitSets.getKey(index));
    }

    public Set<A> getAttributes() {
        return this.disjointBitSets.getKeys();
    }

    public BitSet getIndexSet() {
        return this.disjointBitSets.getUnion();
    }

    public BitSet getIndexSet(A attribute) {
        return this.disjointBitSets.getBitSet(attribute);
    }

    public AttributeIndexSet<A> getSubset(BitSet indices) {
        return new AttributeIndexSet<A>(this.disjointBitSets.getSubset(indices));
    }

    public boolean intersects(BitSet indices) {
        return this.disjointBitSets.intersects(indices);
    }

    public boolean isEmpty() {
        return this.disjointBitSets.isEmpty();
    }

    @Override
    public Iterator<DisjointBitSets.Entry<A>> iterator() {
        return this.disjointBitSets.iterator();
    }

    public void setIndicesOfAttribute(A attribute, BitSet indices) {
        this.disjointBitSets.put(attribute, indices);
    }

    public String toString() {
        return this.disjointBitSets.toString();
    }
}

