/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.ui.subsystems;

import com.ibm.icu.text.MessageFormat;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.parser.ParserMessages;
import org.eclipse.cdt.utils.EFSExtensionManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.internal.rdt.core.IRemoteIndexerInfoProvider;
import org.eclipse.ptp.internal.rdt.core.RemoteProjectResourcesUtil;
import org.eclipse.ptp.internal.rdt.core.Serializer;
import org.eclipse.ptp.internal.rdt.core.callhierarchy.CalledByResult;
import org.eclipse.ptp.internal.rdt.core.callhierarchy.CallsToResult;
import org.eclipse.ptp.internal.rdt.core.contentassist.Proposal;
import org.eclipse.ptp.internal.rdt.core.contentassist.RemoteContentAssistInvocationContext;
import org.eclipse.ptp.internal.rdt.core.includebrowser.IIndexIncludeValue;
import org.eclipse.ptp.internal.rdt.core.index.IRemoteFastIndexerUpdateEvent;
import org.eclipse.ptp.internal.rdt.core.index.RemoteIndexerProgress;
import org.eclipse.ptp.internal.rdt.core.index.RemoteIndexerTask;
import org.eclipse.ptp.internal.rdt.core.model.Scope;
import org.eclipse.ptp.internal.rdt.core.navigation.OpenDeclarationResult;
import org.eclipse.ptp.internal.rdt.core.search.RemoteSearchMatch;
import org.eclipse.ptp.internal.rdt.core.search.RemoteSearchQuery;
import org.eclipse.ptp.internal.rdt.core.subsystems.ICIndexSubsystem;
import org.eclipse.ptp.internal.rdt.core.typehierarchy.THGraph;
import org.eclipse.ptp.rdt.core.RDTLog;
import org.eclipse.ptp.rdt.core.serviceproviders.IIndexServiceProvider;
import org.eclipse.ptp.rdt.ui.UIPlugin;
import org.eclipse.ptp.rdt.ui.messages.Messages;
import org.eclipse.ptp.rdt.ui.subsystems.ProjectChangeListener;
import org.eclipse.ptp.services.core.IService;
import org.eclipse.ptp.services.core.IServiceConfiguration;
import org.eclipse.ptp.services.core.IServiceProvider;
import org.eclipse.ptp.services.core.ServiceModelManager;
import org.eclipse.rse.connectorservice.dstore.DStoreConnectorService;
import org.eclipse.rse.connectorservice.dstore.util.StatusMonitor;
import org.eclipse.rse.connectorservice.dstore.util.StatusMonitorFactory;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.SubSystem;
import org.eclipse.rse.services.clientserver.messages.CommonMessages;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.dstore.util.DStoreStatusMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RSECIndexSubsystem
extends SubSystem
implements ICIndexSubsystem {
    private Map<IProject, String> fInitializedProjects = new HashMap<IProject, String>();
    private ProjectChangeListener fProjectOpenListener;
    protected List<String> fErrorMessages = new ArrayList<String>();
    protected boolean fIsInitializing = false;
    protected String miner_class;

    protected RSECIndexSubsystem(IHost host, IConnectorService connectorService) {
        super(host, connectorService);
        this.generateErrorMessages();
        this.setHidden(true);
    }

    private void generateErrorMessages() {
        this.fErrorMessages.add("Unresolved inclusion:");
        this.fErrorMessages.add("Macro definition not found:");
    }

    protected void initializeMinerClass() {
        this.miner_class = "org.eclipse.ptp.internal.rdt.core.miners.CDTMiner";
    }

    public synchronized void initializeSubSystem(IProgressMonitor monitor) throws SystemMessageException {
        block10: {
            boolean isFirstCall = false;
            if (!this.fIsInitializing) {
                this.fIsInitializing = true;
                isFirstCall = true;
            }
            try {
                super.initializeSubSystem(monitor);
                this.initializeMinerClass();
                this.fProjectOpenListener = new ProjectChangeListener(this);
                ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.fProjectOpenListener);
                DataStore dataStore = this.getDataStore(monitor);
                DataElement status = dataStore.activateMiner(this.miner_class);
                if (status == null) break block10;
                DStoreStatusMonitor statusMonitor = new DStoreStatusMonitor(dataStore);
                try {
                    statusMonitor.waitForUpdate(status, monitor);
                }
                catch (InterruptedException e) {
                    UIPlugin.log(e);
                }
                if (status.getValue().equals("failed") && (status = dataStore.activateMiner("org.eclipse.ptp.internal.rdt.core.miners.CDTMiner")) != null) {
                    try {
                        statusMonitor.waitForUpdate(status, monitor);
                    }
                    catch (InterruptedException e) {
                        UIPlugin.log(e);
                    }
                }
            }
            finally {
                if (isFirstCall) {
                    this.fIsInitializing = false;
                }
            }
        }
    }

    public synchronized void uninitializeSubSystem(IProgressMonitor monitor) {
        super.uninitializeSubSystem(monitor);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.fProjectOpenListener);
        this.fInitializedProjects.clear();
    }

    public IStatus reindexScope(Scope scope, IRemoteIndexerInfoProvider provider, String indexLocation, IProgressMonitor monitor, RemoteIndexerTask task) {
        this.removeProblems(scope);
        DataStore dataStore = this.getDataStore(monitor);
        if (dataStore == null) {
            return Status.OK_STATUS;
        }
        DataElement result = this.getDataStore(monitor).createObject(null, "Type.Index.Status", "index");
        StatusMonitor smonitor = StatusMonitorFactory.getInstance().getStatusMonitorFor(this.getConnectorService(), dataStore);
        monitor.beginTask("Rebuilding indexing...", 100);
        DataElement queryCmd = dataStore.localDescriptorQuery(dataStore.getDescriptorRoot(), "C_INDEX_REINDEX");
        if (queryCmd != null) {
            ArrayList<DataElement> args = new ArrayList<DataElement>();
            args.add(dataStore.createObject(null, "Type.Scope.Scopename", scope.getName()));
            args.add(dataStore.createObject(null, "Type.Index.String", scope.getScheme()));
            args.add(dataStore.createObject(null, "Type.Index.String", scope.getRootPath()));
            args.add(dataStore.createObject(null, "Type.Index.String", scope.getMappedPath()));
            args.add(dataStore.createObject(null, "Type.Scope.ConfigLocation", indexLocation));
            String serializedProvider = null;
            try {
                serializedProvider = Serializer.serialize((Object)provider);
            }
            catch (IOException e) {
                RDTLog.logError((Throwable)e);
            }
            args.add(dataStore.createObject(null, "Type.Index.ScannerInfoProvider", serializedProvider));
            DataElement status = dataStore.command(queryCmd, args, result);
            while (!(status.getName().equals("done") || status.getName().equals("cancelled") || monitor.isCanceled() || smonitor.isNetworkDown())) {
                RemoteIndexerProgress progress = this.getIndexerProgress(status);
                task.updateProgressInformation(progress);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    RDTLog.logError((Throwable)e);
                }
            }
            if (smonitor.isNetworkDown()) {
                this.cancelOperation(status.getParent());
                String info = NLS.bind((String)CommonMessages.MSG_CONNECT_UNKNOWNHOST, (Object)this.getConnectorService().getHost().getAliasName());
                String wholeMessage = MessageFormat.format((String)Messages.getString("RSECIndexSubsystem.12"), (Object[])new Object[]{info});
                RDTLog.logError((String)wholeMessage);
            }
            try {
                try {
                    smonitor.waitForUpdate(status, monitor);
                }
                catch (InterruptedException interruptedException) {
                    if (monitor.isCanceled()) {
                        this.cancelOperation(status.getParent());
                    }
                }
            }
            catch (Exception e) {
                RDTLog.logError((Throwable)e);
            }
            if (status.getName().equals("done") || status.getName().equals("cancelled") || monitor.isCanceled() || smonitor.isNetworkDown()) {
                int maxErrors = UIPlugin.getDefault().getPreferenceStore().getInt("org.eclipse.ptp.rdt.ui.INDEXER_ERRORS_DISPLAY_LIMIT");
                int errorsReported = 0;
                int i = 0;
                while (i < status.getNestedSize()) {
                    if (errorsReported >= maxErrors) break;
                    DataElement element = status.get(i);
                    if (element != null && "Type.Indexing.Error".equals(element.getType())) {
                        String message = String.valueOf(element.getAttribute(2)) + ".  ";
                        int j = 0;
                        while (j < this.fErrorMessages.size()) {
                            if (message.indexOf(this.fErrorMessages.get(j)) > 0) {
                                String msg = this.reportProblem(scope, message);
                                ++errorsReported;
                                RDTLog.logWarning((String)msg);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    protected void cancelOperation(DataElement command) {
        DataElement cmdDescriptor;
        DataStore dataStore = command.getDataStore();
        DataElement cancelDescriptor = dataStore.localDescriptorQuery(cmdDescriptor = command.getDescriptor(), "C_CANCEL");
        if (cancelDescriptor != null) {
            dataStore.command(cancelDescriptor, command);
        }
    }

    protected void removeProblems(Scope scope) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot workspaceRoot = workspace.getRoot();
        IProject project = workspaceRoot.getProject(scope.getName());
        try {
            project.deleteMarkers("org.eclipse.ptp.rdt.ui.indexerproblemmarker", true, 2);
        }
        catch (CoreException e) {
            RDTLog.logError((Throwable)e);
        }
    }

    protected String reportProblem(Scope scope, String message) {
        Job job;
        IFile file;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot workspaceRoot = workspace.getRoot();
        final IProject project = workspaceRoot.getProject(scope.getName());
        int errorMessageStart = message.indexOf("Indexer: ");
        int errorMessageEnd = message.indexOf(": ", errorMessageStart + 9);
        String errorMessage = message.substring(errorMessageStart + 9, errorMessageEnd);
        boolean includeError = true;
        if (errorMessage.indexOf("inclusion") < 0) {
            includeError = false;
        }
        int includeStart = errorMessageEnd + 2;
        int includeEnd = message.indexOf(" in file: ", includeStart);
        String include = message.substring(includeStart, includeEnd);
        int fileStart = includeEnd + 10;
        int fileEnd = message.indexOf(":", fileStart);
        String fileName = message.substring(fileStart, fileEnd);
        int lineStart = fileEnd;
        int lineEnd = message.indexOf(".  ", lineStart);
        final String lineNumber = message.substring(lineStart + 1, lineEnd);
        Object[] args = new Object[]{include, fileName, new Integer(lineNumber.replace(",", ""))};
        String info = ParserMessages.getFormattedString((String)"BaseProblemFactory.problemPattern", (Object[])args);
        info = includeError ? ParserMessages.getFormattedString((String)"ScannerProblemFactory.error.preproc.inclusionNotFound", (Object)info) : ParserMessages.getFormattedString((String)"ScannerProblemFactory.error.preproc.definitionNotFound", (Object)info);
        String infoMsg = Messages.getString("RSECIndexSubsystem.11");
        final String wholeMessage = String.valueOf(MessageFormat.format((String)Messages.getString("RSECIndexSubsystem.12"), (Object[])new Object[]{info})) + "  " + infoMsg;
        String projectLocation = project.getLocationURI().getPath();
        fileStart = fileName.indexOf(projectLocation);
        if (fileStart == -1) {
            fileName = null;
            file = null;
        } else {
            fileName = fileName.substring(fileStart + projectLocation.length() + 1);
            Path path = new Path(fileName);
            file = project.getFile((IPath)path);
        }
        if (file != null && file.exists()) {
            job = new Job("createMarker"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        try {
                            IMarker marker = file.createMarker("org.eclipse.ptp.rdt.ui.indexerproblemmarker");
                            marker.setAttribute("lineNumber", Integer.parseInt(lineNumber.replace(",", "")));
                            marker.setAttribute("message", (Object)wholeMessage);
                            marker.setAttribute("severity", 1);
                        }
                        catch (CoreException e) {
                            RDTLog.logError((Throwable)e);
                            monitor.done();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        } else {
            job = new Job("createMarker"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        try {
                            IMarker marker = project.createMarker("org.eclipse.ptp.rdt.ui.indexerproblemmarker");
                            marker.setAttribute("message", (Object)wholeMessage);
                            marker.setAttribute("severity", 1);
                        }
                        catch (CoreException e) {
                            RDTLog.logError((Throwable)e);
                            monitor.done();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
        return wholeMessage;
    }

    public IStatus indexDelta(Scope scope, IRemoteIndexerInfoProvider provider, List<ICElement> newElements, List<ICElement> changedElements, List<ICElement> deletedElements, IProgressMonitor monitor, RemoteIndexerTask task) {
        this.removeProblems(scope);
        DataStore dataStore = this.getDataStore(monitor);
        if (dataStore == null) {
            return Status.OK_STATUS;
        }
        DataElement result = this.getDataStore(monitor).createObject(null, "Type.Index.Status", "index");
        StatusMonitor smonitor = StatusMonitorFactory.getInstance().getStatusMonitorFor(this._connectorService, dataStore);
        int workCount = newElements.size() + changedElements.size();
        monitor.beginTask("Incrementally Indexing...", workCount);
        DataElement queryCmd = dataStore.localDescriptorQuery(dataStore.getDescriptorRoot(), "C_INDEX_DELTA");
        if (queryCmd != null) {
            String remotePath;
            ArrayList<DataElement> args = new ArrayList<DataElement>();
            args.add(dataStore.createObject(null, "Type.Scope.Scopename", scope.getName()));
            args.add(dataStore.createObject(null, "Type.Index.String", scope.getScheme()));
            args.add(dataStore.createObject(null, "Type.Index.String", scope.getRootPath()));
            args.add(dataStore.createObject(null, "Type.Index.String", scope.getMappedPath()));
            args.add(dataStore.createObject(null, "Type.Index.String", scope.getHost()));
            String serializedProvider = null;
            try {
                serializedProvider = Serializer.serialize((Object)provider);
            }
            catch (IOException e) {
                RDTLog.logError((Throwable)e);
            }
            args.add(dataStore.createObject(null, "Type.Index.ScannerInfoProvider", serializedProvider));
            for (ICElement element : newElements) {
                remotePath = this.convertURIToRemotePath(element.getLocationURI());
                args.add(dataStore.createObject(null, "Type.Index.Delta.Added", remotePath));
            }
            for (ICElement element : changedElements) {
                remotePath = this.convertURIToRemotePath(element.getLocationURI());
                args.add(dataStore.createObject(null, "Type.Index.Delta.Changed", remotePath));
            }
            for (ICElement element : deletedElements) {
                remotePath = this.convertURIToRemotePath(element.getLocationURI());
                args.add(dataStore.createObject(null, "Type.Index.Delta.Removed", remotePath));
            }
            DataElement status = dataStore.command(queryCmd, args, result);
            while (!(status.getName().equals("done") || status.getName().equals("cancelled") || monitor.isCanceled() || smonitor.isNetworkDown())) {
                RemoteIndexerProgress progress = this.getIndexerProgress(status);
                task.updateProgressInformation(progress);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    RDTLog.logError((Throwable)e);
                }
            }
            if (smonitor.isNetworkDown()) {
                this.cancelOperation(status.getParent());
                String info = NLS.bind((String)CommonMessages.MSG_CONNECT_UNKNOWNHOST, (Object)this.getConnectorService().getHost().getAliasName());
                String wholeMessage = MessageFormat.format((String)Messages.getString("RSECIndexSubsystem.12"), (Object[])new Object[]{info});
                RDTLog.logError((String)wholeMessage);
            }
            try {
                try {
                    smonitor.waitForUpdate(status, monitor);
                }
                catch (InterruptedException interruptedException) {
                    if (monitor.isCanceled()) {
                        this.cancelOperation(status.getParent());
                    }
                }
            }
            catch (Exception e) {
                RDTLog.logError((Throwable)e);
            }
            if (status.getName().equals("done") || status.getName().equals("cancelled") || monitor.isCanceled() || smonitor.isNetworkDown()) {
                int maxErrors = UIPlugin.getDefault().getPreferenceStore().getInt("org.eclipse.ptp.rdt.ui.INDEXER_ERRORS_DISPLAY_LIMIT");
                int errorsReported = 0;
                int i = 0;
                while (i < status.getNestedSize()) {
                    if (errorsReported >= maxErrors) break;
                    DataElement element = status.get(i);
                    if (element != null && "Type.Indexing.Error".equals(element.getType())) {
                        String message = String.valueOf(element.getAttribute(2)) + ".  ";
                        int j = 0;
                        while (j < this.fErrorMessages.size()) {
                            if (message.indexOf(this.fErrorMessages.get(j)) > 0) {
                                String msg = this.reportProblem(scope, message);
                                ++errorsReported;
                                RDTLog.logWarning((String)msg);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    protected RemoteIndexerProgress getIndexerProgress(DataElement status) {
        int num = status.getNestedSize();
        if (num > 0) {
            boolean foundProgressInfo = false;
            int counter = 1;
            DataElement element = null;
            while (!foundProgressInfo && counter <= num) {
                element = status.get(num - counter);
                if (element != null && "Type.Indexer.ProgressInfo".equals(element.getType())) {
                    foundProgressInfo = true;
                }
                ++counter;
            }
            if (element != null && "Type.Indexer.ProgressInfo".equals(element.getType())) {
                Object result;
                block8: {
                    String data = element.getName();
                    result = Serializer.deserialize((String)data);
                    if (result != null && result instanceof RemoteIndexerProgress) break block8;
                    return null;
                }
                try {
                    RemoteIndexerProgress info = (RemoteIndexerProgress)result;
                    return info;
                }
                catch (IOException e) {
                    RDTLog.logError((Throwable)e);
                }
                catch (ClassNotFoundException e) {
                    RDTLog.logError((Throwable)e);
                }
            }
        }
        return null;
    }

    public synchronized IStatus registerScope(Scope scope, List<ICElement> elements, String configLocation, IProgressMonitor monitor) {
        DataStore dataStore = this.getDataStore(monitor);
        if (dataStore != null) {
            StatusMonitor smonitor = StatusMonitorFactory.getInstance().getStatusMonitorFor(this.getConnectorService(), dataStore);
            monitor.beginTask(Messages.getString("RSECIndexSubsystem.3"), 100);
            DataElement queryCmd = dataStore.localDescriptorQuery(dataStore.getDescriptorRoot(), "C_SCOPE_REGISTER");
            if (queryCmd != null) {
                ArrayList<Object> args = new ArrayList<Object>();
                DataElement scopeElement = dataStore.createObject(null, "Type.Scope.Scopename", scope.getName());
                args.add(scopeElement);
                DataElement dataElement = dataStore.createObject(null, "Type.Index.String", scope.getScheme());
                args.add(dataElement);
                DataElement hostElement = dataStore.createObject(null, "Type.Index.String", scope.getHost());
                args.add(hostElement);
                DataElement rootPath = dataStore.createObject(null, "Type.Index.String", scope.getRootPath());
                args.add(rootPath);
                DataElement mappedPath = dataStore.createObject(null, "Type.Index.String", scope.getMappedPath());
                args.add(mappedPath);
                DataElement configElement = dataStore.createObject(null, "Type.Scope.ConfigLocation", configLocation);
                args.add(configElement);
                for (ICElement element : elements) {
                    this.addElement(dataStore, args, element);
                }
                DataElement status = dataStore.command(queryCmd, args, dataStore.getDescriptorRoot());
                try {
                    smonitor.waitForUpdate(status, monitor);
                }
                catch (Exception e) {
                    RDTLog.logError((Throwable)e);
                }
            }
        }
        return Status.OK_STATUS;
    }

    protected void addElement(DataStore dataStore, ArrayList<Object> args, ICElement element) {
        String filePath = null;
        if (element instanceof ITranslationUnit) {
            filePath = this.convertURIToRemotePath(element.getLocationURI());
        } else if (element instanceof ICContainer || element instanceof ICProject) {
            try {
                ICElement[] children = ((IParent)element).getChildren();
                int k = 0;
                while (k < children.length) {
                    this.addElement(dataStore, args, children[k]);
                    ++k;
                }
            }
            catch (CModelException e) {
                RDTLog.logError((Throwable)e);
            }
        }
        if (filePath != null) {
            DataElement fileElement = dataStore.createObject(null, "Type.Scope.Filename", filePath);
            args.add(fileElement);
        }
    }

    protected String convertURIToRemotePath(URI locationURI) {
        String path = EFSExtensionManager.getDefault().getPathFromURI(locationURI);
        return path;
    }

    public synchronized IStatus unregisterScope(Scope scope, IProgressMonitor monitor) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(scope.getName());
        this.fInitializedProjects.remove(project);
        DataStore dataStore = this.getDataStore(monitor);
        if (dataStore != null) {
            StatusMonitor smonitor = StatusMonitorFactory.getInstance().getStatusMonitorFor(this.getConnectorService(), dataStore);
            monitor.beginTask(Messages.getString("RSECIndexSubsystem.4"), 100);
            DataElement queryCmd = dataStore.localDescriptorQuery(dataStore.getDescriptorRoot(), "C_SCOPE_UNREGISTER");
            if (queryCmd != null) {
                ArrayList<DataElement> args = new ArrayList<DataElement>();
                DataElement scopeElement = dataStore.createObject(null, "Type.Scope.Scopename", scope.getName());
                args.add(scopeElement);
                DataElement status = dataStore.command(queryCmd, args, dataStore.getDescriptorRoot());
                try {
                    smonitor.waitForUpdate(status, monitor);
                }
                catch (Exception e) {
                    RDTLog.logError((Throwable)e);
                }
            }
        }
        return Status.OK_STATUS;
    }

    public IStatus removeIndexFile(Scope scope, IProgressMonitor monitor) {
        this.sendRequest("C_REMOVE_INDEX_FILE", new Object[]{scope}, monitor);
        return Status.OK_STATUS;
    }

    public String moveIndexFile(String scopeName, String newIndexLocation, IProgressMonitor monitor) {
        String actualLocation = this.sendRequestStringResult("C_MOVE_INDEX_FILE", new Object[]{scopeName, newIndexLocation}, monitor);
        return actualLocation;
    }

    public OpenDeclarationResult openDeclaration(Scope scope, ITranslationUnit unit, String selectedText, int selectionStart, int selectionLength, IProgressMonitor monitor) {
        monitor.beginTask(Messages.getString("RSECIndexSubsystem.9"), 100);
        String path = EFSExtensionManager.getDefault().getPathFromURI(unit.getLocationURI());
        Object result = this.sendRequest("C_NAVIGATION_OPEN_DECLARATION", new Object[]{scope, unit, path, selectedText, selectionStart, selectionLength}, monitor);
        if (result == null) {
            return OpenDeclarationResult.failureUnexpectedError();
        }
        return (OpenDeclarationResult)result;
    }

    public CalledByResult getCallers(Scope scope, ICElement subject, IProgressMonitor monitor) {
        monitor.beginTask(String.valueOf(Messages.getString("RSECIndexSubsystem.5")) + subject, 100);
        String path = EFSExtensionManager.getDefault().getPathFromURI(subject.getLocationURI());
        Object result = this.sendRequest("C_CALL_HIERARCHY_GET_CALLERS", new Object[]{scope, this.getHostName(), subject, path}, null);
        if (result == null) {
            return new CalledByResult();
        }
        return (CalledByResult)result;
    }

    public CallsToResult getCallees(Scope scope, ICElement subject, IProgressMonitor monitor) {
        monitor.beginTask(String.valueOf(Messages.getString("RSECIndexSubsystem.6")) + subject, 100);
        String path = EFSExtensionManager.getDefault().getPathFromURI(subject.getLocationURI());
        Object result = this.sendRequest("C_CALL_HIERARCHY_GET_CALLS", new Object[]{scope, this.getHostName(), subject, path}, null);
        if (result == null) {
            return new CallsToResult();
        }
        return (CallsToResult)result;
    }

    public ICElement[] getCHDefinitions(Scope scope, ICElement subject, IProgressMonitor monitor) {
        monitor.beginTask(String.valueOf(Messages.getString("RSECIndexSubsystem.7")) + subject, 100);
        String path = EFSExtensionManager.getDefault().getPathFromURI(subject.getLocationURI());
        Object result = this.sendRequest("C_CALL_HIERARCHY_GET_DEFINITIONS_FROM_ELEMENT", new Object[]{scope, this.getHostName(), subject, path}, null);
        if (result == null) {
            return new ICElement[0];
        }
        return (ICElement[])result;
    }

    public ICElement[] getCHDefinitions(Scope scope, ITranslationUnit unit, int selectionStart, int selectionLength, IProgressMonitor monitor) {
        monitor.beginTask(String.valueOf(Messages.getString("RSECIndexSubsystem.7")) + unit, 100);
        String path = EFSExtensionManager.getDefault().getPathFromURI(unit.getLocationURI());
        Object result = this.sendRequest("C_CALL_HIERARCHY_GET_DEFINITIONS_FROM_WORKING_COPY", new Object[]{scope, this.getHostName(), unit, path, selectionStart, selectionLength}, null);
        if (result == null) {
            return new ICElement[0];
        }
        return (ICElement[])result;
    }

    public List<RemoteSearchMatch> runQuery(Scope scope, RemoteSearchQuery query, IProgressMonitor monitor) {
        monitor.beginTask(String.valueOf(Messages.getString("RSECIndexSubsystem.8")) + query.getScopeDescription(), 100);
        Object result = this.sendRequest("C_SEARCH_RUN_QUERY", new Object[]{scope, this.getHostName(), query}, null);
        if (result == null) {
            return Collections.emptyList();
        }
        return (List)result;
    }

    public List<Proposal> computeCompletionProposals(Scope scope, RemoteContentAssistInvocationContext context, ITranslationUnit unit) {
        this.checkAllProjects((IProgressMonitor)new NullProgressMonitor());
        String path = EFSExtensionManager.getDefault().getPathFromURI(unit.getLocationURI());
        DataStore dataStore = this.getDataStore(null);
        if (dataStore == null) {
            return Collections.emptyList();
        }
        DataElement queryCmd = dataStore.localDescriptorQuery(dataStore.getDescriptorRoot(), "C_CONTENT_ASSIST_COMPUTE_PROPOSALS");
        if (queryCmd == null) {
            return Collections.emptyList();
        }
        NullProgressMonitor monitor = new NullProgressMonitor();
        StatusMonitor smonitor = StatusMonitorFactory.getInstance().getStatusMonitorFor(this.getConnectorService(), dataStore);
        ArrayList<DataElement> args = new ArrayList<DataElement>();
        DataElement dataElement = dataStore.createObject(null, "Type.Scope.Scopename", scope.getName());
        args.add(dataElement);
        args.add(this.createSerializableElement(dataStore, context));
        args.add(this.createSerializableElement(dataStore, unit));
        dataElement = dataStore.createObject(null, "Type.Index.String", path);
        args.add(dataElement);
        DataElement status = dataStore.command(queryCmd, args, dataStore.getDescriptorRoot());
        try {
            smonitor.waitForUpdate(status, (IProgressMonitor)monitor);
        }
        catch (Exception e) {
            RDTLog.logError((Throwable)e);
        }
        DataElement element = status.get(0);
        String data = element.getName();
        try {
            Object result = Serializer.deserialize((String)data);
            if (result == null || !(result instanceof List)) {
                return Collections.emptyList();
            }
            return (List)result;
        }
        catch (IOException e) {
            RDTLog.logError((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            RDTLog.logError((Throwable)e);
        }
        return Collections.emptyList();
    }

    public THGraph computeTypeGraph(Scope scope, ICElement input, IProgressMonitor monitor) {
        String path = EFSExtensionManager.getDefault().getPathFromURI(input.getLocationURI());
        Object result = this.sendRequest("C_TYPE_HIERARCHY_COMPUTE_TYPE_GRAPH", new Object[]{scope, this.getHostName(), input, path}, monitor);
        if (result == null) {
            return new THGraph();
        }
        return (THGraph)result;
    }

    public ICElement[] findTypeHierarchyInput(Scope scope, ICElement memberInput) {
        String path = EFSExtensionManager.getDefault().getPathFromURI(memberInput.getLocationURI());
        Object result = this.sendRequest("C_TYPE_HIERARCHY_FIND_INPUT1", new Object[]{scope, this.getHostName(), memberInput, path}, null);
        if (result == null) {
            return new ICElement[2];
        }
        return (ICElement[])result;
    }

    public ICElement[] findTypeHierarchyInput(Scope scope, ITranslationUnit unit, int selectionStart, int selectionLength) {
        String path = EFSExtensionManager.getDefault().getPathFromURI(unit.getLocationURI());
        Object result = this.sendRequest("C_TYPE_HIERARCHY_FIND_INPUT2", new Object[]{scope, this.getHostName(), unit, path, new Integer(selectionStart), new Integer(selectionLength)}, null);
        if (result == null) {
            return new ICElement[2];
        }
        return (ICElement[])result;
    }

    public Object sendRequest(String requestType, Object[] arguments, IProgressMonitor monitor) {
        return this.sendRequest(requestType, arguments, monitor, true);
    }

    public String sendRequestStringResult(String requestType, Object[] arguments, IProgressMonitor monitor) {
        return (String)this.sendRequest(requestType, arguments, monitor, false);
    }

    private Object sendRequest(String requestType, Object[] arguments, IProgressMonitor monitor, boolean deserializeResult) {
        DataStore dataStore = this.getDataStore(monitor);
        if (dataStore == null) {
            return null;
        }
        DataElement queryCmd = dataStore.localDescriptorQuery(dataStore.getDescriptorRoot(), requestType);
        if (queryCmd == null) {
            return null;
        }
        StatusMonitor statusMonitor = StatusMonitorFactory.getInstance().getStatusMonitorFor(this.getConnectorService(), dataStore);
        ArrayList<DataElement> args = new ArrayList<DataElement>();
        Object[] objectArray = arguments;
        int n = arguments.length;
        int n2 = 0;
        while (n2 < n) {
            DataElement dataElement;
            Object argument = objectArray[n2];
            if (argument instanceof Scope) {
                dataElement = dataStore.createObject(null, "Type.Scope.Scopename", ((Scope)argument).getName());
                args.add(dataElement);
                dataElement = dataStore.createObject(null, "Type.Index.String", ((Scope)argument).getScheme());
                args.add(dataElement);
                DataElement rootPath = dataStore.createObject(null, "Type.Index.String", ((Scope)argument).getRootPath());
                args.add(rootPath);
                DataElement pathElement = dataStore.createObject(null, "Type.Index.String", ((Scope)argument).getMappedPath());
                args.add(pathElement);
            } else if (argument instanceof String) {
                dataElement = dataStore.createObject(null, "Type.Index.String", (String)argument);
                args.add(dataElement);
            } else if (argument instanceof Integer || argument instanceof Boolean || argument instanceof Character || argument instanceof Double || argument instanceof Float) {
                dataElement = dataStore.createObject(null, "Type.Index.String", argument.toString());
                args.add(dataElement);
            } else {
                args.add(this.createSerializableElement(dataStore, argument));
            }
            ++n2;
        }
        DataElement status = dataStore.command(queryCmd, args, dataStore.getDescriptorRoot());
        try {
            monitor = monitor == null ? new NullProgressMonitor() : monitor;
            statusMonitor.waitForUpdate(status, monitor);
        }
        catch (Exception e) {
            RDTLog.logError((Throwable)e);
        }
        DataElement element = status.get(0);
        if (element == null) {
            return null;
        }
        if ("error".equals(element.getType())) {
            RDTLog.logError((String)status.getValue());
            return null;
        }
        String data = element.getName();
        if (!deserializeResult) {
            return data;
        }
        try {
            Object result = Serializer.deserialize((String)data);
            return result;
        }
        catch (IOException e) {
            RDTLog.logError((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            RDTLog.logError((Throwable)e);
        }
        return null;
    }

    private DataElement createSerializableElement(DataStore dataStore, Object object) {
        try {
            String serialized = Serializer.serialize((Object)object);
            return dataStore.createObject(null, "Type.Index.String", serialized);
        }
        catch (IOException e) {
            RDTLog.logError((Throwable)e);
            return null;
        }
    }

    protected synchronized DataStore getDataStore(IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            RSECorePlugin.waitForInitCompletion();
        }
        catch (InterruptedException e) {
            UIPlugin.log(e);
            return null;
        }
        IConnectorService connectorService = this.getConnectorService();
        if (connectorService instanceof DStoreConnectorService) {
            DStoreConnectorService dstoreConnectorService = (DStoreConnectorService)connectorService;
            if (!this.fIsInitializing && !dstoreConnectorService.isConnected()) {
                try {
                    dstoreConnectorService.connect(monitor);
                }
                catch (Exception e) {
                    UIPlugin.log(e);
                }
            }
            return dstoreConnectorService.getDataStore();
        }
        return null;
    }

    public synchronized void checkAllProjects(IProgressMonitor monitor) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot workspaceRoot = workspace.getRoot();
        IProject[] iProjectArray = workspaceRoot.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isOpen()) {
                try {
                    if (project.hasNature("org.eclipse.ptp.rdt.core.remoteNature") && (project.hasNature("org.eclipse.cdt.core.cnature") || project.hasNature("org.eclipse.cdt.core.ccnature"))) {
                        this.checkProject(project, monitor);
                    }
                }
                catch (Throwable e) {
                    RDTLog.logError((Throwable)e);
                }
            }
            ++n2;
        }
    }

    public synchronized void checkProject(IProject project, IProgressMonitor monitor) {
        String projectURI;
        try {
            RSECorePlugin.waitForInitCompletion();
        }
        catch (InterruptedException e) {
            UIPlugin.log(e);
            return;
        }
        IConnectorService connectorService = this.getConnectorService();
        if (!connectorService.isConnected()) {
            try {
                connectorService.connect(monitor);
            }
            catch (Exception e) {
                UIPlugin.log(e);
            }
        }
        if (project == null) {
            return;
        }
        if (this.fInitializedProjects.containsKey(project) && (projectURI = project.getLocationURI().toString()).equals(this.fInitializedProjects.get(project))) {
            return;
        }
        try {
            this.initializeScope(project, monitor);
        }
        catch (CoreException e) {
            RDTLog.logError((Throwable)e);
        }
    }

    private synchronized void initializeScope(IProject project, IProgressMonitor monitor) throws CoreException {
        ServiceModelManager serviceModelManager = ServiceModelManager.getInstance();
        IServiceConfiguration config = serviceModelManager.getActiveConfiguration(project);
        IService service = serviceModelManager.getService("org.eclipse.ptp.rdt.core.CIndexingService");
        IServiceProvider provider = config.getServiceProvider(service);
        List cElements = RemoteProjectResourcesUtil.getCElements((IProject)project);
        Scope scope = new Scope(project);
        String configLocation = ((IIndexServiceProvider)provider).getIndexLocation();
        this.unregisterScope(scope, monitor);
        this.registerScope(scope, cElements, configLocation, monitor);
        String projectURI = project.getLocationURI().toString();
        this.fInitializedProjects.put(project, projectURI);
    }

    public IIndexIncludeValue[] findIncludesTo(Scope scope, IIndexFileLocation location, IProgressMonitor monitor) {
        Object result = this.sendRequest("C_INCLUDES_FIND_INCLUDES_TO", new Object[]{scope, this.getHostName(), location}, monitor);
        if (result == null) {
            return new IIndexIncludeValue[0];
        }
        return (IIndexIncludeValue[])result;
    }

    public IIndexIncludeValue[] findIncludedBy(Scope scope, IIndexFileLocation location, IProgressMonitor monitor) {
        Object result = this.sendRequest("C_INCLUDES_FIND_INCLUDED_BY", new Object[]{scope, this.getHostName(), location}, monitor);
        if (result == null) {
            return new IIndexIncludeValue[0];
        }
        return (IIndexIncludeValue[])result;
    }

    public boolean isIndexed(Scope scope, IIndexFileLocation location, IProgressMonitor monitor) {
        Object result = this.sendRequest("C_INCLUDES_IS_INDEXED", new Object[]{scope, this.getHostName(), location}, monitor);
        if (result != null) {
            return Boolean.parseBoolean(result.toString());
        }
        return false;
    }

    public IIndexIncludeValue findInclude(Scope scope, IIndexFileLocation location, String name, int offset, IProgressMonitor monitor) {
        Object result = this.sendRequest("C_INCLUDES_FIND_INCLUDE", new Object[]{scope, this.getHostName(), location, name, offset}, monitor);
        if (result == null) {
            return null;
        }
        return (IIndexIncludeValue)result;
    }

    public ITranslationUnit getModel(ITranslationUnit unit, IProgressMonitor monitor) {
        Object result = this.sendRequest("C_MODEL_BUILDER", new Object[]{unit}, monitor);
        if (result == null) {
            return null;
        }
        return (ITranslationUnit)result;
    }

    public IRemoteFastIndexerUpdateEvent.EventType getReIndexEventType() {
        return IRemoteFastIndexerUpdateEvent.EventType.EVENT_REINDEX;
    }
}

