/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.internal.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Path;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionChangeEvent;
import org.eclipse.ptp.remote.core.IRemoteConnectionChangeListener;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.exception.RemoteConnectionException;
import org.eclipse.ptp.remote.core.exception.UnableToForwardPortException;
import org.eclipse.ptp.remote.core.messages.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalConnection
implements IRemoteConnection {
    private String fName = Messages.LocalConnection_0;
    private String fAddress = Messages.LocalConnection_1;
    private String fUsername = System.getProperty("user.name");
    private boolean fConnected = true;
    private IPath fWorkingDir = null;
    private final IRemoteConnection fConnection = this;
    private final IRemoteServices fRemoteServices;
    private final ListenerList fListeners = new ListenerList();

    public LocalConnection(IRemoteServices services) {
        this.fRemoteServices = services;
    }

    @Override
    public void addConnectionChangeListener(IRemoteConnectionChangeListener listener) {
        this.fListeners.add((Object)listener);
    }

    @Override
    public void close() {
        if (this.fConnected) {
            this.fConnected = false;
            this.fireConnectionChangeEvent(1);
        }
    }

    @Override
    public void forwardLocalPort(int localPort, String fwdAddress, int fwdPort) throws RemoteConnectionException {
        throw new UnableToForwardPortException(Messages.LocalConnection_2);
    }

    @Override
    public int forwardLocalPort(String fwdAddress, int fwdPort, IProgressMonitor monitor) throws RemoteConnectionException {
        throw new UnableToForwardPortException(Messages.LocalConnection_2);
    }

    @Override
    public void forwardRemotePort(int remotePort, String fwdAddress, int fwdPort) throws RemoteConnectionException {
        throw new UnableToForwardPortException(Messages.LocalConnection_2);
    }

    @Override
    public int forwardRemotePort(String fwdAddress, int fwdPort, IProgressMonitor monitor) throws RemoteConnectionException {
        throw new UnableToForwardPortException(Messages.LocalConnection_2);
    }

    @Override
    public String getAddress() {
        return this.fAddress;
    }

    @Override
    public Map<String, String> getAttributes() {
        return new HashMap<String, String>();
    }

    @Override
    public Map<String, String> getEnv() {
        return System.getenv();
    }

    @Override
    public String getEnv(String name) {
        return System.getenv(name);
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public String getProperty(String key) {
        return System.getProperty(key);
    }

    @Override
    public IRemoteServices getRemoteServices() {
        return this.fRemoteServices;
    }

    @Override
    public String getUsername() {
        return this.fUsername;
    }

    @Override
    public String getWorkingDirectory() {
        if (this.fWorkingDir == null) {
            String cwd = System.getProperty("user.home");
            if (cwd == null) {
                cwd = System.getProperty("user.dir");
            }
            this.fWorkingDir = cwd == null ? Path.ROOT : new Path(cwd);
        }
        return this.fWorkingDir.toString();
    }

    @Override
    public boolean isOpen() {
        return this.fConnected;
    }

    @Override
    public void open(IProgressMonitor monitor) throws RemoteConnectionException {
        if (!this.fConnected) {
            this.fConnected = true;
            this.fireConnectionChangeEvent(2);
        }
    }

    @Override
    public void removeConnectionChangeListener(IRemoteConnectionChangeListener listener) {
        this.fListeners.remove((Object)listener);
    }

    @Override
    public void setAddress(String address) {
        this.fAddress = address;
    }

    @Override
    public void setName(String name) {
        this.fName = name;
        this.fireConnectionChangeEvent(8);
    }

    @Override
    public void setUsername(String username) {
        this.fUsername = username;
    }

    @Override
    public void setWorkingDirectory(String pathStr) {
        Path path = new Path(pathStr);
        if (path.isAbsolute()) {
            this.fWorkingDir = path;
        }
    }

    @Override
    public boolean supportsTCPPortForwarding() {
        return false;
    }

    private void fireConnectionChangeEvent(final int type) {
        IRemoteConnectionChangeEvent event = new IRemoteConnectionChangeEvent(){

            public IRemoteConnection getConnection() {
                return LocalConnection.this.fConnection;
            }

            public int getType() {
                return type;
            }
        };
        Object[] objectArray = this.fListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IRemoteConnectionChangeListener)listener).connectionChanged(event);
            ++n2;
        }
    }
}

